/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.rds.model.DeleteDBInstanceRequest;

public class DeleteDBInstanceRequestMarshaller
implements Marshaller<Request<DeleteDBInstanceRequest>, DeleteDBInstanceRequest> {
    public Request<DeleteDBInstanceRequest> marshall(DeleteDBInstanceRequest deleteDBInstanceRequest) {
        if (deleteDBInstanceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)deleteDBInstanceRequest, "RDSClient");
        request.addParameter("Action", "DeleteDBInstance");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteDBInstanceRequest.dbInstanceIdentifier() != null) {
            request.addParameter("DBInstanceIdentifier", StringUtils.fromString((String)deleteDBInstanceRequest.dbInstanceIdentifier()));
        }
        if (deleteDBInstanceRequest.skipFinalSnapshot() != null) {
            request.addParameter("SkipFinalSnapshot", StringUtils.fromBoolean((Boolean)deleteDBInstanceRequest.skipFinalSnapshot()));
        }
        if (deleteDBInstanceRequest.finalDBSnapshotIdentifier() != null) {
            request.addParameter("FinalDBSnapshotIdentifier", StringUtils.fromString((String)deleteDBInstanceRequest.finalDBSnapshotIdentifier()));
        }
        return request;
    }
}

