/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.rds.model.CreateDBParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.Tag;

public class CreateDBParameterGroupRequestMarshaller
implements Marshaller<Request<CreateDBParameterGroupRequest>, CreateDBParameterGroupRequest> {
    public Request<CreateDBParameterGroupRequest> marshall(CreateDBParameterGroupRequest createDBParameterGroupRequest) {
        List<Tag> tagsList;
        if (createDBParameterGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)createDBParameterGroupRequest, "RDSClient");
        request.addParameter("Action", "CreateDBParameterGroup");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (createDBParameterGroupRequest.dbParameterGroupName() != null) {
            request.addParameter("DBParameterGroupName", StringUtils.fromString((String)createDBParameterGroupRequest.dbParameterGroupName()));
        }
        if (createDBParameterGroupRequest.dbParameterGroupFamily() != null) {
            request.addParameter("DBParameterGroupFamily", StringUtils.fromString((String)createDBParameterGroupRequest.dbParameterGroupFamily()));
        }
        if (createDBParameterGroupRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createDBParameterGroupRequest.description()));
        }
        if ((tagsList = createDBParameterGroupRequest.tags()) != null) {
            if (!tagsList.isEmpty()) {
                int tagsListIndex = 1;
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue.key() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                    }
                    if (tagsListValue.value() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                    }
                    ++tagsListIndex;
                }
            } else {
                request.addParameter("Tags", "");
            }
        }
        return request;
    }
}

