/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.rds.model.CreateDBInstanceRequest;
import software.amazon.awssdk.services.rds.model.Tag;

public class CreateDBInstanceRequestMarshaller
implements Marshaller<Request<CreateDBInstanceRequest>, CreateDBInstanceRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<CreateDBInstanceRequest> marshall(CreateDBInstanceRequest createDBInstanceRequest) {
        List<Tag> tagsList;
        List<String> vpcSecurityGroupIdsList;
        List<String> dBSecurityGroupsList;
        if (createDBInstanceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)createDBInstanceRequest, "RDSClient");
        request.addParameter("Action", "CreateDBInstance");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (createDBInstanceRequest.dbName() != null) {
            request.addParameter("DBName", StringUtils.fromString((String)createDBInstanceRequest.dbName()));
        }
        if (createDBInstanceRequest.dbInstanceIdentifier() != null) {
            request.addParameter("DBInstanceIdentifier", StringUtils.fromString((String)createDBInstanceRequest.dbInstanceIdentifier()));
        }
        if (createDBInstanceRequest.allocatedStorage() != null) {
            request.addParameter("AllocatedStorage", StringUtils.fromInteger((Integer)createDBInstanceRequest.allocatedStorage()));
        }
        if (createDBInstanceRequest.dbInstanceClass() != null) {
            request.addParameter("DBInstanceClass", StringUtils.fromString((String)createDBInstanceRequest.dbInstanceClass()));
        }
        if (createDBInstanceRequest.engine() != null) {
            request.addParameter("Engine", StringUtils.fromString((String)createDBInstanceRequest.engine()));
        }
        if (createDBInstanceRequest.masterUsername() != null) {
            request.addParameter("MasterUsername", StringUtils.fromString((String)createDBInstanceRequest.masterUsername()));
        }
        if (createDBInstanceRequest.masterUserPassword() != null) {
            request.addParameter("MasterUserPassword", StringUtils.fromString((String)createDBInstanceRequest.masterUserPassword()));
        }
        if ((dBSecurityGroupsList = createDBInstanceRequest.dbSecurityGroups()) != null) {
            if (!dBSecurityGroupsList.isEmpty()) {
                int dBSecurityGroupsListIndex = 1;
                for (String string : dBSecurityGroupsList) {
                    if (string != null) {
                        request.addParameter("DBSecurityGroups.DBSecurityGroupName." + dBSecurityGroupsListIndex, StringUtils.fromString((String)string));
                    }
                    ++dBSecurityGroupsListIndex;
                }
            } else {
                request.addParameter("DBSecurityGroups", "");
            }
        }
        if ((vpcSecurityGroupIdsList = createDBInstanceRequest.vpcSecurityGroupIds()) != null) {
            if (!vpcSecurityGroupIdsList.isEmpty()) {
                int vpcSecurityGroupIdsListIndex = 1;
                for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                    if (vpcSecurityGroupIdsListValue != null) {
                        request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringUtils.fromString((String)vpcSecurityGroupIdsListValue));
                    }
                    ++vpcSecurityGroupIdsListIndex;
                }
            } else {
                request.addParameter("VpcSecurityGroupIds", "");
            }
        }
        if (createDBInstanceRequest.availabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString((String)createDBInstanceRequest.availabilityZone()));
        }
        if (createDBInstanceRequest.dbSubnetGroupName() != null) {
            request.addParameter("DBSubnetGroupName", StringUtils.fromString((String)createDBInstanceRequest.dbSubnetGroupName()));
        }
        if (createDBInstanceRequest.preferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringUtils.fromString((String)createDBInstanceRequest.preferredMaintenanceWindow()));
        }
        if (createDBInstanceRequest.dbParameterGroupName() != null) {
            request.addParameter("DBParameterGroupName", StringUtils.fromString((String)createDBInstanceRequest.dbParameterGroupName()));
        }
        if (createDBInstanceRequest.backupRetentionPeriod() != null) {
            request.addParameter("BackupRetentionPeriod", StringUtils.fromInteger((Integer)createDBInstanceRequest.backupRetentionPeriod()));
        }
        if (createDBInstanceRequest.preferredBackupWindow() != null) {
            request.addParameter("PreferredBackupWindow", StringUtils.fromString((String)createDBInstanceRequest.preferredBackupWindow()));
        }
        if (createDBInstanceRequest.port() != null) {
            request.addParameter("Port", StringUtils.fromInteger((Integer)createDBInstanceRequest.port()));
        }
        if (createDBInstanceRequest.multiAZ() != null) {
            request.addParameter("MultiAZ", StringUtils.fromBoolean((Boolean)createDBInstanceRequest.multiAZ()));
        }
        if (createDBInstanceRequest.engineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString((String)createDBInstanceRequest.engineVersion()));
        }
        if (createDBInstanceRequest.autoMinorVersionUpgrade() != null) {
            request.addParameter("AutoMinorVersionUpgrade", StringUtils.fromBoolean((Boolean)createDBInstanceRequest.autoMinorVersionUpgrade()));
        }
        if (createDBInstanceRequest.licenseModel() != null) {
            request.addParameter("LicenseModel", StringUtils.fromString((String)createDBInstanceRequest.licenseModel()));
        }
        if (createDBInstanceRequest.iops() != null) {
            request.addParameter("Iops", StringUtils.fromInteger((Integer)createDBInstanceRequest.iops()));
        }
        if (createDBInstanceRequest.optionGroupName() != null) {
            request.addParameter("OptionGroupName", StringUtils.fromString((String)createDBInstanceRequest.optionGroupName()));
        }
        if (createDBInstanceRequest.characterSetName() != null) {
            request.addParameter("CharacterSetName", StringUtils.fromString((String)createDBInstanceRequest.characterSetName()));
        }
        if (createDBInstanceRequest.publiclyAccessible() != null) {
            request.addParameter("PubliclyAccessible", StringUtils.fromBoolean((Boolean)createDBInstanceRequest.publiclyAccessible()));
        }
        if ((tagsList = createDBInstanceRequest.tags()) != null) {
            if (!tagsList.isEmpty()) {
                boolean bl = true;
                for (Tag tagsListValue : tagsList) {
                    void var6_12;
                    if (tagsListValue.key() != null) {
                        request.addParameter("Tags.Tag." + (int)var6_12 + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                    }
                    if (tagsListValue.value() != null) {
                        request.addParameter("Tags.Tag." + (int)var6_12 + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                    }
                    ++var6_12;
                }
            } else {
                request.addParameter("Tags", "");
            }
        }
        if (createDBInstanceRequest.dbClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringUtils.fromString((String)createDBInstanceRequest.dbClusterIdentifier()));
        }
        if (createDBInstanceRequest.storageType() != null) {
            request.addParameter("StorageType", StringUtils.fromString((String)createDBInstanceRequest.storageType()));
        }
        if (createDBInstanceRequest.tdeCredentialArn() != null) {
            request.addParameter("TdeCredentialArn", StringUtils.fromString((String)createDBInstanceRequest.tdeCredentialArn()));
        }
        if (createDBInstanceRequest.tdeCredentialPassword() != null) {
            request.addParameter("TdeCredentialPassword", StringUtils.fromString((String)createDBInstanceRequest.tdeCredentialPassword()));
        }
        if (createDBInstanceRequest.storageEncrypted() != null) {
            request.addParameter("StorageEncrypted", StringUtils.fromBoolean((Boolean)createDBInstanceRequest.storageEncrypted()));
        }
        if (createDBInstanceRequest.kmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString((String)createDBInstanceRequest.kmsKeyId()));
        }
        if (createDBInstanceRequest.domain() != null) {
            request.addParameter("Domain", StringUtils.fromString((String)createDBInstanceRequest.domain()));
        }
        if (createDBInstanceRequest.copyTagsToSnapshot() != null) {
            request.addParameter("CopyTagsToSnapshot", StringUtils.fromBoolean((Boolean)createDBInstanceRequest.copyTagsToSnapshot()));
        }
        if (createDBInstanceRequest.monitoringInterval() != null) {
            request.addParameter("MonitoringInterval", StringUtils.fromInteger((Integer)createDBInstanceRequest.monitoringInterval()));
        }
        if (createDBInstanceRequest.monitoringRoleArn() != null) {
            request.addParameter("MonitoringRoleArn", StringUtils.fromString((String)createDBInstanceRequest.monitoringRoleArn()));
        }
        if (createDBInstanceRequest.domainIAMRoleName() != null) {
            request.addParameter("DomainIAMRoleName", StringUtils.fromString((String)createDBInstanceRequest.domainIAMRoleName()));
        }
        if (createDBInstanceRequest.promotionTier() != null) {
            request.addParameter("PromotionTier", StringUtils.fromInteger((Integer)createDBInstanceRequest.promotionTier()));
        }
        if (createDBInstanceRequest.timezone() != null) {
            request.addParameter("Timezone", StringUtils.fromString((String)createDBInstanceRequest.timezone()));
        }
        if (createDBInstanceRequest.enableIAMDatabaseAuthentication() != null) {
            request.addParameter("EnableIAMDatabaseAuthentication", StringUtils.fromBoolean((Boolean)createDBInstanceRequest.enableIAMDatabaseAuthentication()));
        }
        if (createDBInstanceRequest.enablePerformanceInsights() != null) {
            request.addParameter("EnablePerformanceInsights", StringUtils.fromBoolean((Boolean)createDBInstanceRequest.enablePerformanceInsights()));
        }
        if (createDBInstanceRequest.performanceInsightsKMSKeyId() != null) {
            request.addParameter("PerformanceInsightsKMSKeyId", StringUtils.fromString((String)createDBInstanceRequest.performanceInsightsKMSKeyId()));
        }
        return request;
    }
}

