/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.rds.RDSClient;
import software.amazon.awssdk.services.rds.model.DescribeReservedDBInstancesRequest;
import software.amazon.awssdk.services.rds.model.DescribeReservedDBInstancesResponse;
import software.amazon.awssdk.services.rds.model.ReservedDBInstance;

public class DescribeReservedDBInstancesIterable
implements SdkIterable<DescribeReservedDBInstancesResponse> {
    private final RDSClient client;
    private final DescribeReservedDBInstancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeReservedDBInstancesIterable(RDSClient client, DescribeReservedDBInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeReservedDBInstancesResponseFetcher();
    }

    public Iterator<DescribeReservedDBInstancesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<ReservedDBInstance> reservedDBInstances() {
        Function<DescribeReservedDBInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.reservedDBInstances() != null) {
                return response.reservedDBInstances().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeReservedDBInstancesIterable resume(DescribeReservedDBInstancesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeReservedDBInstancesIterable(this.client, (DescribeReservedDBInstancesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeReservedDBInstancesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeReservedDBInstancesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeReservedDBInstancesResponseFetcher
    implements SyncPageFetcher<DescribeReservedDBInstancesResponse> {
        private DescribeReservedDBInstancesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedDBInstancesResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeReservedDBInstancesResponse nextPage(DescribeReservedDBInstancesResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedDBInstancesIterable.this.client.describeReservedDBInstances(DescribeReservedDBInstancesIterable.this.firstRequest);
            }
            return DescribeReservedDBInstancesIterable.this.client.describeReservedDBInstances((DescribeReservedDBInstancesRequest)((Object)DescribeReservedDBInstancesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

