/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.rds.RDSClient;
import software.amazon.awssdk.services.rds.model.DescribeOrderableDBInstanceOptionsRequest;
import software.amazon.awssdk.services.rds.model.DescribeOrderableDBInstanceOptionsResponse;
import software.amazon.awssdk.services.rds.model.OrderableDBInstanceOption;

public class DescribeOrderableDBInstanceOptionsIterable
implements SdkIterable<DescribeOrderableDBInstanceOptionsResponse> {
    private final RDSClient client;
    private final DescribeOrderableDBInstanceOptionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeOrderableDBInstanceOptionsIterable(RDSClient client, DescribeOrderableDBInstanceOptionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeOrderableDBInstanceOptionsResponseFetcher();
    }

    public Iterator<DescribeOrderableDBInstanceOptionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<OrderableDBInstanceOption> orderableDBInstanceOptions() {
        Function<DescribeOrderableDBInstanceOptionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.orderableDBInstanceOptions() != null) {
                return response.orderableDBInstanceOptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeOrderableDBInstanceOptionsIterable resume(DescribeOrderableDBInstanceOptionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeOrderableDBInstanceOptionsIterable(this.client, (DescribeOrderableDBInstanceOptionsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeOrderableDBInstanceOptionsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeOrderableDBInstanceOptionsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeOrderableDBInstanceOptionsResponseFetcher
    implements SyncPageFetcher<DescribeOrderableDBInstanceOptionsResponse> {
        private DescribeOrderableDBInstanceOptionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeOrderableDBInstanceOptionsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeOrderableDBInstanceOptionsResponse nextPage(DescribeOrderableDBInstanceOptionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeOrderableDBInstanceOptionsIterable.this.client.describeOrderableDBInstanceOptions(DescribeOrderableDBInstanceOptionsIterable.this.firstRequest);
            }
            return DescribeOrderableDBInstanceOptionsIterable.this.client.describeOrderableDBInstanceOptions((DescribeOrderableDBInstanceOptionsRequest)((Object)DescribeOrderableDBInstanceOptionsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

