/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.rds.RDSClient;
import software.amazon.awssdk.services.rds.model.DescribeOptionGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeOptionGroupsResponse;
import software.amazon.awssdk.services.rds.model.OptionGroup;

public class DescribeOptionGroupsIterable
implements SdkIterable<DescribeOptionGroupsResponse> {
    private final RDSClient client;
    private final DescribeOptionGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeOptionGroupsIterable(RDSClient client, DescribeOptionGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeOptionGroupsResponseFetcher();
    }

    public Iterator<DescribeOptionGroupsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<OptionGroup> optionGroupsList() {
        Function<DescribeOptionGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.optionGroupsList() != null) {
                return response.optionGroupsList().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeOptionGroupsIterable resume(DescribeOptionGroupsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeOptionGroupsIterable(this.client, (DescribeOptionGroupsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeOptionGroupsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeOptionGroupsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeOptionGroupsResponseFetcher
    implements SyncPageFetcher<DescribeOptionGroupsResponse> {
        private DescribeOptionGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeOptionGroupsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeOptionGroupsResponse nextPage(DescribeOptionGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeOptionGroupsIterable.this.client.describeOptionGroups(DescribeOptionGroupsIterable.this.firstRequest);
            }
            return DescribeOptionGroupsIterable.this.client.describeOptionGroups((DescribeOptionGroupsRequest)((Object)DescribeOptionGroupsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

