/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.rds.RDSClient;
import software.amazon.awssdk.services.rds.model.DBSnapshot;
import software.amazon.awssdk.services.rds.model.DescribeDBSnapshotsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDBSnapshotsResponse;

public class DescribeDBSnapshotsIterable
implements SdkIterable<DescribeDBSnapshotsResponse> {
    private final RDSClient client;
    private final DescribeDBSnapshotsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDBSnapshotsIterable(RDSClient client, DescribeDBSnapshotsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDBSnapshotsResponseFetcher();
    }

    public Iterator<DescribeDBSnapshotsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<DBSnapshot> dbSnapshots() {
        Function<DescribeDBSnapshotsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbSnapshots() != null) {
                return response.dbSnapshots().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeDBSnapshotsIterable resume(DescribeDBSnapshotsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeDBSnapshotsIterable(this.client, (DescribeDBSnapshotsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeDBSnapshotsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeDBSnapshotsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeDBSnapshotsResponseFetcher
    implements SyncPageFetcher<DescribeDBSnapshotsResponse> {
        private DescribeDBSnapshotsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDBSnapshotsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeDBSnapshotsResponse nextPage(DescribeDBSnapshotsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBSnapshotsIterable.this.client.describeDBSnapshots(DescribeDBSnapshotsIterable.this.firstRequest);
            }
            return DescribeDBSnapshotsIterable.this.client.describeDBSnapshots((DescribeDBSnapshotsRequest)((Object)DescribeDBSnapshotsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

