/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.rds.RDSClient;
import software.amazon.awssdk.services.rds.model.DBSecurityGroup;
import software.amazon.awssdk.services.rds.model.DescribeDBSecurityGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDBSecurityGroupsResponse;

public class DescribeDBSecurityGroupsIterable
implements SdkIterable<DescribeDBSecurityGroupsResponse> {
    private final RDSClient client;
    private final DescribeDBSecurityGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDBSecurityGroupsIterable(RDSClient client, DescribeDBSecurityGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDBSecurityGroupsResponseFetcher();
    }

    public Iterator<DescribeDBSecurityGroupsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<DBSecurityGroup> dbSecurityGroups() {
        Function<DescribeDBSecurityGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbSecurityGroups() != null) {
                return response.dbSecurityGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeDBSecurityGroupsIterable resume(DescribeDBSecurityGroupsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeDBSecurityGroupsIterable(this.client, (DescribeDBSecurityGroupsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeDBSecurityGroupsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeDBSecurityGroupsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeDBSecurityGroupsResponseFetcher
    implements SyncPageFetcher<DescribeDBSecurityGroupsResponse> {
        private DescribeDBSecurityGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDBSecurityGroupsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeDBSecurityGroupsResponse nextPage(DescribeDBSecurityGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBSecurityGroupsIterable.this.client.describeDBSecurityGroups(DescribeDBSecurityGroupsIterable.this.firstRequest);
            }
            return DescribeDBSecurityGroupsIterable.this.client.describeDBSecurityGroups((DescribeDBSecurityGroupsRequest)((Object)DescribeDBSecurityGroupsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

