/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.rds.RDSAsyncClient;
import software.amazon.awssdk.services.rds.model.DBEngineVersion;
import software.amazon.awssdk.services.rds.model.DescribeDBEngineVersionsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDBEngineVersionsResponse;

public class DescribeDBEngineVersionsPublisher
implements SdkPublisher<DescribeDBEngineVersionsResponse> {
    private final RDSAsyncClient client;
    private final DescribeDBEngineVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDBEngineVersionsPublisher(RDSAsyncClient client, DescribeDBEngineVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDBEngineVersionsPublisher(RDSAsyncClient client, DescribeDBEngineVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDBEngineVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDBEngineVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<DBEngineVersion> dbEngineVersions() {
        Function<DescribeDBEngineVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbEngineVersions() != null) {
                return response.dbEngineVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeDBEngineVersionsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeDBEngineVersionsPublisher resume(DescribeDBEngineVersionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeDBEngineVersionsPublisher(this.client, (DescribeDBEngineVersionsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeDBEngineVersionsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeDBEngineVersionsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeDBEngineVersionsResponseFetcher
    implements AsyncPageFetcher<DescribeDBEngineVersionsResponse> {
        private DescribeDBEngineVersionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDBEngineVersionsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public CompletableFuture<DescribeDBEngineVersionsResponse> nextPage(DescribeDBEngineVersionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBEngineVersionsPublisher.this.client.describeDBEngineVersions(DescribeDBEngineVersionsPublisher.this.firstRequest);
            }
            return DescribeDBEngineVersionsPublisher.this.client.describeDBEngineVersions((DescribeDBEngineVersionsRequest)((Object)DescribeDBEngineVersionsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

