/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.rds.model.RDSRequest;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.services.rds.model.VpcSecurityGroupIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RestoreDBClusterToPointInTimeRequest
extends RDSRequest
implements ToCopyableBuilder<Builder, RestoreDBClusterToPointInTimeRequest> {
    private final String dbClusterIdentifier;
    private final String restoreType;
    private final String sourceDBClusterIdentifier;
    private final Instant restoreToTime;
    private final Boolean useLatestRestorableTime;
    private final Integer port;
    private final String dbSubnetGroupName;
    private final String optionGroupName;
    private final List<String> vpcSecurityGroupIds;
    private final List<Tag> tags;
    private final String kmsKeyId;
    private final Boolean enableIAMDatabaseAuthentication;

    private RestoreDBClusterToPointInTimeRequest(BuilderImpl builder) {
        super(builder);
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.restoreType = builder.restoreType;
        this.sourceDBClusterIdentifier = builder.sourceDBClusterIdentifier;
        this.restoreToTime = builder.restoreToTime;
        this.useLatestRestorableTime = builder.useLatestRestorableTime;
        this.port = builder.port;
        this.dbSubnetGroupName = builder.dbSubnetGroupName;
        this.optionGroupName = builder.optionGroupName;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.tags = builder.tags;
        this.kmsKeyId = builder.kmsKeyId;
        this.enableIAMDatabaseAuthentication = builder.enableIAMDatabaseAuthentication;
    }

    public String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public String restoreType() {
        return this.restoreType;
    }

    public String sourceDBClusterIdentifier() {
        return this.sourceDBClusterIdentifier;
    }

    public Instant restoreToTime() {
        return this.restoreToTime;
    }

    public Boolean useLatestRestorableTime() {
        return this.useLatestRestorableTime;
    }

    public Integer port() {
        return this.port;
    }

    public String dbSubnetGroupName() {
        return this.dbSubnetGroupName;
    }

    public String optionGroupName() {
        return this.optionGroupName;
    }

    public List<String> vpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public Boolean enableIAMDatabaseAuthentication() {
        return this.enableIAMDatabaseAuthentication;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.restoreType());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDBClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.restoreToTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.useLatestRestorableTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcSecurityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableIAMDatabaseAuthentication());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreDBClusterToPointInTimeRequest)) {
            return false;
        }
        RestoreDBClusterToPointInTimeRequest other = (RestoreDBClusterToPointInTimeRequest)((Object)obj);
        return Objects.equals(this.dbClusterIdentifier(), other.dbClusterIdentifier()) && Objects.equals(this.restoreType(), other.restoreType()) && Objects.equals(this.sourceDBClusterIdentifier(), other.sourceDBClusterIdentifier()) && Objects.equals(this.restoreToTime(), other.restoreToTime()) && Objects.equals(this.useLatestRestorableTime(), other.useLatestRestorableTime()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.dbSubnetGroupName(), other.dbSubnetGroupName()) && Objects.equals(this.optionGroupName(), other.optionGroupName()) && Objects.equals(this.vpcSecurityGroupIds(), other.vpcSecurityGroupIds()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.enableIAMDatabaseAuthentication(), other.enableIAMDatabaseAuthentication());
    }

    public String toString() {
        return ToString.builder((String)"RestoreDBClusterToPointInTimeRequest").add("DBClusterIdentifier", (Object)this.dbClusterIdentifier()).add("RestoreType", (Object)this.restoreType()).add("SourceDBClusterIdentifier", (Object)this.sourceDBClusterIdentifier()).add("RestoreToTime", (Object)this.restoreToTime()).add("UseLatestRestorableTime", (Object)this.useLatestRestorableTime()).add("Port", (Object)this.port()).add("DBSubnetGroupName", (Object)this.dbSubnetGroupName()).add("OptionGroupName", (Object)this.optionGroupName()).add("VpcSecurityGroupIds", this.vpcSecurityGroupIds()).add("Tags", this.tags()).add("KmsKeyId", (Object)this.kmsKeyId()).add("EnableIAMDatabaseAuthentication", (Object)this.enableIAMDatabaseAuthentication()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBClusterIdentifier": {
                return Optional.of(clazz.cast(this.dbClusterIdentifier()));
            }
            case "RestoreType": {
                return Optional.of(clazz.cast(this.restoreType()));
            }
            case "SourceDBClusterIdentifier": {
                return Optional.of(clazz.cast(this.sourceDBClusterIdentifier()));
            }
            case "RestoreToTime": {
                return Optional.of(clazz.cast(this.restoreToTime()));
            }
            case "UseLatestRestorableTime": {
                return Optional.of(clazz.cast(this.useLatestRestorableTime()));
            }
            case "Port": {
                return Optional.of(clazz.cast(this.port()));
            }
            case "DBSubnetGroupName": {
                return Optional.of(clazz.cast(this.dbSubnetGroupName()));
            }
            case "OptionGroupName": {
                return Optional.of(clazz.cast(this.optionGroupName()));
            }
            case "VpcSecurityGroupIds": {
                return Optional.of(clazz.cast(this.vpcSecurityGroupIds()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
            case "KmsKeyId": {
                return Optional.of(clazz.cast(this.kmsKeyId()));
            }
            case "EnableIAMDatabaseAuthentication": {
                return Optional.of(clazz.cast(this.enableIAMDatabaseAuthentication()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RDSRequest.BuilderImpl
    implements Builder {
        private String dbClusterIdentifier;
        private String restoreType;
        private String sourceDBClusterIdentifier;
        private Instant restoreToTime;
        private Boolean useLatestRestorableTime;
        private Integer port;
        private String dbSubnetGroupName;
        private String optionGroupName;
        private List<String> vpcSecurityGroupIds;
        private List<Tag> tags;
        private String kmsKeyId;
        private Boolean enableIAMDatabaseAuthentication;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreDBClusterToPointInTimeRequest model) {
            this.dbClusterIdentifier(model.dbClusterIdentifier);
            this.restoreType(model.restoreType);
            this.sourceDBClusterIdentifier(model.sourceDBClusterIdentifier);
            this.restoreToTime(model.restoreToTime);
            this.useLatestRestorableTime(model.useLatestRestorableTime);
            this.port(model.port);
            this.dbSubnetGroupName(model.dbSubnetGroupName);
            this.optionGroupName(model.optionGroupName);
            this.vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            this.tags(model.tags);
            this.kmsKeyId(model.kmsKeyId);
            this.enableIAMDatabaseAuthentication(model.enableIAMDatabaseAuthentication);
        }

        public final String getDBClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final void setDBClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        public final String getRestoreType() {
            return this.restoreType;
        }

        @Override
        public final Builder restoreType(String restoreType) {
            this.restoreType = restoreType;
            return this;
        }

        public final void setRestoreType(String restoreType) {
            this.restoreType = restoreType;
        }

        public final String getSourceDBClusterIdentifier() {
            return this.sourceDBClusterIdentifier;
        }

        @Override
        public final Builder sourceDBClusterIdentifier(String sourceDBClusterIdentifier) {
            this.sourceDBClusterIdentifier = sourceDBClusterIdentifier;
            return this;
        }

        public final void setSourceDBClusterIdentifier(String sourceDBClusterIdentifier) {
            this.sourceDBClusterIdentifier = sourceDBClusterIdentifier;
        }

        public final Instant getRestoreToTime() {
            return this.restoreToTime;
        }

        @Override
        public final Builder restoreToTime(Instant restoreToTime) {
            this.restoreToTime = restoreToTime;
            return this;
        }

        public final void setRestoreToTime(Instant restoreToTime) {
            this.restoreToTime = restoreToTime;
        }

        public final Boolean getUseLatestRestorableTime() {
            return this.useLatestRestorableTime;
        }

        @Override
        public final Builder useLatestRestorableTime(Boolean useLatestRestorableTime) {
            this.useLatestRestorableTime = useLatestRestorableTime;
            return this;
        }

        public final void setUseLatestRestorableTime(Boolean useLatestRestorableTime) {
            this.useLatestRestorableTime = useLatestRestorableTime;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getDBSubnetGroupName() {
            return this.dbSubnetGroupName;
        }

        @Override
        public final Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        public final void setDBSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
        }

        public final String getOptionGroupName() {
            return this.optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            return this.vpcSecurityGroupIds;
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Boolean getEnableIAMDatabaseAuthentication() {
            return this.enableIAMDatabaseAuthentication;
        }

        @Override
        public final Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
            return this;
        }

        public final void setEnableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public RestoreDBClusterToPointInTimeRequest build() {
            return new RestoreDBClusterToPointInTimeRequest(this);
        }
    }

    public static interface Builder
    extends RDSRequest.Builder,
    CopyableBuilder<Builder, RestoreDBClusterToPointInTimeRequest> {
        public Builder dbClusterIdentifier(String var1);

        public Builder restoreType(String var1);

        public Builder sourceDBClusterIdentifier(String var1);

        public Builder restoreToTime(Instant var1);

        public Builder useLatestRestorableTime(Boolean var1);

        public Builder port(Integer var1);

        public Builder dbSubnetGroupName(String var1);

        public Builder optionGroupName(String var1);

        public Builder vpcSecurityGroupIds(Collection<String> var1);

        public Builder vpcSecurityGroupIds(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder kmsKeyId(String var1);

        public Builder enableIAMDatabaseAuthentication(Boolean var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

