/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.rds.model.AttributeValueListCopier;
import software.amazon.awssdk.services.rds.model.RDSRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyDBClusterSnapshotAttributeRequest
extends RDSRequest
implements ToCopyableBuilder<Builder, ModifyDBClusterSnapshotAttributeRequest> {
    private final String dbClusterSnapshotIdentifier;
    private final String attributeName;
    private final List<String> valuesToAdd;
    private final List<String> valuesToRemove;

    private ModifyDBClusterSnapshotAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.dbClusterSnapshotIdentifier = builder.dbClusterSnapshotIdentifier;
        this.attributeName = builder.attributeName;
        this.valuesToAdd = builder.valuesToAdd;
        this.valuesToRemove = builder.valuesToRemove;
    }

    public String dbClusterSnapshotIdentifier() {
        return this.dbClusterSnapshotIdentifier;
    }

    public String attributeName() {
        return this.attributeName;
    }

    public List<String> valuesToAdd() {
        return this.valuesToAdd;
    }

    public List<String> valuesToRemove() {
        return this.valuesToRemove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.valuesToAdd());
        hashCode = 31 * hashCode + Objects.hashCode(this.valuesToRemove());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDBClusterSnapshotAttributeRequest)) {
            return false;
        }
        ModifyDBClusterSnapshotAttributeRequest other = (ModifyDBClusterSnapshotAttributeRequest)((Object)obj);
        return Objects.equals(this.dbClusterSnapshotIdentifier(), other.dbClusterSnapshotIdentifier()) && Objects.equals(this.attributeName(), other.attributeName()) && Objects.equals(this.valuesToAdd(), other.valuesToAdd()) && Objects.equals(this.valuesToRemove(), other.valuesToRemove());
    }

    public String toString() {
        return ToString.builder((String)"ModifyDBClusterSnapshotAttributeRequest").add("DBClusterSnapshotIdentifier", (Object)this.dbClusterSnapshotIdentifier()).add("AttributeName", (Object)this.attributeName()).add("ValuesToAdd", this.valuesToAdd()).add("ValuesToRemove", this.valuesToRemove()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBClusterSnapshotIdentifier": {
                return Optional.of(clazz.cast(this.dbClusterSnapshotIdentifier()));
            }
            case "AttributeName": {
                return Optional.of(clazz.cast(this.attributeName()));
            }
            case "ValuesToAdd": {
                return Optional.of(clazz.cast(this.valuesToAdd()));
            }
            case "ValuesToRemove": {
                return Optional.of(clazz.cast(this.valuesToRemove()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RDSRequest.BuilderImpl
    implements Builder {
        private String dbClusterSnapshotIdentifier;
        private String attributeName;
        private List<String> valuesToAdd;
        private List<String> valuesToRemove;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDBClusterSnapshotAttributeRequest model) {
            this.dbClusterSnapshotIdentifier(model.dbClusterSnapshotIdentifier);
            this.attributeName(model.attributeName);
            this.valuesToAdd(model.valuesToAdd);
            this.valuesToRemove(model.valuesToRemove);
        }

        public final String getDBClusterSnapshotIdentifier() {
            return this.dbClusterSnapshotIdentifier;
        }

        @Override
        public final Builder dbClusterSnapshotIdentifier(String dbClusterSnapshotIdentifier) {
            this.dbClusterSnapshotIdentifier = dbClusterSnapshotIdentifier;
            return this;
        }

        public final void setDBClusterSnapshotIdentifier(String dbClusterSnapshotIdentifier) {
            this.dbClusterSnapshotIdentifier = dbClusterSnapshotIdentifier;
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public final Collection<String> getValuesToAdd() {
            return this.valuesToAdd;
        }

        @Override
        public final Builder valuesToAdd(Collection<String> valuesToAdd) {
            this.valuesToAdd = AttributeValueListCopier.copy(valuesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder valuesToAdd(String ... valuesToAdd) {
            this.valuesToAdd(Arrays.asList(valuesToAdd));
            return this;
        }

        public final void setValuesToAdd(Collection<String> valuesToAdd) {
            this.valuesToAdd = AttributeValueListCopier.copy(valuesToAdd);
        }

        public final Collection<String> getValuesToRemove() {
            return this.valuesToRemove;
        }

        @Override
        public final Builder valuesToRemove(Collection<String> valuesToRemove) {
            this.valuesToRemove = AttributeValueListCopier.copy(valuesToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder valuesToRemove(String ... valuesToRemove) {
            this.valuesToRemove(Arrays.asList(valuesToRemove));
            return this;
        }

        public final void setValuesToRemove(Collection<String> valuesToRemove) {
            this.valuesToRemove = AttributeValueListCopier.copy(valuesToRemove);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ModifyDBClusterSnapshotAttributeRequest build() {
            return new ModifyDBClusterSnapshotAttributeRequest(this);
        }
    }

    public static interface Builder
    extends RDSRequest.Builder,
    CopyableBuilder<Builder, ModifyDBClusterSnapshotAttributeRequest> {
        public Builder dbClusterSnapshotIdentifier(String var1);

        public Builder attributeName(String var1);

        public Builder valuesToAdd(Collection<String> var1);

        public Builder valuesToAdd(String ... var1);

        public Builder valuesToRemove(Collection<String> var1);

        public Builder valuesToRemove(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

