/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.rds.model.RDSRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DownloadDBLogFilePortionRequest
extends RDSRequest
implements ToCopyableBuilder<Builder, DownloadDBLogFilePortionRequest> {
    private final String dbInstanceIdentifier;
    private final String logFileName;
    private final String marker;
    private final Integer numberOfLines;

    private DownloadDBLogFilePortionRequest(BuilderImpl builder) {
        super(builder);
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.logFileName = builder.logFileName;
        this.marker = builder.marker;
        this.numberOfLines = builder.numberOfLines;
    }

    public String dbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public String logFileName() {
        return this.logFileName;
    }

    public String marker() {
        return this.marker;
    }

    public Integer numberOfLines() {
        return this.numberOfLines;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.logFileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfLines());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DownloadDBLogFilePortionRequest)) {
            return false;
        }
        DownloadDBLogFilePortionRequest other = (DownloadDBLogFilePortionRequest)((Object)obj);
        return Objects.equals(this.dbInstanceIdentifier(), other.dbInstanceIdentifier()) && Objects.equals(this.logFileName(), other.logFileName()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.numberOfLines(), other.numberOfLines());
    }

    public String toString() {
        return ToString.builder((String)"DownloadDBLogFilePortionRequest").add("DBInstanceIdentifier", (Object)this.dbInstanceIdentifier()).add("LogFileName", (Object)this.logFileName()).add("Marker", (Object)this.marker()).add("NumberOfLines", (Object)this.numberOfLines()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBInstanceIdentifier": {
                return Optional.of(clazz.cast(this.dbInstanceIdentifier()));
            }
            case "LogFileName": {
                return Optional.of(clazz.cast(this.logFileName()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "NumberOfLines": {
                return Optional.of(clazz.cast(this.numberOfLines()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RDSRequest.BuilderImpl
    implements Builder {
        private String dbInstanceIdentifier;
        private String logFileName;
        private String marker;
        private Integer numberOfLines;

        private BuilderImpl() {
        }

        private BuilderImpl(DownloadDBLogFilePortionRequest model) {
            this.dbInstanceIdentifier(model.dbInstanceIdentifier);
            this.logFileName(model.logFileName);
            this.marker(model.marker);
            this.numberOfLines(model.numberOfLines);
        }

        public final String getDBInstanceIdentifier() {
            return this.dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final void setDBInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        public final String getLogFileName() {
            return this.logFileName;
        }

        @Override
        public final Builder logFileName(String logFileName) {
            this.logFileName = logFileName;
            return this;
        }

        public final void setLogFileName(String logFileName) {
            this.logFileName = logFileName;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getNumberOfLines() {
            return this.numberOfLines;
        }

        @Override
        public final Builder numberOfLines(Integer numberOfLines) {
            this.numberOfLines = numberOfLines;
            return this;
        }

        public final void setNumberOfLines(Integer numberOfLines) {
            this.numberOfLines = numberOfLines;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DownloadDBLogFilePortionRequest build() {
            return new DownloadDBLogFilePortionRequest(this);
        }
    }

    public static interface Builder
    extends RDSRequest.Builder,
    CopyableBuilder<Builder, DownloadDBLogFilePortionRequest> {
        public Builder dbInstanceIdentifier(String var1);

        public Builder logFileName(String var1);

        public Builder marker(String var1);

        public Builder numberOfLines(Integer var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

