/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.rds.model.AvailabilityZonesCopier;
import software.amazon.awssdk.services.rds.model.DBClusterMember;
import software.amazon.awssdk.services.rds.model.DBClusterMemberListCopier;
import software.amazon.awssdk.services.rds.model.DBClusterOptionGroupMembershipsCopier;
import software.amazon.awssdk.services.rds.model.DBClusterOptionGroupStatus;
import software.amazon.awssdk.services.rds.model.DBClusterRole;
import software.amazon.awssdk.services.rds.model.DBClusterRolesCopier;
import software.amazon.awssdk.services.rds.model.ReadReplicaIdentifierListCopier;
import software.amazon.awssdk.services.rds.model.VpcSecurityGroupMembership;
import software.amazon.awssdk.services.rds.model.VpcSecurityGroupMembershipListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DBCluster
implements ToCopyableBuilder<Builder, DBCluster> {
    private final Integer allocatedStorage;
    private final List<String> availabilityZones;
    private final Integer backupRetentionPeriod;
    private final String characterSetName;
    private final String databaseName;
    private final String dbClusterIdentifier;
    private final String dbClusterParameterGroup;
    private final String dbSubnetGroup;
    private final String status;
    private final String percentProgress;
    private final Instant earliestRestorableTime;
    private final String endpoint;
    private final String readerEndpoint;
    private final Boolean multiAZ;
    private final String engine;
    private final String engineVersion;
    private final Instant latestRestorableTime;
    private final Integer port;
    private final String masterUsername;
    private final List<DBClusterOptionGroupStatus> dbClusterOptionGroupMemberships;
    private final String preferredBackupWindow;
    private final String preferredMaintenanceWindow;
    private final String replicationSourceIdentifier;
    private final List<String> readReplicaIdentifiers;
    private final List<DBClusterMember> dbClusterMembers;
    private final List<VpcSecurityGroupMembership> vpcSecurityGroups;
    private final String hostedZoneId;
    private final Boolean storageEncrypted;
    private final String kmsKeyId;
    private final String dbClusterResourceId;
    private final String dbClusterArn;
    private final List<DBClusterRole> associatedRoles;
    private final Boolean iamDatabaseAuthenticationEnabled;
    private final String cloneGroupId;
    private final Instant clusterCreateTime;

    private DBCluster(BuilderImpl builder) {
        this.allocatedStorage = builder.allocatedStorage;
        this.availabilityZones = builder.availabilityZones;
        this.backupRetentionPeriod = builder.backupRetentionPeriod;
        this.characterSetName = builder.characterSetName;
        this.databaseName = builder.databaseName;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.dbClusterParameterGroup = builder.dbClusterParameterGroup;
        this.dbSubnetGroup = builder.dbSubnetGroup;
        this.status = builder.status;
        this.percentProgress = builder.percentProgress;
        this.earliestRestorableTime = builder.earliestRestorableTime;
        this.endpoint = builder.endpoint;
        this.readerEndpoint = builder.readerEndpoint;
        this.multiAZ = builder.multiAZ;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.latestRestorableTime = builder.latestRestorableTime;
        this.port = builder.port;
        this.masterUsername = builder.masterUsername;
        this.dbClusterOptionGroupMemberships = builder.dbClusterOptionGroupMemberships;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.replicationSourceIdentifier = builder.replicationSourceIdentifier;
        this.readReplicaIdentifiers = builder.readReplicaIdentifiers;
        this.dbClusterMembers = builder.dbClusterMembers;
        this.vpcSecurityGroups = builder.vpcSecurityGroups;
        this.hostedZoneId = builder.hostedZoneId;
        this.storageEncrypted = builder.storageEncrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.dbClusterResourceId = builder.dbClusterResourceId;
        this.dbClusterArn = builder.dbClusterArn;
        this.associatedRoles = builder.associatedRoles;
        this.iamDatabaseAuthenticationEnabled = builder.iamDatabaseAuthenticationEnabled;
        this.cloneGroupId = builder.cloneGroupId;
        this.clusterCreateTime = builder.clusterCreateTime;
    }

    public Integer allocatedStorage() {
        return this.allocatedStorage;
    }

    public List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public Integer backupRetentionPeriod() {
        return this.backupRetentionPeriod;
    }

    public String characterSetName() {
        return this.characterSetName;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public String dbClusterParameterGroup() {
        return this.dbClusterParameterGroup;
    }

    public String dbSubnetGroup() {
        return this.dbSubnetGroup;
    }

    public String status() {
        return this.status;
    }

    public String percentProgress() {
        return this.percentProgress;
    }

    public Instant earliestRestorableTime() {
        return this.earliestRestorableTime;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public String readerEndpoint() {
        return this.readerEndpoint;
    }

    public Boolean multiAZ() {
        return this.multiAZ;
    }

    public String engine() {
        return this.engine;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public Instant latestRestorableTime() {
        return this.latestRestorableTime;
    }

    public Integer port() {
        return this.port;
    }

    public String masterUsername() {
        return this.masterUsername;
    }

    public List<DBClusterOptionGroupStatus> dbClusterOptionGroupMemberships() {
        return this.dbClusterOptionGroupMemberships;
    }

    public String preferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    public String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public String replicationSourceIdentifier() {
        return this.replicationSourceIdentifier;
    }

    public List<String> readReplicaIdentifiers() {
        return this.readReplicaIdentifiers;
    }

    public List<DBClusterMember> dbClusterMembers() {
        return this.dbClusterMembers;
    }

    public List<VpcSecurityGroupMembership> vpcSecurityGroups() {
        return this.vpcSecurityGroups;
    }

    public String hostedZoneId() {
        return this.hostedZoneId;
    }

    public Boolean storageEncrypted() {
        return this.storageEncrypted;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public String dbClusterResourceId() {
        return this.dbClusterResourceId;
    }

    public String dbClusterArn() {
        return this.dbClusterArn;
    }

    public List<DBClusterRole> associatedRoles() {
        return this.associatedRoles;
    }

    public Boolean iamDatabaseAuthenticationEnabled() {
        return this.iamDatabaseAuthenticationEnabled;
    }

    public String cloneGroupId() {
        return this.cloneGroupId;
    }

    public Instant clusterCreateTime() {
        return this.clusterCreateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZones());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.characterSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterParameterGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSubnetGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.percentProgress());
        hashCode = 31 * hashCode + Objects.hashCode(this.earliestRestorableTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.readerEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiAZ());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestRestorableTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterUsername());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterOptionGroupMemberships());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredBackupWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationSourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.readReplicaIdentifiers());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterMembers());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcSecurityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedRoles());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamDatabaseAuthenticationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloneGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterCreateTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBCluster)) {
            return false;
        }
        DBCluster other = (DBCluster)obj;
        return Objects.equals(this.allocatedStorage(), other.allocatedStorage()) && Objects.equals(this.availabilityZones(), other.availabilityZones()) && Objects.equals(this.backupRetentionPeriod(), other.backupRetentionPeriod()) && Objects.equals(this.characterSetName(), other.characterSetName()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.dbClusterIdentifier(), other.dbClusterIdentifier()) && Objects.equals(this.dbClusterParameterGroup(), other.dbClusterParameterGroup()) && Objects.equals(this.dbSubnetGroup(), other.dbSubnetGroup()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.percentProgress(), other.percentProgress()) && Objects.equals(this.earliestRestorableTime(), other.earliestRestorableTime()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.readerEndpoint(), other.readerEndpoint()) && Objects.equals(this.multiAZ(), other.multiAZ()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.latestRestorableTime(), other.latestRestorableTime()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.masterUsername(), other.masterUsername()) && Objects.equals(this.dbClusterOptionGroupMemberships(), other.dbClusterOptionGroupMemberships()) && Objects.equals(this.preferredBackupWindow(), other.preferredBackupWindow()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && Objects.equals(this.replicationSourceIdentifier(), other.replicationSourceIdentifier()) && Objects.equals(this.readReplicaIdentifiers(), other.readReplicaIdentifiers()) && Objects.equals(this.dbClusterMembers(), other.dbClusterMembers()) && Objects.equals(this.vpcSecurityGroups(), other.vpcSecurityGroups()) && Objects.equals(this.hostedZoneId(), other.hostedZoneId()) && Objects.equals(this.storageEncrypted(), other.storageEncrypted()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.dbClusterResourceId(), other.dbClusterResourceId()) && Objects.equals(this.dbClusterArn(), other.dbClusterArn()) && Objects.equals(this.associatedRoles(), other.associatedRoles()) && Objects.equals(this.iamDatabaseAuthenticationEnabled(), other.iamDatabaseAuthenticationEnabled()) && Objects.equals(this.cloneGroupId(), other.cloneGroupId()) && Objects.equals(this.clusterCreateTime(), other.clusterCreateTime());
    }

    public String toString() {
        return ToString.builder((String)"DBCluster").add("AllocatedStorage", (Object)this.allocatedStorage()).add("AvailabilityZones", this.availabilityZones()).add("BackupRetentionPeriod", (Object)this.backupRetentionPeriod()).add("CharacterSetName", (Object)this.characterSetName()).add("DatabaseName", (Object)this.databaseName()).add("DBClusterIdentifier", (Object)this.dbClusterIdentifier()).add("DBClusterParameterGroup", (Object)this.dbClusterParameterGroup()).add("DBSubnetGroup", (Object)this.dbSubnetGroup()).add("Status", (Object)this.status()).add("PercentProgress", (Object)this.percentProgress()).add("EarliestRestorableTime", (Object)this.earliestRestorableTime()).add("Endpoint", (Object)this.endpoint()).add("ReaderEndpoint", (Object)this.readerEndpoint()).add("MultiAZ", (Object)this.multiAZ()).add("Engine", (Object)this.engine()).add("EngineVersion", (Object)this.engineVersion()).add("LatestRestorableTime", (Object)this.latestRestorableTime()).add("Port", (Object)this.port()).add("MasterUsername", (Object)this.masterUsername()).add("DBClusterOptionGroupMemberships", this.dbClusterOptionGroupMemberships()).add("PreferredBackupWindow", (Object)this.preferredBackupWindow()).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).add("ReplicationSourceIdentifier", (Object)this.replicationSourceIdentifier()).add("ReadReplicaIdentifiers", this.readReplicaIdentifiers()).add("DBClusterMembers", this.dbClusterMembers()).add("VpcSecurityGroups", this.vpcSecurityGroups()).add("HostedZoneId", (Object)this.hostedZoneId()).add("StorageEncrypted", (Object)this.storageEncrypted()).add("KmsKeyId", (Object)this.kmsKeyId()).add("DbClusterResourceId", (Object)this.dbClusterResourceId()).add("DBClusterArn", (Object)this.dbClusterArn()).add("AssociatedRoles", this.associatedRoles()).add("IAMDatabaseAuthenticationEnabled", (Object)this.iamDatabaseAuthenticationEnabled()).add("CloneGroupId", (Object)this.cloneGroupId()).add("ClusterCreateTime", (Object)this.clusterCreateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllocatedStorage": {
                return Optional.of(clazz.cast(this.allocatedStorage()));
            }
            case "AvailabilityZones": {
                return Optional.of(clazz.cast(this.availabilityZones()));
            }
            case "BackupRetentionPeriod": {
                return Optional.of(clazz.cast(this.backupRetentionPeriod()));
            }
            case "CharacterSetName": {
                return Optional.of(clazz.cast(this.characterSetName()));
            }
            case "DatabaseName": {
                return Optional.of(clazz.cast(this.databaseName()));
            }
            case "DBClusterIdentifier": {
                return Optional.of(clazz.cast(this.dbClusterIdentifier()));
            }
            case "DBClusterParameterGroup": {
                return Optional.of(clazz.cast(this.dbClusterParameterGroup()));
            }
            case "DBSubnetGroup": {
                return Optional.of(clazz.cast(this.dbSubnetGroup()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "PercentProgress": {
                return Optional.of(clazz.cast(this.percentProgress()));
            }
            case "EarliestRestorableTime": {
                return Optional.of(clazz.cast(this.earliestRestorableTime()));
            }
            case "Endpoint": {
                return Optional.of(clazz.cast(this.endpoint()));
            }
            case "ReaderEndpoint": {
                return Optional.of(clazz.cast(this.readerEndpoint()));
            }
            case "MultiAZ": {
                return Optional.of(clazz.cast(this.multiAZ()));
            }
            case "Engine": {
                return Optional.of(clazz.cast(this.engine()));
            }
            case "EngineVersion": {
                return Optional.of(clazz.cast(this.engineVersion()));
            }
            case "LatestRestorableTime": {
                return Optional.of(clazz.cast(this.latestRestorableTime()));
            }
            case "Port": {
                return Optional.of(clazz.cast(this.port()));
            }
            case "MasterUsername": {
                return Optional.of(clazz.cast(this.masterUsername()));
            }
            case "DBClusterOptionGroupMemberships": {
                return Optional.of(clazz.cast(this.dbClusterOptionGroupMemberships()));
            }
            case "PreferredBackupWindow": {
                return Optional.of(clazz.cast(this.preferredBackupWindow()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.of(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "ReplicationSourceIdentifier": {
                return Optional.of(clazz.cast(this.replicationSourceIdentifier()));
            }
            case "ReadReplicaIdentifiers": {
                return Optional.of(clazz.cast(this.readReplicaIdentifiers()));
            }
            case "DBClusterMembers": {
                return Optional.of(clazz.cast(this.dbClusterMembers()));
            }
            case "VpcSecurityGroups": {
                return Optional.of(clazz.cast(this.vpcSecurityGroups()));
            }
            case "HostedZoneId": {
                return Optional.of(clazz.cast(this.hostedZoneId()));
            }
            case "StorageEncrypted": {
                return Optional.of(clazz.cast(this.storageEncrypted()));
            }
            case "KmsKeyId": {
                return Optional.of(clazz.cast(this.kmsKeyId()));
            }
            case "DbClusterResourceId": {
                return Optional.of(clazz.cast(this.dbClusterResourceId()));
            }
            case "DBClusterArn": {
                return Optional.of(clazz.cast(this.dbClusterArn()));
            }
            case "AssociatedRoles": {
                return Optional.of(clazz.cast(this.associatedRoles()));
            }
            case "IAMDatabaseAuthenticationEnabled": {
                return Optional.of(clazz.cast(this.iamDatabaseAuthenticationEnabled()));
            }
            case "CloneGroupId": {
                return Optional.of(clazz.cast(this.cloneGroupId()));
            }
            case "ClusterCreateTime": {
                return Optional.of(clazz.cast(this.clusterCreateTime()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Integer allocatedStorage;
        private List<String> availabilityZones;
        private Integer backupRetentionPeriod;
        private String characterSetName;
        private String databaseName;
        private String dbClusterIdentifier;
        private String dbClusterParameterGroup;
        private String dbSubnetGroup;
        private String status;
        private String percentProgress;
        private Instant earliestRestorableTime;
        private String endpoint;
        private String readerEndpoint;
        private Boolean multiAZ;
        private String engine;
        private String engineVersion;
        private Instant latestRestorableTime;
        private Integer port;
        private String masterUsername;
        private List<DBClusterOptionGroupStatus> dbClusterOptionGroupMemberships;
        private String preferredBackupWindow;
        private String preferredMaintenanceWindow;
        private String replicationSourceIdentifier;
        private List<String> readReplicaIdentifiers;
        private List<DBClusterMember> dbClusterMembers;
        private List<VpcSecurityGroupMembership> vpcSecurityGroups;
        private String hostedZoneId;
        private Boolean storageEncrypted;
        private String kmsKeyId;
        private String dbClusterResourceId;
        private String dbClusterArn;
        private List<DBClusterRole> associatedRoles;
        private Boolean iamDatabaseAuthenticationEnabled;
        private String cloneGroupId;
        private Instant clusterCreateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DBCluster model) {
            this.allocatedStorage(model.allocatedStorage);
            this.availabilityZones(model.availabilityZones);
            this.backupRetentionPeriod(model.backupRetentionPeriod);
            this.characterSetName(model.characterSetName);
            this.databaseName(model.databaseName);
            this.dbClusterIdentifier(model.dbClusterIdentifier);
            this.dbClusterParameterGroup(model.dbClusterParameterGroup);
            this.dbSubnetGroup(model.dbSubnetGroup);
            this.status(model.status);
            this.percentProgress(model.percentProgress);
            this.earliestRestorableTime(model.earliestRestorableTime);
            this.endpoint(model.endpoint);
            this.readerEndpoint(model.readerEndpoint);
            this.multiAZ(model.multiAZ);
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.latestRestorableTime(model.latestRestorableTime);
            this.port(model.port);
            this.masterUsername(model.masterUsername);
            this.dbClusterOptionGroupMemberships(model.dbClusterOptionGroupMemberships);
            this.preferredBackupWindow(model.preferredBackupWindow);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.replicationSourceIdentifier(model.replicationSourceIdentifier);
            this.readReplicaIdentifiers(model.readReplicaIdentifiers);
            this.dbClusterMembers(model.dbClusterMembers);
            this.vpcSecurityGroups(model.vpcSecurityGroups);
            this.hostedZoneId(model.hostedZoneId);
            this.storageEncrypted(model.storageEncrypted);
            this.kmsKeyId(model.kmsKeyId);
            this.dbClusterResourceId(model.dbClusterResourceId);
            this.dbClusterArn(model.dbClusterArn);
            this.associatedRoles(model.associatedRoles);
            this.iamDatabaseAuthenticationEnabled(model.iamDatabaseAuthenticationEnabled);
            this.cloneGroupId(model.cloneGroupId);
            this.clusterCreateTime(model.clusterCreateTime);
        }

        public final Integer getAllocatedStorage() {
            return this.allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        public final Collection<String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        public final Integer getBackupRetentionPeriod() {
            return this.backupRetentionPeriod;
        }

        @Override
        public final Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        public final void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
        }

        public final String getCharacterSetName() {
            return this.characterSetName;
        }

        @Override
        public final Builder characterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
            return this;
        }

        public final void setCharacterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getDBClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final void setDBClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        public final String getDBClusterParameterGroup() {
            return this.dbClusterParameterGroup;
        }

        @Override
        public final Builder dbClusterParameterGroup(String dbClusterParameterGroup) {
            this.dbClusterParameterGroup = dbClusterParameterGroup;
            return this;
        }

        public final void setDBClusterParameterGroup(String dbClusterParameterGroup) {
            this.dbClusterParameterGroup = dbClusterParameterGroup;
        }

        public final String getDBSubnetGroup() {
            return this.dbSubnetGroup;
        }

        @Override
        public final Builder dbSubnetGroup(String dbSubnetGroup) {
            this.dbSubnetGroup = dbSubnetGroup;
            return this;
        }

        public final void setDBSubnetGroup(String dbSubnetGroup) {
            this.dbSubnetGroup = dbSubnetGroup;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getPercentProgress() {
            return this.percentProgress;
        }

        @Override
        public final Builder percentProgress(String percentProgress) {
            this.percentProgress = percentProgress;
            return this;
        }

        public final void setPercentProgress(String percentProgress) {
            this.percentProgress = percentProgress;
        }

        public final Instant getEarliestRestorableTime() {
            return this.earliestRestorableTime;
        }

        @Override
        public final Builder earliestRestorableTime(Instant earliestRestorableTime) {
            this.earliestRestorableTime = earliestRestorableTime;
            return this;
        }

        public final void setEarliestRestorableTime(Instant earliestRestorableTime) {
            this.earliestRestorableTime = earliestRestorableTime;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public final String getReaderEndpoint() {
            return this.readerEndpoint;
        }

        @Override
        public final Builder readerEndpoint(String readerEndpoint) {
            this.readerEndpoint = readerEndpoint;
            return this;
        }

        public final void setReaderEndpoint(String readerEndpoint) {
            this.readerEndpoint = readerEndpoint;
        }

        public final Boolean getMultiAZ() {
            return this.multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final Instant getLatestRestorableTime() {
            return this.latestRestorableTime;
        }

        @Override
        public final Builder latestRestorableTime(Instant latestRestorableTime) {
            this.latestRestorableTime = latestRestorableTime;
            return this;
        }

        public final void setLatestRestorableTime(Instant latestRestorableTime) {
            this.latestRestorableTime = latestRestorableTime;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getMasterUsername() {
            return this.masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        public final Collection<DBClusterOptionGroupStatus.Builder> getDBClusterOptionGroupMemberships() {
            return this.dbClusterOptionGroupMemberships != null ? (Collection)this.dbClusterOptionGroupMemberships.stream().map(DBClusterOptionGroupStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dbClusterOptionGroupMemberships(Collection<DBClusterOptionGroupStatus> dbClusterOptionGroupMemberships) {
            this.dbClusterOptionGroupMemberships = DBClusterOptionGroupMembershipsCopier.copy(dbClusterOptionGroupMemberships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterOptionGroupMemberships(DBClusterOptionGroupStatus ... dbClusterOptionGroupMemberships) {
            this.dbClusterOptionGroupMemberships(Arrays.asList(dbClusterOptionGroupMemberships));
            return this;
        }

        public final void setDBClusterOptionGroupMemberships(Collection<DBClusterOptionGroupStatus.BuilderImpl> dbClusterOptionGroupMemberships) {
            this.dbClusterOptionGroupMemberships = DBClusterOptionGroupMembershipsCopier.copyFromBuilder(dbClusterOptionGroupMemberships);
        }

        public final String getPreferredBackupWindow() {
            return this.preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final String getReplicationSourceIdentifier() {
            return this.replicationSourceIdentifier;
        }

        @Override
        public final Builder replicationSourceIdentifier(String replicationSourceIdentifier) {
            this.replicationSourceIdentifier = replicationSourceIdentifier;
            return this;
        }

        public final void setReplicationSourceIdentifier(String replicationSourceIdentifier) {
            this.replicationSourceIdentifier = replicationSourceIdentifier;
        }

        public final Collection<String> getReadReplicaIdentifiers() {
            return this.readReplicaIdentifiers;
        }

        @Override
        public final Builder readReplicaIdentifiers(Collection<String> readReplicaIdentifiers) {
            this.readReplicaIdentifiers = ReadReplicaIdentifierListCopier.copy(readReplicaIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readReplicaIdentifiers(String ... readReplicaIdentifiers) {
            this.readReplicaIdentifiers(Arrays.asList(readReplicaIdentifiers));
            return this;
        }

        public final void setReadReplicaIdentifiers(Collection<String> readReplicaIdentifiers) {
            this.readReplicaIdentifiers = ReadReplicaIdentifierListCopier.copy(readReplicaIdentifiers);
        }

        public final Collection<DBClusterMember.Builder> getDBClusterMembers() {
            return this.dbClusterMembers != null ? (Collection)this.dbClusterMembers.stream().map(DBClusterMember::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dbClusterMembers(Collection<DBClusterMember> dbClusterMembers) {
            this.dbClusterMembers = DBClusterMemberListCopier.copy(dbClusterMembers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterMembers(DBClusterMember ... dbClusterMembers) {
            this.dbClusterMembers(Arrays.asList(dbClusterMembers));
            return this;
        }

        public final void setDBClusterMembers(Collection<DBClusterMember.BuilderImpl> dbClusterMembers) {
            this.dbClusterMembers = DBClusterMemberListCopier.copyFromBuilder(dbClusterMembers);
        }

        public final Collection<VpcSecurityGroupMembership.Builder> getVpcSecurityGroups() {
            return this.vpcSecurityGroups != null ? (Collection)this.vpcSecurityGroups.stream().map(VpcSecurityGroupMembership::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups) {
            this.vpcSecurityGroups = VpcSecurityGroupMembershipListCopier.copy(vpcSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(VpcSecurityGroupMembership ... vpcSecurityGroups) {
            this.vpcSecurityGroups(Arrays.asList(vpcSecurityGroups));
            return this;
        }

        public final void setVpcSecurityGroups(Collection<VpcSecurityGroupMembership.BuilderImpl> vpcSecurityGroups) {
            this.vpcSecurityGroups = VpcSecurityGroupMembershipListCopier.copyFromBuilder(vpcSecurityGroups);
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final Boolean getStorageEncrypted() {
            return this.storageEncrypted;
        }

        @Override
        public final Builder storageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        public final void setStorageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getDbClusterResourceId() {
            return this.dbClusterResourceId;
        }

        @Override
        public final Builder dbClusterResourceId(String dbClusterResourceId) {
            this.dbClusterResourceId = dbClusterResourceId;
            return this;
        }

        public final void setDbClusterResourceId(String dbClusterResourceId) {
            this.dbClusterResourceId = dbClusterResourceId;
        }

        public final String getDBClusterArn() {
            return this.dbClusterArn;
        }

        @Override
        public final Builder dbClusterArn(String dbClusterArn) {
            this.dbClusterArn = dbClusterArn;
            return this;
        }

        public final void setDBClusterArn(String dbClusterArn) {
            this.dbClusterArn = dbClusterArn;
        }

        public final Collection<DBClusterRole.Builder> getAssociatedRoles() {
            return this.associatedRoles != null ? (Collection)this.associatedRoles.stream().map(DBClusterRole::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder associatedRoles(Collection<DBClusterRole> associatedRoles) {
            this.associatedRoles = DBClusterRolesCopier.copy(associatedRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedRoles(DBClusterRole ... associatedRoles) {
            this.associatedRoles(Arrays.asList(associatedRoles));
            return this;
        }

        public final void setAssociatedRoles(Collection<DBClusterRole.BuilderImpl> associatedRoles) {
            this.associatedRoles = DBClusterRolesCopier.copyFromBuilder(associatedRoles);
        }

        public final Boolean getIAMDatabaseAuthenticationEnabled() {
            return this.iamDatabaseAuthenticationEnabled;
        }

        @Override
        public final Builder iamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
            return this;
        }

        public final void setIAMDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
        }

        public final String getCloneGroupId() {
            return this.cloneGroupId;
        }

        @Override
        public final Builder cloneGroupId(String cloneGroupId) {
            this.cloneGroupId = cloneGroupId;
            return this;
        }

        public final void setCloneGroupId(String cloneGroupId) {
            this.cloneGroupId = cloneGroupId;
        }

        public final Instant getClusterCreateTime() {
            return this.clusterCreateTime;
        }

        @Override
        public final Builder clusterCreateTime(Instant clusterCreateTime) {
            this.clusterCreateTime = clusterCreateTime;
            return this;
        }

        public final void setClusterCreateTime(Instant clusterCreateTime) {
            this.clusterCreateTime = clusterCreateTime;
        }

        public DBCluster build() {
            return new DBCluster(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DBCluster> {
        public Builder allocatedStorage(Integer var1);

        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder backupRetentionPeriod(Integer var1);

        public Builder characterSetName(String var1);

        public Builder databaseName(String var1);

        public Builder dbClusterIdentifier(String var1);

        public Builder dbClusterParameterGroup(String var1);

        public Builder dbSubnetGroup(String var1);

        public Builder status(String var1);

        public Builder percentProgress(String var1);

        public Builder earliestRestorableTime(Instant var1);

        public Builder endpoint(String var1);

        public Builder readerEndpoint(String var1);

        public Builder multiAZ(Boolean var1);

        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder latestRestorableTime(Instant var1);

        public Builder port(Integer var1);

        public Builder masterUsername(String var1);

        public Builder dbClusterOptionGroupMemberships(Collection<DBClusterOptionGroupStatus> var1);

        public Builder dbClusterOptionGroupMemberships(DBClusterOptionGroupStatus ... var1);

        public Builder preferredBackupWindow(String var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder replicationSourceIdentifier(String var1);

        public Builder readReplicaIdentifiers(Collection<String> var1);

        public Builder readReplicaIdentifiers(String ... var1);

        public Builder dbClusterMembers(Collection<DBClusterMember> var1);

        public Builder dbClusterMembers(DBClusterMember ... var1);

        public Builder vpcSecurityGroups(Collection<VpcSecurityGroupMembership> var1);

        public Builder vpcSecurityGroups(VpcSecurityGroupMembership ... var1);

        public Builder hostedZoneId(String var1);

        public Builder storageEncrypted(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder dbClusterResourceId(String var1);

        public Builder dbClusterArn(String var1);

        public Builder associatedRoles(Collection<DBClusterRole> var1);

        public Builder associatedRoles(DBClusterRole ... var1);

        public Builder iamDatabaseAuthenticationEnabled(Boolean var1);

        public Builder cloneGroupId(String var1);

        public Builder clusterCreateTime(Instant var1);
    }
}

