/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.rds.model.AvailabilityZonesCopier;
import software.amazon.awssdk.services.rds.model.RDSRequest;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.services.rds.model.VpcSecurityGroupIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateDBClusterRequest
extends RDSRequest
implements ToCopyableBuilder<Builder, CreateDBClusterRequest> {
    private final List<String> availabilityZones;
    private final Integer backupRetentionPeriod;
    private final String characterSetName;
    private final String databaseName;
    private final String dbClusterIdentifier;
    private final String dbClusterParameterGroupName;
    private final List<String> vpcSecurityGroupIds;
    private final String dbSubnetGroupName;
    private final String engine;
    private final String engineVersion;
    private final Integer port;
    private final String masterUsername;
    private final String masterUserPassword;
    private final String optionGroupName;
    private final String preferredBackupWindow;
    private final String preferredMaintenanceWindow;
    private final String replicationSourceIdentifier;
    private final List<Tag> tags;
    private final Boolean storageEncrypted;
    private final String kmsKeyId;
    private final String preSignedUrl;
    private final Boolean enableIAMDatabaseAuthentication;

    private CreateDBClusterRequest(BuilderImpl builder) {
        super(builder);
        this.availabilityZones = builder.availabilityZones;
        this.backupRetentionPeriod = builder.backupRetentionPeriod;
        this.characterSetName = builder.characterSetName;
        this.databaseName = builder.databaseName;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.dbClusterParameterGroupName = builder.dbClusterParameterGroupName;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.dbSubnetGroupName = builder.dbSubnetGroupName;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.port = builder.port;
        this.masterUsername = builder.masterUsername;
        this.masterUserPassword = builder.masterUserPassword;
        this.optionGroupName = builder.optionGroupName;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.replicationSourceIdentifier = builder.replicationSourceIdentifier;
        this.tags = builder.tags;
        this.storageEncrypted = builder.storageEncrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.preSignedUrl = builder.preSignedUrl;
        this.enableIAMDatabaseAuthentication = builder.enableIAMDatabaseAuthentication;
    }

    public List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public Integer backupRetentionPeriod() {
        return this.backupRetentionPeriod;
    }

    public String characterSetName() {
        return this.characterSetName;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public String dbClusterParameterGroupName() {
        return this.dbClusterParameterGroupName;
    }

    public List<String> vpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    public String dbSubnetGroupName() {
        return this.dbSubnetGroupName;
    }

    public String engine() {
        return this.engine;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public Integer port() {
        return this.port;
    }

    public String masterUsername() {
        return this.masterUsername;
    }

    public String masterUserPassword() {
        return this.masterUserPassword;
    }

    public String optionGroupName() {
        return this.optionGroupName;
    }

    public String preferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    public String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public String replicationSourceIdentifier() {
        return this.replicationSourceIdentifier;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Boolean storageEncrypted() {
        return this.storageEncrypted;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public String preSignedUrl() {
        return this.preSignedUrl;
    }

    public Boolean enableIAMDatabaseAuthentication() {
        return this.enableIAMDatabaseAuthentication;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZones());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.characterSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcSecurityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterUsername());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredBackupWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationSourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.preSignedUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableIAMDatabaseAuthentication());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDBClusterRequest)) {
            return false;
        }
        CreateDBClusterRequest other = (CreateDBClusterRequest)((Object)obj);
        return Objects.equals(this.availabilityZones(), other.availabilityZones()) && Objects.equals(this.backupRetentionPeriod(), other.backupRetentionPeriod()) && Objects.equals(this.characterSetName(), other.characterSetName()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.dbClusterIdentifier(), other.dbClusterIdentifier()) && Objects.equals(this.dbClusterParameterGroupName(), other.dbClusterParameterGroupName()) && Objects.equals(this.vpcSecurityGroupIds(), other.vpcSecurityGroupIds()) && Objects.equals(this.dbSubnetGroupName(), other.dbSubnetGroupName()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.masterUsername(), other.masterUsername()) && Objects.equals(this.masterUserPassword(), other.masterUserPassword()) && Objects.equals(this.optionGroupName(), other.optionGroupName()) && Objects.equals(this.preferredBackupWindow(), other.preferredBackupWindow()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && Objects.equals(this.replicationSourceIdentifier(), other.replicationSourceIdentifier()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.storageEncrypted(), other.storageEncrypted()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.preSignedUrl(), other.preSignedUrl()) && Objects.equals(this.enableIAMDatabaseAuthentication(), other.enableIAMDatabaseAuthentication());
    }

    public String toString() {
        return ToString.builder((String)"CreateDBClusterRequest").add("AvailabilityZones", this.availabilityZones()).add("BackupRetentionPeriod", (Object)this.backupRetentionPeriod()).add("CharacterSetName", (Object)this.characterSetName()).add("DatabaseName", (Object)this.databaseName()).add("DBClusterIdentifier", (Object)this.dbClusterIdentifier()).add("DBClusterParameterGroupName", (Object)this.dbClusterParameterGroupName()).add("VpcSecurityGroupIds", this.vpcSecurityGroupIds()).add("DBSubnetGroupName", (Object)this.dbSubnetGroupName()).add("Engine", (Object)this.engine()).add("EngineVersion", (Object)this.engineVersion()).add("Port", (Object)this.port()).add("MasterUsername", (Object)this.masterUsername()).add("MasterUserPassword", (Object)this.masterUserPassword()).add("OptionGroupName", (Object)this.optionGroupName()).add("PreferredBackupWindow", (Object)this.preferredBackupWindow()).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).add("ReplicationSourceIdentifier", (Object)this.replicationSourceIdentifier()).add("Tags", this.tags()).add("StorageEncrypted", (Object)this.storageEncrypted()).add("KmsKeyId", (Object)this.kmsKeyId()).add("PreSignedUrl", (Object)this.preSignedUrl()).add("EnableIAMDatabaseAuthentication", (Object)this.enableIAMDatabaseAuthentication()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZones": {
                return Optional.of(clazz.cast(this.availabilityZones()));
            }
            case "BackupRetentionPeriod": {
                return Optional.of(clazz.cast(this.backupRetentionPeriod()));
            }
            case "CharacterSetName": {
                return Optional.of(clazz.cast(this.characterSetName()));
            }
            case "DatabaseName": {
                return Optional.of(clazz.cast(this.databaseName()));
            }
            case "DBClusterIdentifier": {
                return Optional.of(clazz.cast(this.dbClusterIdentifier()));
            }
            case "DBClusterParameterGroupName": {
                return Optional.of(clazz.cast(this.dbClusterParameterGroupName()));
            }
            case "VpcSecurityGroupIds": {
                return Optional.of(clazz.cast(this.vpcSecurityGroupIds()));
            }
            case "DBSubnetGroupName": {
                return Optional.of(clazz.cast(this.dbSubnetGroupName()));
            }
            case "Engine": {
                return Optional.of(clazz.cast(this.engine()));
            }
            case "EngineVersion": {
                return Optional.of(clazz.cast(this.engineVersion()));
            }
            case "Port": {
                return Optional.of(clazz.cast(this.port()));
            }
            case "MasterUsername": {
                return Optional.of(clazz.cast(this.masterUsername()));
            }
            case "MasterUserPassword": {
                return Optional.of(clazz.cast(this.masterUserPassword()));
            }
            case "OptionGroupName": {
                return Optional.of(clazz.cast(this.optionGroupName()));
            }
            case "PreferredBackupWindow": {
                return Optional.of(clazz.cast(this.preferredBackupWindow()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.of(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "ReplicationSourceIdentifier": {
                return Optional.of(clazz.cast(this.replicationSourceIdentifier()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
            case "StorageEncrypted": {
                return Optional.of(clazz.cast(this.storageEncrypted()));
            }
            case "KmsKeyId": {
                return Optional.of(clazz.cast(this.kmsKeyId()));
            }
            case "PreSignedUrl": {
                return Optional.of(clazz.cast(this.preSignedUrl()));
            }
            case "EnableIAMDatabaseAuthentication": {
                return Optional.of(clazz.cast(this.enableIAMDatabaseAuthentication()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RDSRequest.BuilderImpl
    implements Builder {
        private List<String> availabilityZones;
        private Integer backupRetentionPeriod;
        private String characterSetName;
        private String databaseName;
        private String dbClusterIdentifier;
        private String dbClusterParameterGroupName;
        private List<String> vpcSecurityGroupIds;
        private String dbSubnetGroupName;
        private String engine;
        private String engineVersion;
        private Integer port;
        private String masterUsername;
        private String masterUserPassword;
        private String optionGroupName;
        private String preferredBackupWindow;
        private String preferredMaintenanceWindow;
        private String replicationSourceIdentifier;
        private List<Tag> tags;
        private Boolean storageEncrypted;
        private String kmsKeyId;
        private String preSignedUrl;
        private Boolean enableIAMDatabaseAuthentication;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDBClusterRequest model) {
            this.availabilityZones(model.availabilityZones);
            this.backupRetentionPeriod(model.backupRetentionPeriod);
            this.characterSetName(model.characterSetName);
            this.databaseName(model.databaseName);
            this.dbClusterIdentifier(model.dbClusterIdentifier);
            this.dbClusterParameterGroupName(model.dbClusterParameterGroupName);
            this.vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            this.dbSubnetGroupName(model.dbSubnetGroupName);
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.port(model.port);
            this.masterUsername(model.masterUsername);
            this.masterUserPassword(model.masterUserPassword);
            this.optionGroupName(model.optionGroupName);
            this.preferredBackupWindow(model.preferredBackupWindow);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.replicationSourceIdentifier(model.replicationSourceIdentifier);
            this.tags(model.tags);
            this.storageEncrypted(model.storageEncrypted);
            this.kmsKeyId(model.kmsKeyId);
            this.preSignedUrl(model.preSignedUrl);
            this.enableIAMDatabaseAuthentication(model.enableIAMDatabaseAuthentication);
        }

        public final Collection<String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        public final Integer getBackupRetentionPeriod() {
            return this.backupRetentionPeriod;
        }

        @Override
        public final Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        public final void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
        }

        public final String getCharacterSetName() {
            return this.characterSetName;
        }

        @Override
        public final Builder characterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
            return this;
        }

        public final void setCharacterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getDBClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final void setDBClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        public final String getDBClusterParameterGroupName() {
            return this.dbClusterParameterGroupName;
        }

        @Override
        public final Builder dbClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
            return this;
        }

        public final void setDBClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            return this.vpcSecurityGroupIds;
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        public final String getDBSubnetGroupName() {
            return this.dbSubnetGroupName;
        }

        @Override
        public final Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        public final void setDBSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getMasterUsername() {
            return this.masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        public final String getMasterUserPassword() {
            return this.masterUserPassword;
        }

        @Override
        public final Builder masterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        public final void setMasterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
        }

        public final String getOptionGroupName() {
            return this.optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        public final String getPreferredBackupWindow() {
            return this.preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final String getReplicationSourceIdentifier() {
            return this.replicationSourceIdentifier;
        }

        @Override
        public final Builder replicationSourceIdentifier(String replicationSourceIdentifier) {
            this.replicationSourceIdentifier = replicationSourceIdentifier;
            return this;
        }

        public final void setReplicationSourceIdentifier(String replicationSourceIdentifier) {
            this.replicationSourceIdentifier = replicationSourceIdentifier;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Boolean getStorageEncrypted() {
            return this.storageEncrypted;
        }

        @Override
        public final Builder storageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        public final void setStorageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getPreSignedUrl() {
            return this.preSignedUrl;
        }

        @Override
        public final Builder preSignedUrl(String preSignedUrl) {
            this.preSignedUrl = preSignedUrl;
            return this;
        }

        public final void setPreSignedUrl(String preSignedUrl) {
            this.preSignedUrl = preSignedUrl;
        }

        public final Boolean getEnableIAMDatabaseAuthentication() {
            return this.enableIAMDatabaseAuthentication;
        }

        @Override
        public final Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
            return this;
        }

        public final void setEnableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateDBClusterRequest build() {
            return new CreateDBClusterRequest(this);
        }
    }

    public static interface Builder
    extends RDSRequest.Builder,
    CopyableBuilder<Builder, CreateDBClusterRequest> {
        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder backupRetentionPeriod(Integer var1);

        public Builder characterSetName(String var1);

        public Builder databaseName(String var1);

        public Builder dbClusterIdentifier(String var1);

        public Builder dbClusterParameterGroupName(String var1);

        public Builder vpcSecurityGroupIds(Collection<String> var1);

        public Builder vpcSecurityGroupIds(String ... var1);

        public Builder dbSubnetGroupName(String var1);

        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder port(Integer var1);

        public Builder masterUsername(String var1);

        public Builder masterUserPassword(String var1);

        public Builder optionGroupName(String var1);

        public Builder preferredBackupWindow(String var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder replicationSourceIdentifier(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder storageEncrypted(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder preSignedUrl(String var1);

        public Builder enableIAMDatabaseAuthentication(Boolean var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

