/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.rds.RDSClient;
import software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsRequest;
import software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsResponse;
import software.amazon.awssdk.services.rds.model.EventSubscription;

public final class DescribeEventSubscriptionsPaginator
implements SdkIterable<DescribeEventSubscriptionsResponse> {
    private final RDSClient client;
    private final DescribeEventSubscriptionsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeEventSubscriptionsPaginator(RDSClient client, DescribeEventSubscriptionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeEventSubscriptionsResponseFetcher();
    }

    public Iterator<DescribeEventSubscriptionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<EventSubscription> eventSubscriptionsList() {
        Function<DescribeEventSubscriptionsResponse, Iterator> getIterator = response -> response != null ? response.eventSubscriptionsList().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeEventSubscriptionsResponseFetcher
    implements NextPageFetcher<DescribeEventSubscriptionsResponse> {
        private DescribeEventSubscriptionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEventSubscriptionsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeEventSubscriptionsResponse nextPage(DescribeEventSubscriptionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeEventSubscriptionsPaginator.this.client.describeEventSubscriptions(DescribeEventSubscriptionsPaginator.this.firstRequest);
            }
            return DescribeEventSubscriptionsPaginator.this.client.describeEventSubscriptions((DescribeEventSubscriptionsRequest)((Object)DescribeEventSubscriptionsPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

