/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.rds.model.RDSResponse;
import software.amazon.awssdk.services.rds.model.SourceRegion;
import software.amazon.awssdk.services.rds.model.SourceRegionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeSourceRegionsResponse
extends RDSResponse
implements ToCopyableBuilder<Builder, DescribeSourceRegionsResponse> {
    private final String marker;
    private final List<SourceRegion> sourceRegions;

    private DescribeSourceRegionsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.sourceRegions = builder.sourceRegions;
    }

    public String marker() {
        return this.marker;
    }

    public List<SourceRegion> sourceRegions() {
        return this.sourceRegions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceRegions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSourceRegionsResponse)) {
            return false;
        }
        DescribeSourceRegionsResponse other = (DescribeSourceRegionsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.sourceRegions(), other.sourceRegions());
    }

    public String toString() {
        return ToString.builder((String)"DescribeSourceRegionsResponse").add("Marker", (Object)this.marker()).add("SourceRegions", this.sourceRegions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "SourceRegions": {
                return Optional.of(clazz.cast(this.sourceRegions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RDSResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<SourceRegion> sourceRegions;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSourceRegionsResponse model) {
            this.marker(model.marker);
            this.sourceRegions(model.sourceRegions);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<SourceRegion.Builder> getSourceRegions() {
            return this.sourceRegions != null ? (Collection)this.sourceRegions.stream().map(SourceRegion::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sourceRegions(Collection<SourceRegion> sourceRegions) {
            this.sourceRegions = SourceRegionListCopier.copy(sourceRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceRegions(SourceRegion ... sourceRegions) {
            this.sourceRegions(Arrays.asList(sourceRegions));
            return this;
        }

        public final void setSourceRegions(Collection<SourceRegion.BuilderImpl> sourceRegions) {
            this.sourceRegions = SourceRegionListCopier.copyFromBuilder(sourceRegions);
        }

        @Override
        public DescribeSourceRegionsResponse build() {
            return new DescribeSourceRegionsResponse(this);
        }
    }

    public static interface Builder
    extends RDSResponse.Builder,
    CopyableBuilder<Builder, DescribeSourceRegionsResponse> {
        public Builder marker(String var1);

        public Builder sourceRegions(Collection<SourceRegion> var1);

        public Builder sourceRegions(SourceRegion ... var1);
    }
}

