/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.rds.model.RDSRequest;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RestoreDBInstanceFromDBSnapshotRequest
extends RDSRequest
implements ToCopyableBuilder<Builder, RestoreDBInstanceFromDBSnapshotRequest> {
    private final String dbInstanceIdentifier;
    private final String dbSnapshotIdentifier;
    private final String dbInstanceClass;
    private final Integer port;
    private final String availabilityZone;
    private final String dbSubnetGroupName;
    private final Boolean multiAZ;
    private final Boolean publiclyAccessible;
    private final Boolean autoMinorVersionUpgrade;
    private final String licenseModel;
    private final String dbName;
    private final String engine;
    private final Integer iops;
    private final String optionGroupName;
    private final List<Tag> tags;
    private final String storageType;
    private final String tdeCredentialArn;
    private final String tdeCredentialPassword;
    private final String domain;
    private final Boolean copyTagsToSnapshot;
    private final String domainIAMRoleName;
    private final Boolean enableIAMDatabaseAuthentication;

    private RestoreDBInstanceFromDBSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.dbSnapshotIdentifier = builder.dbSnapshotIdentifier;
        this.dbInstanceClass = builder.dbInstanceClass;
        this.port = builder.port;
        this.availabilityZone = builder.availabilityZone;
        this.dbSubnetGroupName = builder.dbSubnetGroupName;
        this.multiAZ = builder.multiAZ;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.licenseModel = builder.licenseModel;
        this.dbName = builder.dbName;
        this.engine = builder.engine;
        this.iops = builder.iops;
        this.optionGroupName = builder.optionGroupName;
        this.tags = builder.tags;
        this.storageType = builder.storageType;
        this.tdeCredentialArn = builder.tdeCredentialArn;
        this.tdeCredentialPassword = builder.tdeCredentialPassword;
        this.domain = builder.domain;
        this.copyTagsToSnapshot = builder.copyTagsToSnapshot;
        this.domainIAMRoleName = builder.domainIAMRoleName;
        this.enableIAMDatabaseAuthentication = builder.enableIAMDatabaseAuthentication;
    }

    public String dbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public String dbSnapshotIdentifier() {
        return this.dbSnapshotIdentifier;
    }

    public String dbInstanceClass() {
        return this.dbInstanceClass;
    }

    public Integer port() {
        return this.port;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String dbSubnetGroupName() {
        return this.dbSubnetGroupName;
    }

    public Boolean multiAZ() {
        return this.multiAZ;
    }

    public Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public Boolean autoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public String licenseModel() {
        return this.licenseModel;
    }

    public String dbName() {
        return this.dbName;
    }

    public String engine() {
        return this.engine;
    }

    public Integer iops() {
        return this.iops;
    }

    public String optionGroupName() {
        return this.optionGroupName;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String storageType() {
        return this.storageType;
    }

    public String tdeCredentialArn() {
        return this.tdeCredentialArn;
    }

    public String tdeCredentialPassword() {
        return this.tdeCredentialPassword;
    }

    public String domain() {
        return this.domain;
    }

    public Boolean copyTagsToSnapshot() {
        return this.copyTagsToSnapshot;
    }

    public String domainIAMRoleName() {
        return this.domainIAMRoleName;
    }

    public Boolean enableIAMDatabaseAuthentication() {
        return this.enableIAMDatabaseAuthentication;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiAZ());
        hashCode = 31 * hashCode + Objects.hashCode(this.publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseModel());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbName());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.iops());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageType());
        hashCode = 31 * hashCode + Objects.hashCode(this.tdeCredentialArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tdeCredentialPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTagsToSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIAMRoleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableIAMDatabaseAuthentication());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreDBInstanceFromDBSnapshotRequest)) {
            return false;
        }
        RestoreDBInstanceFromDBSnapshotRequest other = (RestoreDBInstanceFromDBSnapshotRequest)((Object)obj);
        return Objects.equals(this.dbInstanceIdentifier(), other.dbInstanceIdentifier()) && Objects.equals(this.dbSnapshotIdentifier(), other.dbSnapshotIdentifier()) && Objects.equals(this.dbInstanceClass(), other.dbInstanceClass()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.dbSubnetGroupName(), other.dbSubnetGroupName()) && Objects.equals(this.multiAZ(), other.multiAZ()) && Objects.equals(this.publiclyAccessible(), other.publiclyAccessible()) && Objects.equals(this.autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade()) && Objects.equals(this.licenseModel(), other.licenseModel()) && Objects.equals(this.dbName(), other.dbName()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.iops(), other.iops()) && Objects.equals(this.optionGroupName(), other.optionGroupName()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.storageType(), other.storageType()) && Objects.equals(this.tdeCredentialArn(), other.tdeCredentialArn()) && Objects.equals(this.tdeCredentialPassword(), other.tdeCredentialPassword()) && Objects.equals(this.domain(), other.domain()) && Objects.equals(this.copyTagsToSnapshot(), other.copyTagsToSnapshot()) && Objects.equals(this.domainIAMRoleName(), other.domainIAMRoleName()) && Objects.equals(this.enableIAMDatabaseAuthentication(), other.enableIAMDatabaseAuthentication());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.dbInstanceIdentifier() != null) {
            sb.append("DBInstanceIdentifier: ").append(this.dbInstanceIdentifier()).append(",");
        }
        if (this.dbSnapshotIdentifier() != null) {
            sb.append("DBSnapshotIdentifier: ").append(this.dbSnapshotIdentifier()).append(",");
        }
        if (this.dbInstanceClass() != null) {
            sb.append("DBInstanceClass: ").append(this.dbInstanceClass()).append(",");
        }
        if (this.port() != null) {
            sb.append("Port: ").append(this.port()).append(",");
        }
        if (this.availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.availabilityZone()).append(",");
        }
        if (this.dbSubnetGroupName() != null) {
            sb.append("DBSubnetGroupName: ").append(this.dbSubnetGroupName()).append(",");
        }
        if (this.multiAZ() != null) {
            sb.append("MultiAZ: ").append(this.multiAZ()).append(",");
        }
        if (this.publiclyAccessible() != null) {
            sb.append("PubliclyAccessible: ").append(this.publiclyAccessible()).append(",");
        }
        if (this.autoMinorVersionUpgrade() != null) {
            sb.append("AutoMinorVersionUpgrade: ").append(this.autoMinorVersionUpgrade()).append(",");
        }
        if (this.licenseModel() != null) {
            sb.append("LicenseModel: ").append(this.licenseModel()).append(",");
        }
        if (this.dbName() != null) {
            sb.append("DBName: ").append(this.dbName()).append(",");
        }
        if (this.engine() != null) {
            sb.append("Engine: ").append(this.engine()).append(",");
        }
        if (this.iops() != null) {
            sb.append("Iops: ").append(this.iops()).append(",");
        }
        if (this.optionGroupName() != null) {
            sb.append("OptionGroupName: ").append(this.optionGroupName()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.storageType() != null) {
            sb.append("StorageType: ").append(this.storageType()).append(",");
        }
        if (this.tdeCredentialArn() != null) {
            sb.append("TdeCredentialArn: ").append(this.tdeCredentialArn()).append(",");
        }
        if (this.tdeCredentialPassword() != null) {
            sb.append("TdeCredentialPassword: ").append(this.tdeCredentialPassword()).append(",");
        }
        if (this.domain() != null) {
            sb.append("Domain: ").append(this.domain()).append(",");
        }
        if (this.copyTagsToSnapshot() != null) {
            sb.append("CopyTagsToSnapshot: ").append(this.copyTagsToSnapshot()).append(",");
        }
        if (this.domainIAMRoleName() != null) {
            sb.append("DomainIAMRoleName: ").append(this.domainIAMRoleName()).append(",");
        }
        if (this.enableIAMDatabaseAuthentication() != null) {
            sb.append("EnableIAMDatabaseAuthentication: ").append(this.enableIAMDatabaseAuthentication()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBInstanceIdentifier": {
                return Optional.of(clazz.cast(this.dbInstanceIdentifier()));
            }
            case "DBSnapshotIdentifier": {
                return Optional.of(clazz.cast(this.dbSnapshotIdentifier()));
            }
            case "DBInstanceClass": {
                return Optional.of(clazz.cast(this.dbInstanceClass()));
            }
            case "Port": {
                return Optional.of(clazz.cast(this.port()));
            }
            case "AvailabilityZone": {
                return Optional.of(clazz.cast(this.availabilityZone()));
            }
            case "DBSubnetGroupName": {
                return Optional.of(clazz.cast(this.dbSubnetGroupName()));
            }
            case "MultiAZ": {
                return Optional.of(clazz.cast(this.multiAZ()));
            }
            case "PubliclyAccessible": {
                return Optional.of(clazz.cast(this.publiclyAccessible()));
            }
            case "AutoMinorVersionUpgrade": {
                return Optional.of(clazz.cast(this.autoMinorVersionUpgrade()));
            }
            case "LicenseModel": {
                return Optional.of(clazz.cast(this.licenseModel()));
            }
            case "DBName": {
                return Optional.of(clazz.cast(this.dbName()));
            }
            case "Engine": {
                return Optional.of(clazz.cast(this.engine()));
            }
            case "Iops": {
                return Optional.of(clazz.cast(this.iops()));
            }
            case "OptionGroupName": {
                return Optional.of(clazz.cast(this.optionGroupName()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
            case "StorageType": {
                return Optional.of(clazz.cast(this.storageType()));
            }
            case "TdeCredentialArn": {
                return Optional.of(clazz.cast(this.tdeCredentialArn()));
            }
            case "TdeCredentialPassword": {
                return Optional.of(clazz.cast(this.tdeCredentialPassword()));
            }
            case "Domain": {
                return Optional.of(clazz.cast(this.domain()));
            }
            case "CopyTagsToSnapshot": {
                return Optional.of(clazz.cast(this.copyTagsToSnapshot()));
            }
            case "DomainIAMRoleName": {
                return Optional.of(clazz.cast(this.domainIAMRoleName()));
            }
            case "EnableIAMDatabaseAuthentication": {
                return Optional.of(clazz.cast(this.enableIAMDatabaseAuthentication()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RDSRequest.BuilderImpl
    implements Builder {
        private String dbInstanceIdentifier;
        private String dbSnapshotIdentifier;
        private String dbInstanceClass;
        private Integer port;
        private String availabilityZone;
        private String dbSubnetGroupName;
        private Boolean multiAZ;
        private Boolean publiclyAccessible;
        private Boolean autoMinorVersionUpgrade;
        private String licenseModel;
        private String dbName;
        private String engine;
        private Integer iops;
        private String optionGroupName;
        private List<Tag> tags;
        private String storageType;
        private String tdeCredentialArn;
        private String tdeCredentialPassword;
        private String domain;
        private Boolean copyTagsToSnapshot;
        private String domainIAMRoleName;
        private Boolean enableIAMDatabaseAuthentication;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreDBInstanceFromDBSnapshotRequest model) {
            this.dbInstanceIdentifier(model.dbInstanceIdentifier);
            this.dbSnapshotIdentifier(model.dbSnapshotIdentifier);
            this.dbInstanceClass(model.dbInstanceClass);
            this.port(model.port);
            this.availabilityZone(model.availabilityZone);
            this.dbSubnetGroupName(model.dbSubnetGroupName);
            this.multiAZ(model.multiAZ);
            this.publiclyAccessible(model.publiclyAccessible);
            this.autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            this.licenseModel(model.licenseModel);
            this.dbName(model.dbName);
            this.engine(model.engine);
            this.iops(model.iops);
            this.optionGroupName(model.optionGroupName);
            this.tags(model.tags);
            this.storageType(model.storageType);
            this.tdeCredentialArn(model.tdeCredentialArn);
            this.tdeCredentialPassword(model.tdeCredentialPassword);
            this.domain(model.domain);
            this.copyTagsToSnapshot(model.copyTagsToSnapshot);
            this.domainIAMRoleName(model.domainIAMRoleName);
            this.enableIAMDatabaseAuthentication(model.enableIAMDatabaseAuthentication);
        }

        public final String getDBInstanceIdentifier() {
            return this.dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final void setDBInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        public final String getDBSnapshotIdentifier() {
            return this.dbSnapshotIdentifier;
        }

        @Override
        public final Builder dbSnapshotIdentifier(String dbSnapshotIdentifier) {
            this.dbSnapshotIdentifier = dbSnapshotIdentifier;
            return this;
        }

        public final void setDBSnapshotIdentifier(String dbSnapshotIdentifier) {
            this.dbSnapshotIdentifier = dbSnapshotIdentifier;
        }

        public final String getDBInstanceClass() {
            return this.dbInstanceClass;
        }

        @Override
        public final Builder dbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        public final void setDBInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getDBSubnetGroupName() {
            return this.dbSubnetGroupName;
        }

        @Override
        public final Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        public final void setDBSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
        }

        public final Boolean getMultiAZ() {
            return this.multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        public final String getLicenseModel() {
            return this.licenseModel;
        }

        @Override
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        public final String getDBName() {
            return this.dbName;
        }

        @Override
        public final Builder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public final void setDBName(String dbName) {
            this.dbName = dbName;
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final Integer getIops() {
            return this.iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        public final String getOptionGroupName() {
            return this.optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getStorageType() {
            return this.storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        public final String getTdeCredentialArn() {
            return this.tdeCredentialArn;
        }

        @Override
        public final Builder tdeCredentialArn(String tdeCredentialArn) {
            this.tdeCredentialArn = tdeCredentialArn;
            return this;
        }

        public final void setTdeCredentialArn(String tdeCredentialArn) {
            this.tdeCredentialArn = tdeCredentialArn;
        }

        public final String getTdeCredentialPassword() {
            return this.tdeCredentialPassword;
        }

        @Override
        public final Builder tdeCredentialPassword(String tdeCredentialPassword) {
            this.tdeCredentialPassword = tdeCredentialPassword;
            return this;
        }

        public final void setTdeCredentialPassword(String tdeCredentialPassword) {
            this.tdeCredentialPassword = tdeCredentialPassword;
        }

        public final String getDomain() {
            return this.domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final Boolean getCopyTagsToSnapshot() {
            return this.copyTagsToSnapshot;
        }

        @Override
        public final Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        public final void setCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
        }

        public final String getDomainIAMRoleName() {
            return this.domainIAMRoleName;
        }

        @Override
        public final Builder domainIAMRoleName(String domainIAMRoleName) {
            this.domainIAMRoleName = domainIAMRoleName;
            return this;
        }

        public final void setDomainIAMRoleName(String domainIAMRoleName) {
            this.domainIAMRoleName = domainIAMRoleName;
        }

        public final Boolean getEnableIAMDatabaseAuthentication() {
            return this.enableIAMDatabaseAuthentication;
        }

        @Override
        public final Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
            return this;
        }

        public final void setEnableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public RestoreDBInstanceFromDBSnapshotRequest build() {
            return new RestoreDBInstanceFromDBSnapshotRequest(this);
        }
    }

    public static interface Builder
    extends RDSRequest.Builder,
    CopyableBuilder<Builder, RestoreDBInstanceFromDBSnapshotRequest> {
        public Builder dbInstanceIdentifier(String var1);

        public Builder dbSnapshotIdentifier(String var1);

        public Builder dbInstanceClass(String var1);

        public Builder port(Integer var1);

        public Builder availabilityZone(String var1);

        public Builder dbSubnetGroupName(String var1);

        public Builder multiAZ(Boolean var1);

        public Builder publiclyAccessible(Boolean var1);

        public Builder autoMinorVersionUpgrade(Boolean var1);

        public Builder licenseModel(String var1);

        public Builder dbName(String var1);

        public Builder engine(String var1);

        public Builder iops(Integer var1);

        public Builder optionGroupName(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder storageType(String var1);

        public Builder tdeCredentialArn(String var1);

        public Builder tdeCredentialPassword(String var1);

        public Builder domain(String var1);

        public Builder copyTagsToSnapshot(Boolean var1);

        public Builder domainIAMRoleName(String var1);

        public Builder enableIAMDatabaseAuthentication(Boolean var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

