/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Range
implements ToCopyableBuilder<Builder, Range> {
    private final Integer from;
    private final Integer to;
    private final Integer step;

    private Range(BuilderImpl builder) {
        this.from = builder.from;
        this.to = builder.to;
        this.step = builder.step;
    }

    public Integer from() {
        return this.from;
    }

    public Integer to() {
        return this.to;
    }

    public Integer step() {
        return this.step;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.from());
        hashCode = 31 * hashCode + Objects.hashCode(this.to());
        hashCode = 31 * hashCode + Objects.hashCode(this.step());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Range)) {
            return false;
        }
        Range other = (Range)obj;
        return Objects.equals(this.from(), other.from()) && Objects.equals(this.to(), other.to()) && Objects.equals(this.step(), other.step());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.from() != null) {
            sb.append("From: ").append(this.from()).append(",");
        }
        if (this.to() != null) {
            sb.append("To: ").append(this.to()).append(",");
        }
        if (this.step() != null) {
            sb.append("Step: ").append(this.step()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "From": {
                return Optional.of(clazz.cast(this.from()));
            }
            case "To": {
                return Optional.of(clazz.cast(this.to()));
            }
            case "Step": {
                return Optional.of(clazz.cast(this.step()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Integer from;
        private Integer to;
        private Integer step;

        private BuilderImpl() {
        }

        private BuilderImpl(Range model) {
            this.from(model.from);
            this.to(model.to);
            this.step(model.step);
        }

        public final Integer getFrom() {
            return this.from;
        }

        @Override
        public final Builder from(Integer from) {
            this.from = from;
            return this;
        }

        public final void setFrom(Integer from) {
            this.from = from;
        }

        public final Integer getTo() {
            return this.to;
        }

        @Override
        public final Builder to(Integer to) {
            this.to = to;
            return this;
        }

        public final void setTo(Integer to) {
            this.to = to;
        }

        public final Integer getStep() {
            return this.step;
        }

        @Override
        public final Builder step(Integer step) {
            this.step = step;
            return this;
        }

        public final void setStep(Integer step) {
            this.step = step;
        }

        public Range build() {
            return new Range(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Range> {
        public Builder from(Integer var1);

        public Builder to(Integer var1);

        public Builder step(Integer var1);
    }
}

