/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.rds.model.OptionGroupOption;
import software.amazon.awssdk.services.rds.model.OptionGroupOptionsListCopier;
import software.amazon.awssdk.services.rds.model.RDSResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeOptionGroupOptionsResponse
extends RDSResponse
implements ToCopyableBuilder<Builder, DescribeOptionGroupOptionsResponse> {
    private final List<OptionGroupOption> optionGroupOptions;
    private final String marker;

    private DescribeOptionGroupOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.optionGroupOptions = builder.optionGroupOptions;
        this.marker = builder.marker;
    }

    public List<OptionGroupOption> optionGroupOptions() {
        return this.optionGroupOptions;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.optionGroupOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOptionGroupOptionsResponse)) {
            return false;
        }
        DescribeOptionGroupOptionsResponse other = (DescribeOptionGroupOptionsResponse)((Object)obj);
        return Objects.equals(this.optionGroupOptions(), other.optionGroupOptions()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.optionGroupOptions() != null) {
            sb.append("OptionGroupOptions: ").append(this.optionGroupOptions()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OptionGroupOptions": {
                return Optional.of(clazz.cast(this.optionGroupOptions()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RDSResponse.BuilderImpl
    implements Builder {
        private List<OptionGroupOption> optionGroupOptions;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOptionGroupOptionsResponse model) {
            this.optionGroupOptions(model.optionGroupOptions);
            this.marker(model.marker);
        }

        public final Collection<OptionGroupOption.Builder> getOptionGroupOptions() {
            return this.optionGroupOptions != null ? (Collection)this.optionGroupOptions.stream().map(OptionGroupOption::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder optionGroupOptions(Collection<OptionGroupOption> optionGroupOptions) {
            this.optionGroupOptions = OptionGroupOptionsListCopier.copy(optionGroupOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionGroupOptions(OptionGroupOption ... optionGroupOptions) {
            this.optionGroupOptions(Arrays.asList(optionGroupOptions));
            return this;
        }

        public final void setOptionGroupOptions(Collection<OptionGroupOption.BuilderImpl> optionGroupOptions) {
            this.optionGroupOptions = OptionGroupOptionsListCopier.copyFromBuilder(optionGroupOptions);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeOptionGroupOptionsResponse build() {
            return new DescribeOptionGroupOptionsResponse(this);
        }
    }

    public static interface Builder
    extends RDSResponse.Builder,
    CopyableBuilder<Builder, DescribeOptionGroupOptionsResponse> {
        public Builder optionGroupOptions(Collection<OptionGroupOption> var1);

        public Builder optionGroupOptions(OptionGroupOption ... var1);

        public Builder marker(String var1);
    }
}

