/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.rds.model.Filter;
import software.amazon.awssdk.services.rds.model.FilterListCopier;
import software.amazon.awssdk.services.rds.model.RDSRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDBLogFilesRequest
extends RDSRequest
implements ToCopyableBuilder<Builder, DescribeDBLogFilesRequest> {
    private final String dbInstanceIdentifier;
    private final String filenameContains;
    private final Long fileLastWritten;
    private final Long fileSize;
    private final List<Filter> filters;
    private final Integer maxRecords;
    private final String marker;

    private DescribeDBLogFilesRequest(BuilderImpl builder) {
        super(builder);
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.filenameContains = builder.filenameContains;
        this.fileLastWritten = builder.fileLastWritten;
        this.fileSize = builder.fileSize;
        this.filters = builder.filters;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
    }

    public String dbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public String filenameContains() {
        return this.filenameContains;
    }

    public Long fileLastWritten() {
        return this.fileLastWritten;
    }

    public Long fileSize() {
        return this.fileSize;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public String marker() {
        return this.marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.filenameContains());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileLastWritten());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDBLogFilesRequest)) {
            return false;
        }
        DescribeDBLogFilesRequest other = (DescribeDBLogFilesRequest)((Object)obj);
        return Objects.equals(this.dbInstanceIdentifier(), other.dbInstanceIdentifier()) && Objects.equals(this.filenameContains(), other.filenameContains()) && Objects.equals(this.fileLastWritten(), other.fileLastWritten()) && Objects.equals(this.fileSize(), other.fileSize()) && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.maxRecords(), other.maxRecords()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.dbInstanceIdentifier() != null) {
            sb.append("DBInstanceIdentifier: ").append(this.dbInstanceIdentifier()).append(",");
        }
        if (this.filenameContains() != null) {
            sb.append("FilenameContains: ").append(this.filenameContains()).append(",");
        }
        if (this.fileLastWritten() != null) {
            sb.append("FileLastWritten: ").append(this.fileLastWritten()).append(",");
        }
        if (this.fileSize() != null) {
            sb.append("FileSize: ").append(this.fileSize()).append(",");
        }
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.maxRecords() != null) {
            sb.append("MaxRecords: ").append(this.maxRecords()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBInstanceIdentifier": {
                return Optional.of(clazz.cast(this.dbInstanceIdentifier()));
            }
            case "FilenameContains": {
                return Optional.of(clazz.cast(this.filenameContains()));
            }
            case "FileLastWritten": {
                return Optional.of(clazz.cast(this.fileLastWritten()));
            }
            case "FileSize": {
                return Optional.of(clazz.cast(this.fileSize()));
            }
            case "Filters": {
                return Optional.of(clazz.cast(this.filters()));
            }
            case "MaxRecords": {
                return Optional.of(clazz.cast(this.maxRecords()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RDSRequest.BuilderImpl
    implements Builder {
        private String dbInstanceIdentifier;
        private String filenameContains;
        private Long fileLastWritten;
        private Long fileSize;
        private List<Filter> filters;
        private Integer maxRecords;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDBLogFilesRequest model) {
            this.dbInstanceIdentifier(model.dbInstanceIdentifier);
            this.filenameContains(model.filenameContains);
            this.fileLastWritten(model.fileLastWritten);
            this.fileSize(model.fileSize);
            this.filters(model.filters);
            this.maxRecords(model.maxRecords);
            this.marker(model.marker);
        }

        public final String getDBInstanceIdentifier() {
            return this.dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final void setDBInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        public final String getFilenameContains() {
            return this.filenameContains;
        }

        @Override
        public final Builder filenameContains(String filenameContains) {
            this.filenameContains = filenameContains;
            return this;
        }

        public final void setFilenameContains(String filenameContains) {
            this.filenameContains = filenameContains;
        }

        public final Long getFileLastWritten() {
            return this.fileLastWritten;
        }

        @Override
        public final Builder fileLastWritten(Long fileLastWritten) {
            this.fileLastWritten = fileLastWritten;
            return this;
        }

        public final void setFileLastWritten(Long fileLastWritten) {
            this.fileLastWritten = fileLastWritten;
        }

        public final Long getFileSize() {
            return this.fileSize;
        }

        @Override
        public final Builder fileSize(Long fileSize) {
            this.fileSize = fileSize;
            return this;
        }

        public final void setFileSize(Long fileSize) {
            this.fileSize = fileSize;
        }

        public final Collection<Filter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeDBLogFilesRequest build() {
            return new DescribeDBLogFilesRequest(this);
        }
    }

    public static interface Builder
    extends RDSRequest.Builder,
    CopyableBuilder<Builder, DescribeDBLogFilesRequest> {
        public Builder dbInstanceIdentifier(String var1);

        public Builder filenameContains(String var1);

        public Builder fileLastWritten(Long var1);

        public Builder fileSize(Long var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder maxRecords(Integer var1);

        public Builder marker(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

