/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.rds.model.DBClusterSnapshotAttribute;
import software.amazon.awssdk.services.rds.model.DBClusterSnapshotAttributeListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DBClusterSnapshotAttributesResult
implements ToCopyableBuilder<Builder, DBClusterSnapshotAttributesResult> {
    private final String dbClusterSnapshotIdentifier;
    private final List<DBClusterSnapshotAttribute> dbClusterSnapshotAttributes;

    private DBClusterSnapshotAttributesResult(BuilderImpl builder) {
        this.dbClusterSnapshotIdentifier = builder.dbClusterSnapshotIdentifier;
        this.dbClusterSnapshotAttributes = builder.dbClusterSnapshotAttributes;
    }

    public String dbClusterSnapshotIdentifier() {
        return this.dbClusterSnapshotIdentifier;
    }

    public List<DBClusterSnapshotAttribute> dbClusterSnapshotAttributes() {
        return this.dbClusterSnapshotAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterSnapshotAttributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBClusterSnapshotAttributesResult)) {
            return false;
        }
        DBClusterSnapshotAttributesResult other = (DBClusterSnapshotAttributesResult)obj;
        return Objects.equals(this.dbClusterSnapshotIdentifier(), other.dbClusterSnapshotIdentifier()) && Objects.equals(this.dbClusterSnapshotAttributes(), other.dbClusterSnapshotAttributes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.dbClusterSnapshotIdentifier() != null) {
            sb.append("DBClusterSnapshotIdentifier: ").append(this.dbClusterSnapshotIdentifier()).append(",");
        }
        if (this.dbClusterSnapshotAttributes() != null) {
            sb.append("DBClusterSnapshotAttributes: ").append(this.dbClusterSnapshotAttributes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBClusterSnapshotIdentifier": {
                return Optional.of(clazz.cast(this.dbClusterSnapshotIdentifier()));
            }
            case "DBClusterSnapshotAttributes": {
                return Optional.of(clazz.cast(this.dbClusterSnapshotAttributes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String dbClusterSnapshotIdentifier;
        private List<DBClusterSnapshotAttribute> dbClusterSnapshotAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(DBClusterSnapshotAttributesResult model) {
            this.dbClusterSnapshotIdentifier(model.dbClusterSnapshotIdentifier);
            this.dbClusterSnapshotAttributes(model.dbClusterSnapshotAttributes);
        }

        public final String getDBClusterSnapshotIdentifier() {
            return this.dbClusterSnapshotIdentifier;
        }

        @Override
        public final Builder dbClusterSnapshotIdentifier(String dbClusterSnapshotIdentifier) {
            this.dbClusterSnapshotIdentifier = dbClusterSnapshotIdentifier;
            return this;
        }

        public final void setDBClusterSnapshotIdentifier(String dbClusterSnapshotIdentifier) {
            this.dbClusterSnapshotIdentifier = dbClusterSnapshotIdentifier;
        }

        public final Collection<DBClusterSnapshotAttribute.Builder> getDBClusterSnapshotAttributes() {
            return this.dbClusterSnapshotAttributes != null ? (Collection)this.dbClusterSnapshotAttributes.stream().map(DBClusterSnapshotAttribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dbClusterSnapshotAttributes(Collection<DBClusterSnapshotAttribute> dbClusterSnapshotAttributes) {
            this.dbClusterSnapshotAttributes = DBClusterSnapshotAttributeListCopier.copy(dbClusterSnapshotAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterSnapshotAttributes(DBClusterSnapshotAttribute ... dbClusterSnapshotAttributes) {
            this.dbClusterSnapshotAttributes(Arrays.asList(dbClusterSnapshotAttributes));
            return this;
        }

        public final void setDBClusterSnapshotAttributes(Collection<DBClusterSnapshotAttribute.BuilderImpl> dbClusterSnapshotAttributes) {
            this.dbClusterSnapshotAttributes = DBClusterSnapshotAttributeListCopier.copyFromBuilder(dbClusterSnapshotAttributes);
        }

        public DBClusterSnapshotAttributesResult build() {
            return new DBClusterSnapshotAttributesResult(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DBClusterSnapshotAttributesResult> {
        public Builder dbClusterSnapshotIdentifier(String var1);

        public Builder dbClusterSnapshotAttributes(Collection<DBClusterSnapshotAttribute> var1);

        public Builder dbClusterSnapshotAttributes(DBClusterSnapshotAttribute ... var1);
    }
}

