/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rds.model.CharacterSet;

public class CharacterSetUnmarshaller
implements Unmarshaller<CharacterSet, StaxUnmarshallerContext> {
    private static final CharacterSetUnmarshaller INSTANCE = new CharacterSetUnmarshaller();

    public CharacterSet unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        CharacterSet.Builder characterSet = CharacterSet.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("CharacterSetName", targetDepth)) {
                    characterSet.characterSetName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("CharacterSetDescription", targetDepth)) continue;
                characterSet.characterSetDescription(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (CharacterSet)characterSet.build();
    }

    public static CharacterSetUnmarshaller getInstance() {
        return INSTANCE;
    }
}

