/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.rds.RDSClient;
import software.amazon.awssdk.services.rds.model.DBSecurityGroup;
import software.amazon.awssdk.services.rds.model.DescribeDBSecurityGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDBSecurityGroupsResponse;

public final class DescribeDBSecurityGroupsPaginator
implements SdkIterable<DescribeDBSecurityGroupsResponse> {
    private final RDSClient client;
    private final DescribeDBSecurityGroupsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeDBSecurityGroupsPaginator(RDSClient client, DescribeDBSecurityGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDBSecurityGroupsResponseFetcher();
    }

    public Iterator<DescribeDBSecurityGroupsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<DBSecurityGroup> dbSecurityGroups() {
        Function<DescribeDBSecurityGroupsResponse, Iterator> getIterator = response -> response != null ? response.dbSecurityGroups().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeDBSecurityGroupsResponseFetcher
    implements NextPageFetcher<DescribeDBSecurityGroupsResponse> {
        private DescribeDBSecurityGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDBSecurityGroupsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeDBSecurityGroupsResponse nextPage(DescribeDBSecurityGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBSecurityGroupsPaginator.this.client.describeDBSecurityGroups(DescribeDBSecurityGroupsPaginator.this.firstRequest);
            }
            return DescribeDBSecurityGroupsPaginator.this.client.describeDBSecurityGroups((DescribeDBSecurityGroupsRequest)((Object)DescribeDBSecurityGroupsPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

