/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.rds.RDSClient;
import software.amazon.awssdk.services.rds.model.DBInstance;
import software.amazon.awssdk.services.rds.model.DescribeDBInstancesRequest;
import software.amazon.awssdk.services.rds.model.DescribeDBInstancesResponse;

public final class DescribeDBInstancesPaginator
implements SdkIterable<DescribeDBInstancesResponse> {
    private final RDSClient client;
    private final DescribeDBInstancesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeDBInstancesPaginator(RDSClient client, DescribeDBInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDBInstancesResponseFetcher();
    }

    public Iterator<DescribeDBInstancesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<DBInstance> dbInstances() {
        Function<DescribeDBInstancesResponse, Iterator> getIterator = response -> response != null ? response.dbInstances().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeDBInstancesResponseFetcher
    implements NextPageFetcher<DescribeDBInstancesResponse> {
        private DescribeDBInstancesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDBInstancesResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeDBInstancesResponse nextPage(DescribeDBInstancesResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBInstancesPaginator.this.client.describeDBInstances(DescribeDBInstancesPaginator.this.firstRequest);
            }
            return DescribeDBInstancesPaginator.this.client.describeDBInstances((DescribeDBInstancesRequest)((Object)DescribeDBInstancesPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

