/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.rds.model.OptionGroupOptionSetting;
import software.amazon.awssdk.services.rds.model.OptionGroupOptionSettingsListCopier;
import software.amazon.awssdk.services.rds.model.OptionGroupOptionVersionsListCopier;
import software.amazon.awssdk.services.rds.model.OptionVersion;
import software.amazon.awssdk.services.rds.model.OptionsConflictsWithCopier;
import software.amazon.awssdk.services.rds.model.OptionsDependedOnCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class OptionGroupOption
implements ToCopyableBuilder<Builder, OptionGroupOption> {
    private final String name;
    private final String description;
    private final String engineName;
    private final String majorEngineVersion;
    private final String minimumRequiredMinorEngineVersion;
    private final Boolean portRequired;
    private final Integer defaultPort;
    private final List<String> optionsDependedOn;
    private final List<String> optionsConflictsWith;
    private final Boolean persistent;
    private final Boolean permanent;
    private final Boolean requiresAutoMinorEngineVersionUpgrade;
    private final Boolean vpcOnly;
    private final Boolean supportsOptionVersionDowngrade;
    private final List<OptionGroupOptionSetting> optionGroupOptionSettings;
    private final List<OptionVersion> optionGroupOptionVersions;

    private OptionGroupOption(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.engineName = builder.engineName;
        this.majorEngineVersion = builder.majorEngineVersion;
        this.minimumRequiredMinorEngineVersion = builder.minimumRequiredMinorEngineVersion;
        this.portRequired = builder.portRequired;
        this.defaultPort = builder.defaultPort;
        this.optionsDependedOn = builder.optionsDependedOn;
        this.optionsConflictsWith = builder.optionsConflictsWith;
        this.persistent = builder.persistent;
        this.permanent = builder.permanent;
        this.requiresAutoMinorEngineVersionUpgrade = builder.requiresAutoMinorEngineVersionUpgrade;
        this.vpcOnly = builder.vpcOnly;
        this.supportsOptionVersionDowngrade = builder.supportsOptionVersionDowngrade;
        this.optionGroupOptionSettings = builder.optionGroupOptionSettings;
        this.optionGroupOptionVersions = builder.optionGroupOptionVersions;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String engineName() {
        return this.engineName;
    }

    public String majorEngineVersion() {
        return this.majorEngineVersion;
    }

    public String minimumRequiredMinorEngineVersion() {
        return this.minimumRequiredMinorEngineVersion;
    }

    public Boolean portRequired() {
        return this.portRequired;
    }

    public Integer defaultPort() {
        return this.defaultPort;
    }

    public List<String> optionsDependedOn() {
        return this.optionsDependedOn;
    }

    public List<String> optionsConflictsWith() {
        return this.optionsConflictsWith;
    }

    public Boolean persistent() {
        return this.persistent;
    }

    public Boolean permanent() {
        return this.permanent;
    }

    public Boolean requiresAutoMinorEngineVersionUpgrade() {
        return this.requiresAutoMinorEngineVersionUpgrade;
    }

    public Boolean vpcOnly() {
        return this.vpcOnly;
    }

    public Boolean supportsOptionVersionDowngrade() {
        return this.supportsOptionVersionDowngrade;
    }

    public List<OptionGroupOptionSetting> optionGroupOptionSettings() {
        return this.optionGroupOptionSettings;
    }

    public List<OptionVersion> optionGroupOptionVersions() {
        return this.optionGroupOptionVersions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.majorEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumRequiredMinorEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.portRequired());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionsDependedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionsConflictsWith());
        hashCode = 31 * hashCode + Objects.hashCode(this.persistent());
        hashCode = 31 * hashCode + Objects.hashCode(this.permanent());
        hashCode = 31 * hashCode + Objects.hashCode(this.requiresAutoMinorEngineVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcOnly());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsOptionVersionDowngrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionGroupOptionSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionGroupOptionVersions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptionGroupOption)) {
            return false;
        }
        OptionGroupOption other = (OptionGroupOption)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.engineName(), other.engineName()) && Objects.equals(this.majorEngineVersion(), other.majorEngineVersion()) && Objects.equals(this.minimumRequiredMinorEngineVersion(), other.minimumRequiredMinorEngineVersion()) && Objects.equals(this.portRequired(), other.portRequired()) && Objects.equals(this.defaultPort(), other.defaultPort()) && Objects.equals(this.optionsDependedOn(), other.optionsDependedOn()) && Objects.equals(this.optionsConflictsWith(), other.optionsConflictsWith()) && Objects.equals(this.persistent(), other.persistent()) && Objects.equals(this.permanent(), other.permanent()) && Objects.equals(this.requiresAutoMinorEngineVersionUpgrade(), other.requiresAutoMinorEngineVersionUpgrade()) && Objects.equals(this.vpcOnly(), other.vpcOnly()) && Objects.equals(this.supportsOptionVersionDowngrade(), other.supportsOptionVersionDowngrade()) && Objects.equals(this.optionGroupOptionSettings(), other.optionGroupOptionSettings()) && Objects.equals(this.optionGroupOptionVersions(), other.optionGroupOptionVersions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.engineName() != null) {
            sb.append("EngineName: ").append(this.engineName()).append(",");
        }
        if (this.majorEngineVersion() != null) {
            sb.append("MajorEngineVersion: ").append(this.majorEngineVersion()).append(",");
        }
        if (this.minimumRequiredMinorEngineVersion() != null) {
            sb.append("MinimumRequiredMinorEngineVersion: ").append(this.minimumRequiredMinorEngineVersion()).append(",");
        }
        if (this.portRequired() != null) {
            sb.append("PortRequired: ").append(this.portRequired()).append(",");
        }
        if (this.defaultPort() != null) {
            sb.append("DefaultPort: ").append(this.defaultPort()).append(",");
        }
        if (this.optionsDependedOn() != null) {
            sb.append("OptionsDependedOn: ").append(this.optionsDependedOn()).append(",");
        }
        if (this.optionsConflictsWith() != null) {
            sb.append("OptionsConflictsWith: ").append(this.optionsConflictsWith()).append(",");
        }
        if (this.persistent() != null) {
            sb.append("Persistent: ").append(this.persistent()).append(",");
        }
        if (this.permanent() != null) {
            sb.append("Permanent: ").append(this.permanent()).append(",");
        }
        if (this.requiresAutoMinorEngineVersionUpgrade() != null) {
            sb.append("RequiresAutoMinorEngineVersionUpgrade: ").append(this.requiresAutoMinorEngineVersionUpgrade()).append(",");
        }
        if (this.vpcOnly() != null) {
            sb.append("VpcOnly: ").append(this.vpcOnly()).append(",");
        }
        if (this.supportsOptionVersionDowngrade() != null) {
            sb.append("SupportsOptionVersionDowngrade: ").append(this.supportsOptionVersionDowngrade()).append(",");
        }
        if (this.optionGroupOptionSettings() != null) {
            sb.append("OptionGroupOptionSettings: ").append(this.optionGroupOptionSettings()).append(",");
        }
        if (this.optionGroupOptionVersions() != null) {
            sb.append("OptionGroupOptionVersions: ").append(this.optionGroupOptionVersions()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "EngineName": {
                return Optional.of(clazz.cast(this.engineName()));
            }
            case "MajorEngineVersion": {
                return Optional.of(clazz.cast(this.majorEngineVersion()));
            }
            case "MinimumRequiredMinorEngineVersion": {
                return Optional.of(clazz.cast(this.minimumRequiredMinorEngineVersion()));
            }
            case "PortRequired": {
                return Optional.of(clazz.cast(this.portRequired()));
            }
            case "DefaultPort": {
                return Optional.of(clazz.cast(this.defaultPort()));
            }
            case "OptionsDependedOn": {
                return Optional.of(clazz.cast(this.optionsDependedOn()));
            }
            case "OptionsConflictsWith": {
                return Optional.of(clazz.cast(this.optionsConflictsWith()));
            }
            case "Persistent": {
                return Optional.of(clazz.cast(this.persistent()));
            }
            case "Permanent": {
                return Optional.of(clazz.cast(this.permanent()));
            }
            case "RequiresAutoMinorEngineVersionUpgrade": {
                return Optional.of(clazz.cast(this.requiresAutoMinorEngineVersionUpgrade()));
            }
            case "VpcOnly": {
                return Optional.of(clazz.cast(this.vpcOnly()));
            }
            case "SupportsOptionVersionDowngrade": {
                return Optional.of(clazz.cast(this.supportsOptionVersionDowngrade()));
            }
            case "OptionGroupOptionSettings": {
                return Optional.of(clazz.cast(this.optionGroupOptionSettings()));
            }
            case "OptionGroupOptionVersions": {
                return Optional.of(clazz.cast(this.optionGroupOptionVersions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String engineName;
        private String majorEngineVersion;
        private String minimumRequiredMinorEngineVersion;
        private Boolean portRequired;
        private Integer defaultPort;
        private List<String> optionsDependedOn;
        private List<String> optionsConflictsWith;
        private Boolean persistent;
        private Boolean permanent;
        private Boolean requiresAutoMinorEngineVersionUpgrade;
        private Boolean vpcOnly;
        private Boolean supportsOptionVersionDowngrade;
        private List<OptionGroupOptionSetting> optionGroupOptionSettings;
        private List<OptionVersion> optionGroupOptionVersions;

        private BuilderImpl() {
        }

        private BuilderImpl(OptionGroupOption model) {
            this.name(model.name);
            this.description(model.description);
            this.engineName(model.engineName);
            this.majorEngineVersion(model.majorEngineVersion);
            this.minimumRequiredMinorEngineVersion(model.minimumRequiredMinorEngineVersion);
            this.portRequired(model.portRequired);
            this.defaultPort(model.defaultPort);
            this.optionsDependedOn(model.optionsDependedOn);
            this.optionsConflictsWith(model.optionsConflictsWith);
            this.persistent(model.persistent);
            this.permanent(model.permanent);
            this.requiresAutoMinorEngineVersionUpgrade(model.requiresAutoMinorEngineVersionUpgrade);
            this.vpcOnly(model.vpcOnly);
            this.supportsOptionVersionDowngrade(model.supportsOptionVersionDowngrade);
            this.optionGroupOptionSettings(model.optionGroupOptionSettings);
            this.optionGroupOptionVersions(model.optionGroupOptionVersions);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getEngineName() {
            return this.engineName;
        }

        @Override
        public final Builder engineName(String engineName) {
            this.engineName = engineName;
            return this;
        }

        public final void setEngineName(String engineName) {
            this.engineName = engineName;
        }

        public final String getMajorEngineVersion() {
            return this.majorEngineVersion;
        }

        @Override
        public final Builder majorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
            return this;
        }

        public final void setMajorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
        }

        public final String getMinimumRequiredMinorEngineVersion() {
            return this.minimumRequiredMinorEngineVersion;
        }

        @Override
        public final Builder minimumRequiredMinorEngineVersion(String minimumRequiredMinorEngineVersion) {
            this.minimumRequiredMinorEngineVersion = minimumRequiredMinorEngineVersion;
            return this;
        }

        public final void setMinimumRequiredMinorEngineVersion(String minimumRequiredMinorEngineVersion) {
            this.minimumRequiredMinorEngineVersion = minimumRequiredMinorEngineVersion;
        }

        public final Boolean getPortRequired() {
            return this.portRequired;
        }

        @Override
        public final Builder portRequired(Boolean portRequired) {
            this.portRequired = portRequired;
            return this;
        }

        public final void setPortRequired(Boolean portRequired) {
            this.portRequired = portRequired;
        }

        public final Integer getDefaultPort() {
            return this.defaultPort;
        }

        @Override
        public final Builder defaultPort(Integer defaultPort) {
            this.defaultPort = defaultPort;
            return this;
        }

        public final void setDefaultPort(Integer defaultPort) {
            this.defaultPort = defaultPort;
        }

        public final Collection<String> getOptionsDependedOn() {
            return this.optionsDependedOn;
        }

        @Override
        public final Builder optionsDependedOn(Collection<String> optionsDependedOn) {
            this.optionsDependedOn = OptionsDependedOnCopier.copy(optionsDependedOn);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionsDependedOn(String ... optionsDependedOn) {
            this.optionsDependedOn(Arrays.asList(optionsDependedOn));
            return this;
        }

        public final void setOptionsDependedOn(Collection<String> optionsDependedOn) {
            this.optionsDependedOn = OptionsDependedOnCopier.copy(optionsDependedOn);
        }

        public final Collection<String> getOptionsConflictsWith() {
            return this.optionsConflictsWith;
        }

        @Override
        public final Builder optionsConflictsWith(Collection<String> optionsConflictsWith) {
            this.optionsConflictsWith = OptionsConflictsWithCopier.copy(optionsConflictsWith);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionsConflictsWith(String ... optionsConflictsWith) {
            this.optionsConflictsWith(Arrays.asList(optionsConflictsWith));
            return this;
        }

        public final void setOptionsConflictsWith(Collection<String> optionsConflictsWith) {
            this.optionsConflictsWith = OptionsConflictsWithCopier.copy(optionsConflictsWith);
        }

        public final Boolean getPersistent() {
            return this.persistent;
        }

        @Override
        public final Builder persistent(Boolean persistent) {
            this.persistent = persistent;
            return this;
        }

        public final void setPersistent(Boolean persistent) {
            this.persistent = persistent;
        }

        public final Boolean getPermanent() {
            return this.permanent;
        }

        @Override
        public final Builder permanent(Boolean permanent) {
            this.permanent = permanent;
            return this;
        }

        public final void setPermanent(Boolean permanent) {
            this.permanent = permanent;
        }

        public final Boolean getRequiresAutoMinorEngineVersionUpgrade() {
            return this.requiresAutoMinorEngineVersionUpgrade;
        }

        @Override
        public final Builder requiresAutoMinorEngineVersionUpgrade(Boolean requiresAutoMinorEngineVersionUpgrade) {
            this.requiresAutoMinorEngineVersionUpgrade = requiresAutoMinorEngineVersionUpgrade;
            return this;
        }

        public final void setRequiresAutoMinorEngineVersionUpgrade(Boolean requiresAutoMinorEngineVersionUpgrade) {
            this.requiresAutoMinorEngineVersionUpgrade = requiresAutoMinorEngineVersionUpgrade;
        }

        public final Boolean getVpcOnly() {
            return this.vpcOnly;
        }

        @Override
        public final Builder vpcOnly(Boolean vpcOnly) {
            this.vpcOnly = vpcOnly;
            return this;
        }

        public final void setVpcOnly(Boolean vpcOnly) {
            this.vpcOnly = vpcOnly;
        }

        public final Boolean getSupportsOptionVersionDowngrade() {
            return this.supportsOptionVersionDowngrade;
        }

        @Override
        public final Builder supportsOptionVersionDowngrade(Boolean supportsOptionVersionDowngrade) {
            this.supportsOptionVersionDowngrade = supportsOptionVersionDowngrade;
            return this;
        }

        public final void setSupportsOptionVersionDowngrade(Boolean supportsOptionVersionDowngrade) {
            this.supportsOptionVersionDowngrade = supportsOptionVersionDowngrade;
        }

        public final Collection<OptionGroupOptionSetting.Builder> getOptionGroupOptionSettings() {
            return this.optionGroupOptionSettings != null ? (Collection)this.optionGroupOptionSettings.stream().map(OptionGroupOptionSetting::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder optionGroupOptionSettings(Collection<OptionGroupOptionSetting> optionGroupOptionSettings) {
            this.optionGroupOptionSettings = OptionGroupOptionSettingsListCopier.copy(optionGroupOptionSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionGroupOptionSettings(OptionGroupOptionSetting ... optionGroupOptionSettings) {
            this.optionGroupOptionSettings(Arrays.asList(optionGroupOptionSettings));
            return this;
        }

        public final void setOptionGroupOptionSettings(Collection<OptionGroupOptionSetting.BuilderImpl> optionGroupOptionSettings) {
            this.optionGroupOptionSettings = OptionGroupOptionSettingsListCopier.copyFromBuilder(optionGroupOptionSettings);
        }

        public final Collection<OptionVersion.Builder> getOptionGroupOptionVersions() {
            return this.optionGroupOptionVersions != null ? (Collection)this.optionGroupOptionVersions.stream().map(OptionVersion::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder optionGroupOptionVersions(Collection<OptionVersion> optionGroupOptionVersions) {
            this.optionGroupOptionVersions = OptionGroupOptionVersionsListCopier.copy(optionGroupOptionVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionGroupOptionVersions(OptionVersion ... optionGroupOptionVersions) {
            this.optionGroupOptionVersions(Arrays.asList(optionGroupOptionVersions));
            return this;
        }

        public final void setOptionGroupOptionVersions(Collection<OptionVersion.BuilderImpl> optionGroupOptionVersions) {
            this.optionGroupOptionVersions = OptionGroupOptionVersionsListCopier.copyFromBuilder(optionGroupOptionVersions);
        }

        public OptionGroupOption build() {
            return new OptionGroupOption(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, OptionGroupOption> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder engineName(String var1);

        public Builder majorEngineVersion(String var1);

        public Builder minimumRequiredMinorEngineVersion(String var1);

        public Builder portRequired(Boolean var1);

        public Builder defaultPort(Integer var1);

        public Builder optionsDependedOn(Collection<String> var1);

        public Builder optionsDependedOn(String ... var1);

        public Builder optionsConflictsWith(Collection<String> var1);

        public Builder optionsConflictsWith(String ... var1);

        public Builder persistent(Boolean var1);

        public Builder permanent(Boolean var1);

        public Builder requiresAutoMinorEngineVersionUpgrade(Boolean var1);

        public Builder vpcOnly(Boolean var1);

        public Builder supportsOptionVersionDowngrade(Boolean var1);

        public Builder optionGroupOptionSettings(Collection<OptionGroupOptionSetting> var1);

        public Builder optionGroupOptionSettings(OptionGroupOptionSetting ... var1);

        public Builder optionGroupOptionVersions(Collection<OptionVersion> var1);

        public Builder optionGroupOptionVersions(OptionVersion ... var1);
    }
}

