/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyDBSnapshotRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ModifyDBSnapshotRequest> {
    private final String dbSnapshotIdentifier;
    private final String engineVersion;
    private final String optionGroupName;

    private ModifyDBSnapshotRequest(BuilderImpl builder) {
        this.dbSnapshotIdentifier = builder.dbSnapshotIdentifier;
        this.engineVersion = builder.engineVersion;
        this.optionGroupName = builder.optionGroupName;
    }

    public String dbSnapshotIdentifier() {
        return this.dbSnapshotIdentifier;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public String optionGroupName() {
        return this.optionGroupName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionGroupName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDBSnapshotRequest)) {
            return false;
        }
        ModifyDBSnapshotRequest other = (ModifyDBSnapshotRequest)((Object)obj);
        return Objects.equals(this.dbSnapshotIdentifier(), other.dbSnapshotIdentifier()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.optionGroupName(), other.optionGroupName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.dbSnapshotIdentifier() != null) {
            sb.append("DBSnapshotIdentifier: ").append(this.dbSnapshotIdentifier()).append(",");
        }
        if (this.engineVersion() != null) {
            sb.append("EngineVersion: ").append(this.engineVersion()).append(",");
        }
        if (this.optionGroupName() != null) {
            sb.append("OptionGroupName: ").append(this.optionGroupName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBSnapshotIdentifier": {
                return Optional.of(clazz.cast(this.dbSnapshotIdentifier()));
            }
            case "EngineVersion": {
                return Optional.of(clazz.cast(this.engineVersion()));
            }
            case "OptionGroupName": {
                return Optional.of(clazz.cast(this.optionGroupName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String dbSnapshotIdentifier;
        private String engineVersion;
        private String optionGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDBSnapshotRequest model) {
            this.dbSnapshotIdentifier(model.dbSnapshotIdentifier);
            this.engineVersion(model.engineVersion);
            this.optionGroupName(model.optionGroupName);
        }

        public final String getDBSnapshotIdentifier() {
            return this.dbSnapshotIdentifier;
        }

        @Override
        public final Builder dbSnapshotIdentifier(String dbSnapshotIdentifier) {
            this.dbSnapshotIdentifier = dbSnapshotIdentifier;
            return this;
        }

        public final void setDBSnapshotIdentifier(String dbSnapshotIdentifier) {
            this.dbSnapshotIdentifier = dbSnapshotIdentifier;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getOptionGroupName() {
            return this.optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        public ModifyDBSnapshotRequest build() {
            return new ModifyDBSnapshotRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ModifyDBSnapshotRequest> {
        public Builder dbSnapshotIdentifier(String var1);

        public Builder engineVersion(String var1);

        public Builder optionGroupName(String var1);
    }
}

