/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.rds.model.AttributeValueListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyDBSnapshotAttributeRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ModifyDBSnapshotAttributeRequest> {
    private final String dbSnapshotIdentifier;
    private final String attributeName;
    private final List<String> valuesToAdd;
    private final List<String> valuesToRemove;

    private ModifyDBSnapshotAttributeRequest(BuilderImpl builder) {
        this.dbSnapshotIdentifier = builder.dbSnapshotIdentifier;
        this.attributeName = builder.attributeName;
        this.valuesToAdd = builder.valuesToAdd;
        this.valuesToRemove = builder.valuesToRemove;
    }

    public String dbSnapshotIdentifier() {
        return this.dbSnapshotIdentifier;
    }

    public String attributeName() {
        return this.attributeName;
    }

    public List<String> valuesToAdd() {
        return this.valuesToAdd;
    }

    public List<String> valuesToRemove() {
        return this.valuesToRemove;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.valuesToAdd());
        hashCode = 31 * hashCode + Objects.hashCode(this.valuesToRemove());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDBSnapshotAttributeRequest)) {
            return false;
        }
        ModifyDBSnapshotAttributeRequest other = (ModifyDBSnapshotAttributeRequest)((Object)obj);
        return Objects.equals(this.dbSnapshotIdentifier(), other.dbSnapshotIdentifier()) && Objects.equals(this.attributeName(), other.attributeName()) && Objects.equals(this.valuesToAdd(), other.valuesToAdd()) && Objects.equals(this.valuesToRemove(), other.valuesToRemove());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.dbSnapshotIdentifier() != null) {
            sb.append("DBSnapshotIdentifier: ").append(this.dbSnapshotIdentifier()).append(",");
        }
        if (this.attributeName() != null) {
            sb.append("AttributeName: ").append(this.attributeName()).append(",");
        }
        if (this.valuesToAdd() != null) {
            sb.append("ValuesToAdd: ").append(this.valuesToAdd()).append(",");
        }
        if (this.valuesToRemove() != null) {
            sb.append("ValuesToRemove: ").append(this.valuesToRemove()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBSnapshotIdentifier": {
                return Optional.of(clazz.cast(this.dbSnapshotIdentifier()));
            }
            case "AttributeName": {
                return Optional.of(clazz.cast(this.attributeName()));
            }
            case "ValuesToAdd": {
                return Optional.of(clazz.cast(this.valuesToAdd()));
            }
            case "ValuesToRemove": {
                return Optional.of(clazz.cast(this.valuesToRemove()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String dbSnapshotIdentifier;
        private String attributeName;
        private List<String> valuesToAdd;
        private List<String> valuesToRemove;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDBSnapshotAttributeRequest model) {
            this.dbSnapshotIdentifier(model.dbSnapshotIdentifier);
            this.attributeName(model.attributeName);
            this.valuesToAdd(model.valuesToAdd);
            this.valuesToRemove(model.valuesToRemove);
        }

        public final String getDBSnapshotIdentifier() {
            return this.dbSnapshotIdentifier;
        }

        @Override
        public final Builder dbSnapshotIdentifier(String dbSnapshotIdentifier) {
            this.dbSnapshotIdentifier = dbSnapshotIdentifier;
            return this;
        }

        public final void setDBSnapshotIdentifier(String dbSnapshotIdentifier) {
            this.dbSnapshotIdentifier = dbSnapshotIdentifier;
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public final Collection<String> getValuesToAdd() {
            return this.valuesToAdd;
        }

        @Override
        public final Builder valuesToAdd(Collection<String> valuesToAdd) {
            this.valuesToAdd = AttributeValueListCopier.copy(valuesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder valuesToAdd(String ... valuesToAdd) {
            this.valuesToAdd(Arrays.asList(valuesToAdd));
            return this;
        }

        public final void setValuesToAdd(Collection<String> valuesToAdd) {
            this.valuesToAdd = AttributeValueListCopier.copy(valuesToAdd);
        }

        public final Collection<String> getValuesToRemove() {
            return this.valuesToRemove;
        }

        @Override
        public final Builder valuesToRemove(Collection<String> valuesToRemove) {
            this.valuesToRemove = AttributeValueListCopier.copy(valuesToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder valuesToRemove(String ... valuesToRemove) {
            this.valuesToRemove(Arrays.asList(valuesToRemove));
            return this;
        }

        public final void setValuesToRemove(Collection<String> valuesToRemove) {
            this.valuesToRemove = AttributeValueListCopier.copy(valuesToRemove);
        }

        public ModifyDBSnapshotAttributeRequest build() {
            return new ModifyDBSnapshotAttributeRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ModifyDBSnapshotAttributeRequest> {
        public Builder dbSnapshotIdentifier(String var1);

        public Builder attributeName(String var1);

        public Builder valuesToAdd(Collection<String> var1);

        public Builder valuesToAdd(String ... var1);

        public Builder valuesToRemove(Collection<String> var1);

        public Builder valuesToRemove(String ... var1);
    }
}

