/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.rds.model.RestoreDBClusterToPointInTimeRequest;
import software.amazon.awssdk.services.rds.model.Tag;

public class RestoreDBClusterToPointInTimeRequestMarshaller
implements Marshaller<Request<RestoreDBClusterToPointInTimeRequest>, RestoreDBClusterToPointInTimeRequest> {
    public Request<RestoreDBClusterToPointInTimeRequest> marshall(RestoreDBClusterToPointInTimeRequest restoreDBClusterToPointInTimeRequest) {
        List<Tag> tagsList;
        List<String> vpcSecurityGroupIdsList;
        if (restoreDBClusterToPointInTimeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)restoreDBClusterToPointInTimeRequest, "RDSClient");
        request.addParameter("Action", "RestoreDBClusterToPointInTime");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (restoreDBClusterToPointInTimeRequest.dbClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringUtils.fromString((String)restoreDBClusterToPointInTimeRequest.dbClusterIdentifier()));
        }
        if (restoreDBClusterToPointInTimeRequest.restoreType() != null) {
            request.addParameter("RestoreType", StringUtils.fromString((String)restoreDBClusterToPointInTimeRequest.restoreType()));
        }
        if (restoreDBClusterToPointInTimeRequest.sourceDBClusterIdentifier() != null) {
            request.addParameter("SourceDBClusterIdentifier", StringUtils.fromString((String)restoreDBClusterToPointInTimeRequest.sourceDBClusterIdentifier()));
        }
        if (restoreDBClusterToPointInTimeRequest.restoreToTime() != null) {
            request.addParameter("RestoreToTime", StringUtils.fromInstant((Instant)restoreDBClusterToPointInTimeRequest.restoreToTime()));
        }
        if (restoreDBClusterToPointInTimeRequest.useLatestRestorableTime() != null) {
            request.addParameter("UseLatestRestorableTime", StringUtils.fromBoolean((Boolean)restoreDBClusterToPointInTimeRequest.useLatestRestorableTime()));
        }
        if (restoreDBClusterToPointInTimeRequest.port() != null) {
            request.addParameter("Port", StringUtils.fromInteger((Integer)restoreDBClusterToPointInTimeRequest.port()));
        }
        if (restoreDBClusterToPointInTimeRequest.dbSubnetGroupName() != null) {
            request.addParameter("DBSubnetGroupName", StringUtils.fromString((String)restoreDBClusterToPointInTimeRequest.dbSubnetGroupName()));
        }
        if (restoreDBClusterToPointInTimeRequest.optionGroupName() != null) {
            request.addParameter("OptionGroupName", StringUtils.fromString((String)restoreDBClusterToPointInTimeRequest.optionGroupName()));
        }
        if ((vpcSecurityGroupIdsList = restoreDBClusterToPointInTimeRequest.vpcSecurityGroupIds()) != null) {
            if (!vpcSecurityGroupIdsList.isEmpty()) {
                int vpcSecurityGroupIdsListIndex = 1;
                for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                    if (vpcSecurityGroupIdsListValue != null) {
                        request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringUtils.fromString((String)vpcSecurityGroupIdsListValue));
                    }
                    ++vpcSecurityGroupIdsListIndex;
                }
            } else {
                request.addParameter("VpcSecurityGroupIds", "");
            }
        }
        if ((tagsList = restoreDBClusterToPointInTimeRequest.tags()) != null) {
            if (!tagsList.isEmpty()) {
                int tagsListIndex = 1;
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue.key() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                    }
                    if (tagsListValue.value() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                    }
                    ++tagsListIndex;
                }
            } else {
                request.addParameter("Tags", "");
            }
        }
        if (restoreDBClusterToPointInTimeRequest.kmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString((String)restoreDBClusterToPointInTimeRequest.kmsKeyId()));
        }
        if (restoreDBClusterToPointInTimeRequest.enableIAMDatabaseAuthentication() != null) {
            request.addParameter("EnableIAMDatabaseAuthentication", StringUtils.fromBoolean((Boolean)restoreDBClusterToPointInTimeRequest.enableIAMDatabaseAuthentication()));
        }
        return request;
    }
}

