/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.rds.model.DeleteDBClusterRequest;

public class DeleteDBClusterRequestMarshaller
implements Marshaller<Request<DeleteDBClusterRequest>, DeleteDBClusterRequest> {
    public Request<DeleteDBClusterRequest> marshall(DeleteDBClusterRequest deleteDBClusterRequest) {
        if (deleteDBClusterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteDBClusterRequest, "RDSClient");
        request.addParameter("Action", "DeleteDBCluster");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteDBClusterRequest.dbClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringUtils.fromString((String)deleteDBClusterRequest.dbClusterIdentifier()));
        }
        if (deleteDBClusterRequest.skipFinalSnapshot() != null) {
            request.addParameter("SkipFinalSnapshot", StringUtils.fromBoolean((Boolean)deleteDBClusterRequest.skipFinalSnapshot()));
        }
        if (deleteDBClusterRequest.finalDBSnapshotIdentifier() != null) {
            request.addParameter("FinalDBSnapshotIdentifier", StringUtils.fromString((String)deleteDBClusterRequest.finalDBSnapshotIdentifier()));
        }
        return request;
    }
}

