/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Optional;
import software.amazon.awssdk.services.rds.model.AvailabilityZone;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Subnet
implements ToCopyableBuilder<Builder, Subnet> {
    private final String subnetIdentifier;
    private final AvailabilityZone subnetAvailabilityZone;
    private final String subnetStatus;

    private Subnet(BuilderImpl builder) {
        this.subnetIdentifier = builder.subnetIdentifier;
        this.subnetAvailabilityZone = builder.subnetAvailabilityZone;
        this.subnetStatus = builder.subnetStatus;
    }

    public String subnetIdentifier() {
        return this.subnetIdentifier;
    }

    public AvailabilityZone subnetAvailabilityZone() {
        return this.subnetAvailabilityZone;
    }

    public String subnetStatus() {
        return this.subnetStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.subnetIdentifier() == null ? 0 : this.subnetIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.subnetAvailabilityZone() == null ? 0 : this.subnetAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.subnetStatus() == null ? 0 : this.subnetStatus().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subnet)) {
            return false;
        }
        Subnet other = (Subnet)obj;
        if (other.subnetIdentifier() == null ^ this.subnetIdentifier() == null) {
            return false;
        }
        if (other.subnetIdentifier() != null && !other.subnetIdentifier().equals(this.subnetIdentifier())) {
            return false;
        }
        if (other.subnetAvailabilityZone() == null ^ this.subnetAvailabilityZone() == null) {
            return false;
        }
        if (other.subnetAvailabilityZone() != null && !other.subnetAvailabilityZone().equals(this.subnetAvailabilityZone())) {
            return false;
        }
        if (other.subnetStatus() == null ^ this.subnetStatus() == null) {
            return false;
        }
        return other.subnetStatus() == null || other.subnetStatus().equals(this.subnetStatus());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.subnetIdentifier() != null) {
            sb.append("SubnetIdentifier: ").append(this.subnetIdentifier()).append(",");
        }
        if (this.subnetAvailabilityZone() != null) {
            sb.append("SubnetAvailabilityZone: ").append(this.subnetAvailabilityZone()).append(",");
        }
        if (this.subnetStatus() != null) {
            sb.append("SubnetStatus: ").append(this.subnetStatus()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubnetIdentifier": {
                return Optional.of(clazz.cast(this.subnetIdentifier()));
            }
            case "SubnetAvailabilityZone": {
                return Optional.of(clazz.cast(this.subnetAvailabilityZone()));
            }
            case "SubnetStatus": {
                return Optional.of(clazz.cast(this.subnetStatus()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String subnetIdentifier;
        private AvailabilityZone subnetAvailabilityZone;
        private String subnetStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(Subnet model) {
            this.subnetIdentifier(model.subnetIdentifier);
            this.subnetAvailabilityZone(model.subnetAvailabilityZone);
            this.subnetStatus(model.subnetStatus);
        }

        public final String getSubnetIdentifier() {
            return this.subnetIdentifier;
        }

        @Override
        public final Builder subnetIdentifier(String subnetIdentifier) {
            this.subnetIdentifier = subnetIdentifier;
            return this;
        }

        public final void setSubnetIdentifier(String subnetIdentifier) {
            this.subnetIdentifier = subnetIdentifier;
        }

        public final AvailabilityZone.Builder getSubnetAvailabilityZone() {
            return this.subnetAvailabilityZone != null ? this.subnetAvailabilityZone.toBuilder() : null;
        }

        @Override
        public final Builder subnetAvailabilityZone(AvailabilityZone subnetAvailabilityZone) {
            this.subnetAvailabilityZone = subnetAvailabilityZone;
            return this;
        }

        public final void setSubnetAvailabilityZone(AvailabilityZone.BuilderImpl subnetAvailabilityZone) {
            this.subnetAvailabilityZone = subnetAvailabilityZone != null ? subnetAvailabilityZone.build() : null;
        }

        public final String getSubnetStatus() {
            return this.subnetStatus;
        }

        @Override
        public final Builder subnetStatus(String subnetStatus) {
            this.subnetStatus = subnetStatus;
            return this;
        }

        public final void setSubnetStatus(String subnetStatus) {
            this.subnetStatus = subnetStatus;
        }

        public Subnet build() {
            return new Subnet(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Subnet> {
        public Builder subnetIdentifier(String var1);

        public Builder subnetAvailabilityZone(AvailabilityZone var1);

        public Builder subnetStatus(String var1);
    }
}

