/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.rds.model.RecurringCharge;
import software.amazon.awssdk.services.rds.model.RecurringChargeListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReservedDBInstance
implements ToCopyableBuilder<Builder, ReservedDBInstance> {
    private final String reservedDBInstanceId;
    private final String reservedDBInstancesOfferingId;
    private final String dbInstanceClass;
    private final Instant startTime;
    private final Integer duration;
    private final Double fixedPrice;
    private final Double usagePrice;
    private final String currencyCode;
    private final Integer dbInstanceCount;
    private final String productDescription;
    private final String offeringType;
    private final Boolean multiAZ;
    private final String state;
    private final List<RecurringCharge> recurringCharges;
    private final String reservedDBInstanceArn;

    private ReservedDBInstance(BuilderImpl builder) {
        this.reservedDBInstanceId = builder.reservedDBInstanceId;
        this.reservedDBInstancesOfferingId = builder.reservedDBInstancesOfferingId;
        this.dbInstanceClass = builder.dbInstanceClass;
        this.startTime = builder.startTime;
        this.duration = builder.duration;
        this.fixedPrice = builder.fixedPrice;
        this.usagePrice = builder.usagePrice;
        this.currencyCode = builder.currencyCode;
        this.dbInstanceCount = builder.dbInstanceCount;
        this.productDescription = builder.productDescription;
        this.offeringType = builder.offeringType;
        this.multiAZ = builder.multiAZ;
        this.state = builder.state;
        this.recurringCharges = builder.recurringCharges;
        this.reservedDBInstanceArn = builder.reservedDBInstanceArn;
    }

    public String reservedDBInstanceId() {
        return this.reservedDBInstanceId;
    }

    public String reservedDBInstancesOfferingId() {
        return this.reservedDBInstancesOfferingId;
    }

    public String dbInstanceClass() {
        return this.dbInstanceClass;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Integer duration() {
        return this.duration;
    }

    public Double fixedPrice() {
        return this.fixedPrice;
    }

    public Double usagePrice() {
        return this.usagePrice;
    }

    public String currencyCode() {
        return this.currencyCode;
    }

    public Integer dbInstanceCount() {
        return this.dbInstanceCount;
    }

    public String productDescription() {
        return this.productDescription;
    }

    public String offeringType() {
        return this.offeringType;
    }

    public Boolean multiAZ() {
        return this.multiAZ;
    }

    public String state() {
        return this.state;
    }

    public List<RecurringCharge> recurringCharges() {
        return this.recurringCharges;
    }

    public String reservedDBInstanceArn() {
        return this.reservedDBInstanceArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.reservedDBInstanceId() == null ? 0 : this.reservedDBInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.reservedDBInstancesOfferingId() == null ? 0 : this.reservedDBInstancesOfferingId().hashCode());
        hashCode = 31 * hashCode + (this.dbInstanceClass() == null ? 0 : this.dbInstanceClass().hashCode());
        hashCode = 31 * hashCode + (this.startTime() == null ? 0 : this.startTime().hashCode());
        hashCode = 31 * hashCode + (this.duration() == null ? 0 : this.duration().hashCode());
        hashCode = 31 * hashCode + (this.fixedPrice() == null ? 0 : this.fixedPrice().hashCode());
        hashCode = 31 * hashCode + (this.usagePrice() == null ? 0 : this.usagePrice().hashCode());
        hashCode = 31 * hashCode + (this.currencyCode() == null ? 0 : this.currencyCode().hashCode());
        hashCode = 31 * hashCode + (this.dbInstanceCount() == null ? 0 : this.dbInstanceCount().hashCode());
        hashCode = 31 * hashCode + (this.productDescription() == null ? 0 : this.productDescription().hashCode());
        hashCode = 31 * hashCode + (this.offeringType() == null ? 0 : this.offeringType().hashCode());
        hashCode = 31 * hashCode + (this.multiAZ() == null ? 0 : this.multiAZ().hashCode());
        hashCode = 31 * hashCode + (this.state() == null ? 0 : this.state().hashCode());
        hashCode = 31 * hashCode + (this.recurringCharges() == null ? 0 : this.recurringCharges().hashCode());
        hashCode = 31 * hashCode + (this.reservedDBInstanceArn() == null ? 0 : this.reservedDBInstanceArn().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedDBInstance)) {
            return false;
        }
        ReservedDBInstance other = (ReservedDBInstance)obj;
        if (other.reservedDBInstanceId() == null ^ this.reservedDBInstanceId() == null) {
            return false;
        }
        if (other.reservedDBInstanceId() != null && !other.reservedDBInstanceId().equals(this.reservedDBInstanceId())) {
            return false;
        }
        if (other.reservedDBInstancesOfferingId() == null ^ this.reservedDBInstancesOfferingId() == null) {
            return false;
        }
        if (other.reservedDBInstancesOfferingId() != null && !other.reservedDBInstancesOfferingId().equals(this.reservedDBInstancesOfferingId())) {
            return false;
        }
        if (other.dbInstanceClass() == null ^ this.dbInstanceClass() == null) {
            return false;
        }
        if (other.dbInstanceClass() != null && !other.dbInstanceClass().equals(this.dbInstanceClass())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.duration() == null ^ this.duration() == null) {
            return false;
        }
        if (other.duration() != null && !other.duration().equals(this.duration())) {
            return false;
        }
        if (other.fixedPrice() == null ^ this.fixedPrice() == null) {
            return false;
        }
        if (other.fixedPrice() != null && !other.fixedPrice().equals(this.fixedPrice())) {
            return false;
        }
        if (other.usagePrice() == null ^ this.usagePrice() == null) {
            return false;
        }
        if (other.usagePrice() != null && !other.usagePrice().equals(this.usagePrice())) {
            return false;
        }
        if (other.currencyCode() == null ^ this.currencyCode() == null) {
            return false;
        }
        if (other.currencyCode() != null && !other.currencyCode().equals(this.currencyCode())) {
            return false;
        }
        if (other.dbInstanceCount() == null ^ this.dbInstanceCount() == null) {
            return false;
        }
        if (other.dbInstanceCount() != null && !other.dbInstanceCount().equals(this.dbInstanceCount())) {
            return false;
        }
        if (other.productDescription() == null ^ this.productDescription() == null) {
            return false;
        }
        if (other.productDescription() != null && !other.productDescription().equals(this.productDescription())) {
            return false;
        }
        if (other.offeringType() == null ^ this.offeringType() == null) {
            return false;
        }
        if (other.offeringType() != null && !other.offeringType().equals(this.offeringType())) {
            return false;
        }
        if (other.multiAZ() == null ^ this.multiAZ() == null) {
            return false;
        }
        if (other.multiAZ() != null && !other.multiAZ().equals(this.multiAZ())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.recurringCharges() == null ^ this.recurringCharges() == null) {
            return false;
        }
        if (other.recurringCharges() != null && !other.recurringCharges().equals(this.recurringCharges())) {
            return false;
        }
        if (other.reservedDBInstanceArn() == null ^ this.reservedDBInstanceArn() == null) {
            return false;
        }
        return other.reservedDBInstanceArn() == null || other.reservedDBInstanceArn().equals(this.reservedDBInstanceArn());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.reservedDBInstanceId() != null) {
            sb.append("ReservedDBInstanceId: ").append(this.reservedDBInstanceId()).append(",");
        }
        if (this.reservedDBInstancesOfferingId() != null) {
            sb.append("ReservedDBInstancesOfferingId: ").append(this.reservedDBInstancesOfferingId()).append(",");
        }
        if (this.dbInstanceClass() != null) {
            sb.append("DBInstanceClass: ").append(this.dbInstanceClass()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.duration() != null) {
            sb.append("Duration: ").append(this.duration()).append(",");
        }
        if (this.fixedPrice() != null) {
            sb.append("FixedPrice: ").append(this.fixedPrice()).append(",");
        }
        if (this.usagePrice() != null) {
            sb.append("UsagePrice: ").append(this.usagePrice()).append(",");
        }
        if (this.currencyCode() != null) {
            sb.append("CurrencyCode: ").append(this.currencyCode()).append(",");
        }
        if (this.dbInstanceCount() != null) {
            sb.append("DBInstanceCount: ").append(this.dbInstanceCount()).append(",");
        }
        if (this.productDescription() != null) {
            sb.append("ProductDescription: ").append(this.productDescription()).append(",");
        }
        if (this.offeringType() != null) {
            sb.append("OfferingType: ").append(this.offeringType()).append(",");
        }
        if (this.multiAZ() != null) {
            sb.append("MultiAZ: ").append(this.multiAZ()).append(",");
        }
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        if (this.recurringCharges() != null) {
            sb.append("RecurringCharges: ").append(this.recurringCharges()).append(",");
        }
        if (this.reservedDBInstanceArn() != null) {
            sb.append("ReservedDBInstanceArn: ").append(this.reservedDBInstanceArn()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservedDBInstanceId": {
                return Optional.of(clazz.cast(this.reservedDBInstanceId()));
            }
            case "ReservedDBInstancesOfferingId": {
                return Optional.of(clazz.cast(this.reservedDBInstancesOfferingId()));
            }
            case "DBInstanceClass": {
                return Optional.of(clazz.cast(this.dbInstanceClass()));
            }
            case "StartTime": {
                return Optional.of(clazz.cast(this.startTime()));
            }
            case "Duration": {
                return Optional.of(clazz.cast(this.duration()));
            }
            case "FixedPrice": {
                return Optional.of(clazz.cast(this.fixedPrice()));
            }
            case "UsagePrice": {
                return Optional.of(clazz.cast(this.usagePrice()));
            }
            case "CurrencyCode": {
                return Optional.of(clazz.cast(this.currencyCode()));
            }
            case "DBInstanceCount": {
                return Optional.of(clazz.cast(this.dbInstanceCount()));
            }
            case "ProductDescription": {
                return Optional.of(clazz.cast(this.productDescription()));
            }
            case "OfferingType": {
                return Optional.of(clazz.cast(this.offeringType()));
            }
            case "MultiAZ": {
                return Optional.of(clazz.cast(this.multiAZ()));
            }
            case "State": {
                return Optional.of(clazz.cast(this.state()));
            }
            case "RecurringCharges": {
                return Optional.of(clazz.cast(this.recurringCharges()));
            }
            case "ReservedDBInstanceArn": {
                return Optional.of(clazz.cast(this.reservedDBInstanceArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String reservedDBInstanceId;
        private String reservedDBInstancesOfferingId;
        private String dbInstanceClass;
        private Instant startTime;
        private Integer duration;
        private Double fixedPrice;
        private Double usagePrice;
        private String currencyCode;
        private Integer dbInstanceCount;
        private String productDescription;
        private String offeringType;
        private Boolean multiAZ;
        private String state;
        private List<RecurringCharge> recurringCharges;
        private String reservedDBInstanceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedDBInstance model) {
            this.reservedDBInstanceId(model.reservedDBInstanceId);
            this.reservedDBInstancesOfferingId(model.reservedDBInstancesOfferingId);
            this.dbInstanceClass(model.dbInstanceClass);
            this.startTime(model.startTime);
            this.duration(model.duration);
            this.fixedPrice(model.fixedPrice);
            this.usagePrice(model.usagePrice);
            this.currencyCode(model.currencyCode);
            this.dbInstanceCount(model.dbInstanceCount);
            this.productDescription(model.productDescription);
            this.offeringType(model.offeringType);
            this.multiAZ(model.multiAZ);
            this.state(model.state);
            this.recurringCharges(model.recurringCharges);
            this.reservedDBInstanceArn(model.reservedDBInstanceArn);
        }

        public final String getReservedDBInstanceId() {
            return this.reservedDBInstanceId;
        }

        @Override
        public final Builder reservedDBInstanceId(String reservedDBInstanceId) {
            this.reservedDBInstanceId = reservedDBInstanceId;
            return this;
        }

        public final void setReservedDBInstanceId(String reservedDBInstanceId) {
            this.reservedDBInstanceId = reservedDBInstanceId;
        }

        public final String getReservedDBInstancesOfferingId() {
            return this.reservedDBInstancesOfferingId;
        }

        @Override
        public final Builder reservedDBInstancesOfferingId(String reservedDBInstancesOfferingId) {
            this.reservedDBInstancesOfferingId = reservedDBInstancesOfferingId;
            return this;
        }

        public final void setReservedDBInstancesOfferingId(String reservedDBInstancesOfferingId) {
            this.reservedDBInstancesOfferingId = reservedDBInstancesOfferingId;
        }

        public final String getDBInstanceClass() {
            return this.dbInstanceClass;
        }

        @Override
        public final Builder dbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        public final void setDBInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Integer getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final Double getFixedPrice() {
            return this.fixedPrice;
        }

        @Override
        public final Builder fixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
            return this;
        }

        public final void setFixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
        }

        public final Double getUsagePrice() {
            return this.usagePrice;
        }

        @Override
        public final Builder usagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
            return this;
        }

        public final void setUsagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final Integer getDBInstanceCount() {
            return this.dbInstanceCount;
        }

        @Override
        public final Builder dbInstanceCount(Integer dbInstanceCount) {
            this.dbInstanceCount = dbInstanceCount;
            return this;
        }

        public final void setDBInstanceCount(Integer dbInstanceCount) {
            this.dbInstanceCount = dbInstanceCount;
        }

        public final String getProductDescription() {
            return this.productDescription;
        }

        @Override
        public final Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        public final void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        public final String getOfferingType() {
            return this.offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        public final Boolean getMultiAZ() {
            return this.multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Collection<RecurringCharge.Builder> getRecurringCharges() {
            return this.recurringCharges != null ? (Collection)this.recurringCharges.stream().map(RecurringCharge::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargeListCopier.copy(recurringCharges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(RecurringCharge ... recurringCharges) {
            this.recurringCharges(Arrays.asList(recurringCharges));
            return this;
        }

        public final void setRecurringCharges(Collection<RecurringCharge.BuilderImpl> recurringCharges) {
            this.recurringCharges = RecurringChargeListCopier.copyFromBuilder(recurringCharges);
        }

        public final String getReservedDBInstanceArn() {
            return this.reservedDBInstanceArn;
        }

        @Override
        public final Builder reservedDBInstanceArn(String reservedDBInstanceArn) {
            this.reservedDBInstanceArn = reservedDBInstanceArn;
            return this;
        }

        public final void setReservedDBInstanceArn(String reservedDBInstanceArn) {
            this.reservedDBInstanceArn = reservedDBInstanceArn;
        }

        public ReservedDBInstance build() {
            return new ReservedDBInstance(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReservedDBInstance> {
        public Builder reservedDBInstanceId(String var1);

        public Builder reservedDBInstancesOfferingId(String var1);

        public Builder dbInstanceClass(String var1);

        public Builder startTime(Instant var1);

        public Builder duration(Integer var1);

        public Builder fixedPrice(Double var1);

        public Builder usagePrice(Double var1);

        public Builder currencyCode(String var1);

        public Builder dbInstanceCount(Integer var1);

        public Builder productDescription(String var1);

        public Builder offeringType(String var1);

        public Builder multiAZ(Boolean var1);

        public Builder state(String var1);

        public Builder recurringCharges(Collection<RecurringCharge> var1);

        public Builder recurringCharges(RecurringCharge ... var1);

        public Builder reservedDBInstanceArn(String var1);
    }
}

