/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyDBSnapshotRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ModifyDBSnapshotRequest> {
    private final String dbSnapshotIdentifier;
    private final String engineVersion;

    private ModifyDBSnapshotRequest(BuilderImpl builder) {
        this.dbSnapshotIdentifier = builder.dbSnapshotIdentifier;
        this.engineVersion = builder.engineVersion;
    }

    public String dbSnapshotIdentifier() {
        return this.dbSnapshotIdentifier;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dbSnapshotIdentifier() == null ? 0 : this.dbSnapshotIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.engineVersion() == null ? 0 : this.engineVersion().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDBSnapshotRequest)) {
            return false;
        }
        ModifyDBSnapshotRequest other = (ModifyDBSnapshotRequest)((Object)obj);
        if (other.dbSnapshotIdentifier() == null ^ this.dbSnapshotIdentifier() == null) {
            return false;
        }
        if (other.dbSnapshotIdentifier() != null && !other.dbSnapshotIdentifier().equals(this.dbSnapshotIdentifier())) {
            return false;
        }
        if (other.engineVersion() == null ^ this.engineVersion() == null) {
            return false;
        }
        return other.engineVersion() == null || other.engineVersion().equals(this.engineVersion());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.dbSnapshotIdentifier() != null) {
            sb.append("DBSnapshotIdentifier: ").append(this.dbSnapshotIdentifier()).append(",");
        }
        if (this.engineVersion() != null) {
            sb.append("EngineVersion: ").append(this.engineVersion()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBSnapshotIdentifier": {
                return Optional.of(clazz.cast(this.dbSnapshotIdentifier()));
            }
            case "EngineVersion": {
                return Optional.of(clazz.cast(this.engineVersion()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String dbSnapshotIdentifier;
        private String engineVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDBSnapshotRequest model) {
            this.dbSnapshotIdentifier(model.dbSnapshotIdentifier);
            this.engineVersion(model.engineVersion);
        }

        public final String getDBSnapshotIdentifier() {
            return this.dbSnapshotIdentifier;
        }

        @Override
        public final Builder dbSnapshotIdentifier(String dbSnapshotIdentifier) {
            this.dbSnapshotIdentifier = dbSnapshotIdentifier;
            return this;
        }

        public final void setDBSnapshotIdentifier(String dbSnapshotIdentifier) {
            this.dbSnapshotIdentifier = dbSnapshotIdentifier;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public ModifyDBSnapshotRequest build() {
            return new ModifyDBSnapshotRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ModifyDBSnapshotRequest> {
        public Builder dbSnapshotIdentifier(String var1);

        public Builder engineVersion(String var1);
    }
}

