/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.rds.model.Parameter;
import software.amazon.awssdk.services.rds.model.ParametersListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EngineDefaults
implements ToCopyableBuilder<Builder, EngineDefaults> {
    private final String dbParameterGroupFamily;
    private final String marker;
    private final List<Parameter> parameters;

    private EngineDefaults(BuilderImpl builder) {
        this.dbParameterGroupFamily = builder.dbParameterGroupFamily;
        this.marker = builder.marker;
        this.parameters = builder.parameters;
    }

    public String dbParameterGroupFamily() {
        return this.dbParameterGroupFamily;
    }

    public String marker() {
        return this.marker;
    }

    public List<Parameter> parameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dbParameterGroupFamily() == null ? 0 : this.dbParameterGroupFamily().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.parameters() == null ? 0 : this.parameters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EngineDefaults)) {
            return false;
        }
        EngineDefaults other = (EngineDefaults)obj;
        if (other.dbParameterGroupFamily() == null ^ this.dbParameterGroupFamily() == null) {
            return false;
        }
        if (other.dbParameterGroupFamily() != null && !other.dbParameterGroupFamily().equals(this.dbParameterGroupFamily())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        return other.parameters() == null || other.parameters().equals(this.parameters());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.dbParameterGroupFamily() != null) {
            sb.append("DBParameterGroupFamily: ").append(this.dbParameterGroupFamily()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.parameters() != null) {
            sb.append("Parameters: ").append(this.parameters()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBParameterGroupFamily": {
                return Optional.of(clazz.cast(this.dbParameterGroupFamily()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "Parameters": {
                return Optional.of(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String dbParameterGroupFamily;
        private String marker;
        private List<Parameter> parameters;

        private BuilderImpl() {
        }

        private BuilderImpl(EngineDefaults model) {
            this.dbParameterGroupFamily(model.dbParameterGroupFamily);
            this.marker(model.marker);
            this.parameters(model.parameters);
        }

        public final String getDBParameterGroupFamily() {
            return this.dbParameterGroupFamily;
        }

        @Override
        public final Builder dbParameterGroupFamily(String dbParameterGroupFamily) {
            this.dbParameterGroupFamily = dbParameterGroupFamily;
            return this;
        }

        public final void setDBParameterGroupFamily(String dbParameterGroupFamily) {
            this.dbParameterGroupFamily = dbParameterGroupFamily;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<Parameter.Builder> getParameters() {
            return this.parameters != null ? (Collection)this.parameters.stream().map(Parameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        public final void setParameters(Collection<Parameter.BuilderImpl> parameters) {
            this.parameters = ParametersListCopier.copyFromBuilder(parameters);
        }

        public EngineDefaults build() {
            return new EngineDefaults(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EngineDefaults> {
        public Builder dbParameterGroupFamily(String var1);

        public Builder marker(String var1);

        public Builder parameters(Collection<Parameter> var1);

        public Builder parameters(Parameter ... var1);
    }
}

