/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DomainMembership
implements ToCopyableBuilder<Builder, DomainMembership> {
    private final String domain;
    private final String status;
    private final String fqdn;
    private final String iamRoleName;

    private DomainMembership(BuilderImpl builder) {
        this.domain = builder.domain;
        this.status = builder.status;
        this.fqdn = builder.fqdn;
        this.iamRoleName = builder.iamRoleName;
    }

    public String domain() {
        return this.domain;
    }

    public String status() {
        return this.status;
    }

    public String fqdn() {
        return this.fqdn;
    }

    public String iamRoleName() {
        return this.iamRoleName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.domain() == null ? 0 : this.domain().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.fqdn() == null ? 0 : this.fqdn().hashCode());
        hashCode = 31 * hashCode + (this.iamRoleName() == null ? 0 : this.iamRoleName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainMembership)) {
            return false;
        }
        DomainMembership other = (DomainMembership)obj;
        if (other.domain() == null ^ this.domain() == null) {
            return false;
        }
        if (other.domain() != null && !other.domain().equals(this.domain())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.fqdn() == null ^ this.fqdn() == null) {
            return false;
        }
        if (other.fqdn() != null && !other.fqdn().equals(this.fqdn())) {
            return false;
        }
        if (other.iamRoleName() == null ^ this.iamRoleName() == null) {
            return false;
        }
        return other.iamRoleName() == null || other.iamRoleName().equals(this.iamRoleName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.domain() != null) {
            sb.append("Domain: ").append(this.domain()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.fqdn() != null) {
            sb.append("FQDN: ").append(this.fqdn()).append(",");
        }
        if (this.iamRoleName() != null) {
            sb.append("IAMRoleName: ").append(this.iamRoleName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Domain": {
                return Optional.of(clazz.cast(this.domain()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "FQDN": {
                return Optional.of(clazz.cast(this.fqdn()));
            }
            case "IAMRoleName": {
                return Optional.of(clazz.cast(this.iamRoleName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String domain;
        private String status;
        private String fqdn;
        private String iamRoleName;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainMembership model) {
            this.domain(model.domain);
            this.status(model.status);
            this.fqdn(model.fqdn);
            this.iamRoleName(model.iamRoleName);
        }

        public final String getDomain() {
            return this.domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getFQDN() {
            return this.fqdn;
        }

        @Override
        public final Builder fqdn(String fqdn) {
            this.fqdn = fqdn;
            return this;
        }

        public final void setFQDN(String fqdn) {
            this.fqdn = fqdn;
        }

        public final String getIAMRoleName() {
            return this.iamRoleName;
        }

        @Override
        public final Builder iamRoleName(String iamRoleName) {
            this.iamRoleName = iamRoleName;
            return this;
        }

        public final void setIAMRoleName(String iamRoleName) {
            this.iamRoleName = iamRoleName;
        }

        public DomainMembership build() {
            return new DomainMembership(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DomainMembership> {
        public Builder domain(String var1);

        public Builder status(String var1);

        public Builder fqdn(String var1);

        public Builder iamRoleName(String var1);
    }
}

