/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.rds.model.Filter;
import software.amazon.awssdk.services.rds.model.FilterListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeSourceRegionsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeSourceRegionsRequest> {
    private final String regionName;
    private final Integer maxRecords;
    private final String marker;
    private final List<Filter> filters;

    private DescribeSourceRegionsRequest(BuilderImpl builder) {
        this.regionName = builder.regionName;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
        this.filters = builder.filters;
    }

    public String regionName() {
        return this.regionName;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public String marker() {
        return this.marker;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.regionName() == null ? 0 : this.regionName().hashCode());
        hashCode = 31 * hashCode + (this.maxRecords() == null ? 0 : this.maxRecords().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.filters() == null ? 0 : this.filters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSourceRegionsRequest)) {
            return false;
        }
        DescribeSourceRegionsRequest other = (DescribeSourceRegionsRequest)((Object)obj);
        if (other.regionName() == null ^ this.regionName() == null) {
            return false;
        }
        if (other.regionName() != null && !other.regionName().equals(this.regionName())) {
            return false;
        }
        if (other.maxRecords() == null ^ this.maxRecords() == null) {
            return false;
        }
        if (other.maxRecords() != null && !other.maxRecords().equals(this.maxRecords())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        return other.filters() == null || other.filters().equals(this.filters());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.regionName() != null) {
            sb.append("RegionName: ").append(this.regionName()).append(",");
        }
        if (this.maxRecords() != null) {
            sb.append("MaxRecords: ").append(this.maxRecords()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegionName": {
                return Optional.of(clazz.cast(this.regionName()));
            }
            case "MaxRecords": {
                return Optional.of(clazz.cast(this.maxRecords()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "Filters": {
                return Optional.of(clazz.cast(this.filters()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String regionName;
        private Integer maxRecords;
        private String marker;
        private List<Filter> filters;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSourceRegionsRequest model) {
            this.regionName(model.regionName);
            this.maxRecords(model.maxRecords);
            this.marker(model.marker);
            this.filters(model.filters);
        }

        public final String getRegionName() {
            return this.regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<Filter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public DescribeSourceRegionsRequest build() {
            return new DescribeSourceRegionsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeSourceRegionsRequest> {
        public Builder regionName(String var1);

        public Builder maxRecords(Integer var1);

        public Builder marker(String var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);
    }
}

