/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteDBInstanceRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteDBInstanceRequest> {
    private final String dbInstanceIdentifier;
    private final Boolean skipFinalSnapshot;
    private final String finalDBSnapshotIdentifier;

    private DeleteDBInstanceRequest(BuilderImpl builder) {
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.skipFinalSnapshot = builder.skipFinalSnapshot;
        this.finalDBSnapshotIdentifier = builder.finalDBSnapshotIdentifier;
    }

    public String dbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public Boolean skipFinalSnapshot() {
        return this.skipFinalSnapshot;
    }

    public String finalDBSnapshotIdentifier() {
        return this.finalDBSnapshotIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dbInstanceIdentifier() == null ? 0 : this.dbInstanceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.skipFinalSnapshot() == null ? 0 : this.skipFinalSnapshot().hashCode());
        hashCode = 31 * hashCode + (this.finalDBSnapshotIdentifier() == null ? 0 : this.finalDBSnapshotIdentifier().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDBInstanceRequest)) {
            return false;
        }
        DeleteDBInstanceRequest other = (DeleteDBInstanceRequest)((Object)obj);
        if (other.dbInstanceIdentifier() == null ^ this.dbInstanceIdentifier() == null) {
            return false;
        }
        if (other.dbInstanceIdentifier() != null && !other.dbInstanceIdentifier().equals(this.dbInstanceIdentifier())) {
            return false;
        }
        if (other.skipFinalSnapshot() == null ^ this.skipFinalSnapshot() == null) {
            return false;
        }
        if (other.skipFinalSnapshot() != null && !other.skipFinalSnapshot().equals(this.skipFinalSnapshot())) {
            return false;
        }
        if (other.finalDBSnapshotIdentifier() == null ^ this.finalDBSnapshotIdentifier() == null) {
            return false;
        }
        return other.finalDBSnapshotIdentifier() == null || other.finalDBSnapshotIdentifier().equals(this.finalDBSnapshotIdentifier());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.dbInstanceIdentifier() != null) {
            sb.append("DBInstanceIdentifier: ").append(this.dbInstanceIdentifier()).append(",");
        }
        if (this.skipFinalSnapshot() != null) {
            sb.append("SkipFinalSnapshot: ").append(this.skipFinalSnapshot()).append(",");
        }
        if (this.finalDBSnapshotIdentifier() != null) {
            sb.append("FinalDBSnapshotIdentifier: ").append(this.finalDBSnapshotIdentifier()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBInstanceIdentifier": {
                return Optional.of(clazz.cast(this.dbInstanceIdentifier()));
            }
            case "SkipFinalSnapshot": {
                return Optional.of(clazz.cast(this.skipFinalSnapshot()));
            }
            case "FinalDBSnapshotIdentifier": {
                return Optional.of(clazz.cast(this.finalDBSnapshotIdentifier()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String dbInstanceIdentifier;
        private Boolean skipFinalSnapshot;
        private String finalDBSnapshotIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDBInstanceRequest model) {
            this.dbInstanceIdentifier(model.dbInstanceIdentifier);
            this.skipFinalSnapshot(model.skipFinalSnapshot);
            this.finalDBSnapshotIdentifier(model.finalDBSnapshotIdentifier);
        }

        public final String getDBInstanceIdentifier() {
            return this.dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final void setDBInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        public final Boolean getSkipFinalSnapshot() {
            return this.skipFinalSnapshot;
        }

        @Override
        public final Builder skipFinalSnapshot(Boolean skipFinalSnapshot) {
            this.skipFinalSnapshot = skipFinalSnapshot;
            return this;
        }

        public final void setSkipFinalSnapshot(Boolean skipFinalSnapshot) {
            this.skipFinalSnapshot = skipFinalSnapshot;
        }

        public final String getFinalDBSnapshotIdentifier() {
            return this.finalDBSnapshotIdentifier;
        }

        @Override
        public final Builder finalDBSnapshotIdentifier(String finalDBSnapshotIdentifier) {
            this.finalDBSnapshotIdentifier = finalDBSnapshotIdentifier;
            return this;
        }

        public final void setFinalDBSnapshotIdentifier(String finalDBSnapshotIdentifier) {
            this.finalDBSnapshotIdentifier = finalDBSnapshotIdentifier;
        }

        public DeleteDBInstanceRequest build() {
            return new DeleteDBInstanceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteDBInstanceRequest> {
        public Builder dbInstanceIdentifier(String var1);

        public Builder skipFinalSnapshot(Boolean var1);

        public Builder finalDBSnapshotIdentifier(String var1);
    }
}

