/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteDBClusterRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteDBClusterRequest> {
    private final String dbClusterIdentifier;
    private final Boolean skipFinalSnapshot;
    private final String finalDBSnapshotIdentifier;

    private DeleteDBClusterRequest(BuilderImpl builder) {
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.skipFinalSnapshot = builder.skipFinalSnapshot;
        this.finalDBSnapshotIdentifier = builder.finalDBSnapshotIdentifier;
    }

    public String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public Boolean skipFinalSnapshot() {
        return this.skipFinalSnapshot;
    }

    public String finalDBSnapshotIdentifier() {
        return this.finalDBSnapshotIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dbClusterIdentifier() == null ? 0 : this.dbClusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.skipFinalSnapshot() == null ? 0 : this.skipFinalSnapshot().hashCode());
        hashCode = 31 * hashCode + (this.finalDBSnapshotIdentifier() == null ? 0 : this.finalDBSnapshotIdentifier().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDBClusterRequest)) {
            return false;
        }
        DeleteDBClusterRequest other = (DeleteDBClusterRequest)((Object)obj);
        if (other.dbClusterIdentifier() == null ^ this.dbClusterIdentifier() == null) {
            return false;
        }
        if (other.dbClusterIdentifier() != null && !other.dbClusterIdentifier().equals(this.dbClusterIdentifier())) {
            return false;
        }
        if (other.skipFinalSnapshot() == null ^ this.skipFinalSnapshot() == null) {
            return false;
        }
        if (other.skipFinalSnapshot() != null && !other.skipFinalSnapshot().equals(this.skipFinalSnapshot())) {
            return false;
        }
        if (other.finalDBSnapshotIdentifier() == null ^ this.finalDBSnapshotIdentifier() == null) {
            return false;
        }
        return other.finalDBSnapshotIdentifier() == null || other.finalDBSnapshotIdentifier().equals(this.finalDBSnapshotIdentifier());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.dbClusterIdentifier() != null) {
            sb.append("DBClusterIdentifier: ").append(this.dbClusterIdentifier()).append(",");
        }
        if (this.skipFinalSnapshot() != null) {
            sb.append("SkipFinalSnapshot: ").append(this.skipFinalSnapshot()).append(",");
        }
        if (this.finalDBSnapshotIdentifier() != null) {
            sb.append("FinalDBSnapshotIdentifier: ").append(this.finalDBSnapshotIdentifier()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBClusterIdentifier": {
                return Optional.of(clazz.cast(this.dbClusterIdentifier()));
            }
            case "SkipFinalSnapshot": {
                return Optional.of(clazz.cast(this.skipFinalSnapshot()));
            }
            case "FinalDBSnapshotIdentifier": {
                return Optional.of(clazz.cast(this.finalDBSnapshotIdentifier()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String dbClusterIdentifier;
        private Boolean skipFinalSnapshot;
        private String finalDBSnapshotIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDBClusterRequest model) {
            this.dbClusterIdentifier(model.dbClusterIdentifier);
            this.skipFinalSnapshot(model.skipFinalSnapshot);
            this.finalDBSnapshotIdentifier(model.finalDBSnapshotIdentifier);
        }

        public final String getDBClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final void setDBClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        public final Boolean getSkipFinalSnapshot() {
            return this.skipFinalSnapshot;
        }

        @Override
        public final Builder skipFinalSnapshot(Boolean skipFinalSnapshot) {
            this.skipFinalSnapshot = skipFinalSnapshot;
            return this;
        }

        public final void setSkipFinalSnapshot(Boolean skipFinalSnapshot) {
            this.skipFinalSnapshot = skipFinalSnapshot;
        }

        public final String getFinalDBSnapshotIdentifier() {
            return this.finalDBSnapshotIdentifier;
        }

        @Override
        public final Builder finalDBSnapshotIdentifier(String finalDBSnapshotIdentifier) {
            this.finalDBSnapshotIdentifier = finalDBSnapshotIdentifier;
            return this;
        }

        public final void setFinalDBSnapshotIdentifier(String finalDBSnapshotIdentifier) {
            this.finalDBSnapshotIdentifier = finalDBSnapshotIdentifier;
        }

        public DeleteDBClusterRequest build() {
            return new DeleteDBClusterRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteDBClusterRequest> {
        public Builder dbClusterIdentifier(String var1);

        public Builder skipFinalSnapshot(Boolean var1);

        public Builder finalDBSnapshotIdentifier(String var1);
    }
}

