/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DBSnapshot
implements ToCopyableBuilder<Builder, DBSnapshot> {
    private final String dbSnapshotIdentifier;
    private final String dbInstanceIdentifier;
    private final Instant snapshotCreateTime;
    private final String engine;
    private final Integer allocatedStorage;
    private final String status;
    private final Integer port;
    private final String availabilityZone;
    private final String vpcId;
    private final Instant instanceCreateTime;
    private final String masterUsername;
    private final String engineVersion;
    private final String licenseModel;
    private final String snapshotType;
    private final Integer iops;
    private final String optionGroupName;
    private final Integer percentProgress;
    private final String sourceRegion;
    private final String sourceDBSnapshotIdentifier;
    private final String storageType;
    private final String tdeCredentialArn;
    private final Boolean encrypted;
    private final String kmsKeyId;
    private final String dbSnapshotArn;
    private final String timezone;
    private final Boolean iamDatabaseAuthenticationEnabled;

    private DBSnapshot(BuilderImpl builder) {
        this.dbSnapshotIdentifier = builder.dbSnapshotIdentifier;
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.snapshotCreateTime = builder.snapshotCreateTime;
        this.engine = builder.engine;
        this.allocatedStorage = builder.allocatedStorage;
        this.status = builder.status;
        this.port = builder.port;
        this.availabilityZone = builder.availabilityZone;
        this.vpcId = builder.vpcId;
        this.instanceCreateTime = builder.instanceCreateTime;
        this.masterUsername = builder.masterUsername;
        this.engineVersion = builder.engineVersion;
        this.licenseModel = builder.licenseModel;
        this.snapshotType = builder.snapshotType;
        this.iops = builder.iops;
        this.optionGroupName = builder.optionGroupName;
        this.percentProgress = builder.percentProgress;
        this.sourceRegion = builder.sourceRegion;
        this.sourceDBSnapshotIdentifier = builder.sourceDBSnapshotIdentifier;
        this.storageType = builder.storageType;
        this.tdeCredentialArn = builder.tdeCredentialArn;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.dbSnapshotArn = builder.dbSnapshotArn;
        this.timezone = builder.timezone;
        this.iamDatabaseAuthenticationEnabled = builder.iamDatabaseAuthenticationEnabled;
    }

    public String dbSnapshotIdentifier() {
        return this.dbSnapshotIdentifier;
    }

    public String dbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public Instant snapshotCreateTime() {
        return this.snapshotCreateTime;
    }

    public String engine() {
        return this.engine;
    }

    public Integer allocatedStorage() {
        return this.allocatedStorage;
    }

    public String status() {
        return this.status;
    }

    public Integer port() {
        return this.port;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public Instant instanceCreateTime() {
        return this.instanceCreateTime;
    }

    public String masterUsername() {
        return this.masterUsername;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public String licenseModel() {
        return this.licenseModel;
    }

    public String snapshotType() {
        return this.snapshotType;
    }

    public Integer iops() {
        return this.iops;
    }

    public String optionGroupName() {
        return this.optionGroupName;
    }

    public Integer percentProgress() {
        return this.percentProgress;
    }

    public String sourceRegion() {
        return this.sourceRegion;
    }

    public String sourceDBSnapshotIdentifier() {
        return this.sourceDBSnapshotIdentifier;
    }

    public String storageType() {
        return this.storageType;
    }

    public String tdeCredentialArn() {
        return this.tdeCredentialArn;
    }

    public Boolean encrypted() {
        return this.encrypted;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public String dbSnapshotArn() {
        return this.dbSnapshotArn;
    }

    public String timezone() {
        return this.timezone;
    }

    public Boolean iamDatabaseAuthenticationEnabled() {
        return this.iamDatabaseAuthenticationEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dbSnapshotIdentifier() == null ? 0 : this.dbSnapshotIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.dbInstanceIdentifier() == null ? 0 : this.dbInstanceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.snapshotCreateTime() == null ? 0 : this.snapshotCreateTime().hashCode());
        hashCode = 31 * hashCode + (this.engine() == null ? 0 : this.engine().hashCode());
        hashCode = 31 * hashCode + (this.allocatedStorage() == null ? 0 : this.allocatedStorage().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.port() == null ? 0 : this.port().hashCode());
        hashCode = 31 * hashCode + (this.availabilityZone() == null ? 0 : this.availabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.vpcId() == null ? 0 : this.vpcId().hashCode());
        hashCode = 31 * hashCode + (this.instanceCreateTime() == null ? 0 : this.instanceCreateTime().hashCode());
        hashCode = 31 * hashCode + (this.masterUsername() == null ? 0 : this.masterUsername().hashCode());
        hashCode = 31 * hashCode + (this.engineVersion() == null ? 0 : this.engineVersion().hashCode());
        hashCode = 31 * hashCode + (this.licenseModel() == null ? 0 : this.licenseModel().hashCode());
        hashCode = 31 * hashCode + (this.snapshotType() == null ? 0 : this.snapshotType().hashCode());
        hashCode = 31 * hashCode + (this.iops() == null ? 0 : this.iops().hashCode());
        hashCode = 31 * hashCode + (this.optionGroupName() == null ? 0 : this.optionGroupName().hashCode());
        hashCode = 31 * hashCode + (this.percentProgress() == null ? 0 : this.percentProgress().hashCode());
        hashCode = 31 * hashCode + (this.sourceRegion() == null ? 0 : this.sourceRegion().hashCode());
        hashCode = 31 * hashCode + (this.sourceDBSnapshotIdentifier() == null ? 0 : this.sourceDBSnapshotIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.storageType() == null ? 0 : this.storageType().hashCode());
        hashCode = 31 * hashCode + (this.tdeCredentialArn() == null ? 0 : this.tdeCredentialArn().hashCode());
        hashCode = 31 * hashCode + (this.encrypted() == null ? 0 : this.encrypted().hashCode());
        hashCode = 31 * hashCode + (this.kmsKeyId() == null ? 0 : this.kmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.dbSnapshotArn() == null ? 0 : this.dbSnapshotArn().hashCode());
        hashCode = 31 * hashCode + (this.timezone() == null ? 0 : this.timezone().hashCode());
        hashCode = 31 * hashCode + (this.iamDatabaseAuthenticationEnabled() == null ? 0 : this.iamDatabaseAuthenticationEnabled().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBSnapshot)) {
            return false;
        }
        DBSnapshot other = (DBSnapshot)obj;
        if (other.dbSnapshotIdentifier() == null ^ this.dbSnapshotIdentifier() == null) {
            return false;
        }
        if (other.dbSnapshotIdentifier() != null && !other.dbSnapshotIdentifier().equals(this.dbSnapshotIdentifier())) {
            return false;
        }
        if (other.dbInstanceIdentifier() == null ^ this.dbInstanceIdentifier() == null) {
            return false;
        }
        if (other.dbInstanceIdentifier() != null && !other.dbInstanceIdentifier().equals(this.dbInstanceIdentifier())) {
            return false;
        }
        if (other.snapshotCreateTime() == null ^ this.snapshotCreateTime() == null) {
            return false;
        }
        if (other.snapshotCreateTime() != null && !other.snapshotCreateTime().equals(this.snapshotCreateTime())) {
            return false;
        }
        if (other.engine() == null ^ this.engine() == null) {
            return false;
        }
        if (other.engine() != null && !other.engine().equals(this.engine())) {
            return false;
        }
        if (other.allocatedStorage() == null ^ this.allocatedStorage() == null) {
            return false;
        }
        if (other.allocatedStorage() != null && !other.allocatedStorage().equals(this.allocatedStorage())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.port() == null ^ this.port() == null) {
            return false;
        }
        if (other.port() != null && !other.port().equals(this.port())) {
            return false;
        }
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        if (other.vpcId() != null && !other.vpcId().equals(this.vpcId())) {
            return false;
        }
        if (other.instanceCreateTime() == null ^ this.instanceCreateTime() == null) {
            return false;
        }
        if (other.instanceCreateTime() != null && !other.instanceCreateTime().equals(this.instanceCreateTime())) {
            return false;
        }
        if (other.masterUsername() == null ^ this.masterUsername() == null) {
            return false;
        }
        if (other.masterUsername() != null && !other.masterUsername().equals(this.masterUsername())) {
            return false;
        }
        if (other.engineVersion() == null ^ this.engineVersion() == null) {
            return false;
        }
        if (other.engineVersion() != null && !other.engineVersion().equals(this.engineVersion())) {
            return false;
        }
        if (other.licenseModel() == null ^ this.licenseModel() == null) {
            return false;
        }
        if (other.licenseModel() != null && !other.licenseModel().equals(this.licenseModel())) {
            return false;
        }
        if (other.snapshotType() == null ^ this.snapshotType() == null) {
            return false;
        }
        if (other.snapshotType() != null && !other.snapshotType().equals(this.snapshotType())) {
            return false;
        }
        if (other.iops() == null ^ this.iops() == null) {
            return false;
        }
        if (other.iops() != null && !other.iops().equals(this.iops())) {
            return false;
        }
        if (other.optionGroupName() == null ^ this.optionGroupName() == null) {
            return false;
        }
        if (other.optionGroupName() != null && !other.optionGroupName().equals(this.optionGroupName())) {
            return false;
        }
        if (other.percentProgress() == null ^ this.percentProgress() == null) {
            return false;
        }
        if (other.percentProgress() != null && !other.percentProgress().equals(this.percentProgress())) {
            return false;
        }
        if (other.sourceRegion() == null ^ this.sourceRegion() == null) {
            return false;
        }
        if (other.sourceRegion() != null && !other.sourceRegion().equals(this.sourceRegion())) {
            return false;
        }
        if (other.sourceDBSnapshotIdentifier() == null ^ this.sourceDBSnapshotIdentifier() == null) {
            return false;
        }
        if (other.sourceDBSnapshotIdentifier() != null && !other.sourceDBSnapshotIdentifier().equals(this.sourceDBSnapshotIdentifier())) {
            return false;
        }
        if (other.storageType() == null ^ this.storageType() == null) {
            return false;
        }
        if (other.storageType() != null && !other.storageType().equals(this.storageType())) {
            return false;
        }
        if (other.tdeCredentialArn() == null ^ this.tdeCredentialArn() == null) {
            return false;
        }
        if (other.tdeCredentialArn() != null && !other.tdeCredentialArn().equals(this.tdeCredentialArn())) {
            return false;
        }
        if (other.encrypted() == null ^ this.encrypted() == null) {
            return false;
        }
        if (other.encrypted() != null && !other.encrypted().equals(this.encrypted())) {
            return false;
        }
        if (other.kmsKeyId() == null ^ this.kmsKeyId() == null) {
            return false;
        }
        if (other.kmsKeyId() != null && !other.kmsKeyId().equals(this.kmsKeyId())) {
            return false;
        }
        if (other.dbSnapshotArn() == null ^ this.dbSnapshotArn() == null) {
            return false;
        }
        if (other.dbSnapshotArn() != null && !other.dbSnapshotArn().equals(this.dbSnapshotArn())) {
            return false;
        }
        if (other.timezone() == null ^ this.timezone() == null) {
            return false;
        }
        if (other.timezone() != null && !other.timezone().equals(this.timezone())) {
            return false;
        }
        if (other.iamDatabaseAuthenticationEnabled() == null ^ this.iamDatabaseAuthenticationEnabled() == null) {
            return false;
        }
        return other.iamDatabaseAuthenticationEnabled() == null || other.iamDatabaseAuthenticationEnabled().equals(this.iamDatabaseAuthenticationEnabled());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.dbSnapshotIdentifier() != null) {
            sb.append("DBSnapshotIdentifier: ").append(this.dbSnapshotIdentifier()).append(",");
        }
        if (this.dbInstanceIdentifier() != null) {
            sb.append("DBInstanceIdentifier: ").append(this.dbInstanceIdentifier()).append(",");
        }
        if (this.snapshotCreateTime() != null) {
            sb.append("SnapshotCreateTime: ").append(this.snapshotCreateTime()).append(",");
        }
        if (this.engine() != null) {
            sb.append("Engine: ").append(this.engine()).append(",");
        }
        if (this.allocatedStorage() != null) {
            sb.append("AllocatedStorage: ").append(this.allocatedStorage()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.port() != null) {
            sb.append("Port: ").append(this.port()).append(",");
        }
        if (this.availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.availabilityZone()).append(",");
        }
        if (this.vpcId() != null) {
            sb.append("VpcId: ").append(this.vpcId()).append(",");
        }
        if (this.instanceCreateTime() != null) {
            sb.append("InstanceCreateTime: ").append(this.instanceCreateTime()).append(",");
        }
        if (this.masterUsername() != null) {
            sb.append("MasterUsername: ").append(this.masterUsername()).append(",");
        }
        if (this.engineVersion() != null) {
            sb.append("EngineVersion: ").append(this.engineVersion()).append(",");
        }
        if (this.licenseModel() != null) {
            sb.append("LicenseModel: ").append(this.licenseModel()).append(",");
        }
        if (this.snapshotType() != null) {
            sb.append("SnapshotType: ").append(this.snapshotType()).append(",");
        }
        if (this.iops() != null) {
            sb.append("Iops: ").append(this.iops()).append(",");
        }
        if (this.optionGroupName() != null) {
            sb.append("OptionGroupName: ").append(this.optionGroupName()).append(",");
        }
        if (this.percentProgress() != null) {
            sb.append("PercentProgress: ").append(this.percentProgress()).append(",");
        }
        if (this.sourceRegion() != null) {
            sb.append("SourceRegion: ").append(this.sourceRegion()).append(",");
        }
        if (this.sourceDBSnapshotIdentifier() != null) {
            sb.append("SourceDBSnapshotIdentifier: ").append(this.sourceDBSnapshotIdentifier()).append(",");
        }
        if (this.storageType() != null) {
            sb.append("StorageType: ").append(this.storageType()).append(",");
        }
        if (this.tdeCredentialArn() != null) {
            sb.append("TdeCredentialArn: ").append(this.tdeCredentialArn()).append(",");
        }
        if (this.encrypted() != null) {
            sb.append("Encrypted: ").append(this.encrypted()).append(",");
        }
        if (this.kmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.kmsKeyId()).append(",");
        }
        if (this.dbSnapshotArn() != null) {
            sb.append("DBSnapshotArn: ").append(this.dbSnapshotArn()).append(",");
        }
        if (this.timezone() != null) {
            sb.append("Timezone: ").append(this.timezone()).append(",");
        }
        if (this.iamDatabaseAuthenticationEnabled() != null) {
            sb.append("IAMDatabaseAuthenticationEnabled: ").append(this.iamDatabaseAuthenticationEnabled()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBSnapshotIdentifier": {
                return Optional.of(clazz.cast(this.dbSnapshotIdentifier()));
            }
            case "DBInstanceIdentifier": {
                return Optional.of(clazz.cast(this.dbInstanceIdentifier()));
            }
            case "SnapshotCreateTime": {
                return Optional.of(clazz.cast(this.snapshotCreateTime()));
            }
            case "Engine": {
                return Optional.of(clazz.cast(this.engine()));
            }
            case "AllocatedStorage": {
                return Optional.of(clazz.cast(this.allocatedStorage()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "Port": {
                return Optional.of(clazz.cast(this.port()));
            }
            case "AvailabilityZone": {
                return Optional.of(clazz.cast(this.availabilityZone()));
            }
            case "VpcId": {
                return Optional.of(clazz.cast(this.vpcId()));
            }
            case "InstanceCreateTime": {
                return Optional.of(clazz.cast(this.instanceCreateTime()));
            }
            case "MasterUsername": {
                return Optional.of(clazz.cast(this.masterUsername()));
            }
            case "EngineVersion": {
                return Optional.of(clazz.cast(this.engineVersion()));
            }
            case "LicenseModel": {
                return Optional.of(clazz.cast(this.licenseModel()));
            }
            case "SnapshotType": {
                return Optional.of(clazz.cast(this.snapshotType()));
            }
            case "Iops": {
                return Optional.of(clazz.cast(this.iops()));
            }
            case "OptionGroupName": {
                return Optional.of(clazz.cast(this.optionGroupName()));
            }
            case "PercentProgress": {
                return Optional.of(clazz.cast(this.percentProgress()));
            }
            case "SourceRegion": {
                return Optional.of(clazz.cast(this.sourceRegion()));
            }
            case "SourceDBSnapshotIdentifier": {
                return Optional.of(clazz.cast(this.sourceDBSnapshotIdentifier()));
            }
            case "StorageType": {
                return Optional.of(clazz.cast(this.storageType()));
            }
            case "TdeCredentialArn": {
                return Optional.of(clazz.cast(this.tdeCredentialArn()));
            }
            case "Encrypted": {
                return Optional.of(clazz.cast(this.encrypted()));
            }
            case "KmsKeyId": {
                return Optional.of(clazz.cast(this.kmsKeyId()));
            }
            case "DBSnapshotArn": {
                return Optional.of(clazz.cast(this.dbSnapshotArn()));
            }
            case "Timezone": {
                return Optional.of(clazz.cast(this.timezone()));
            }
            case "IAMDatabaseAuthenticationEnabled": {
                return Optional.of(clazz.cast(this.iamDatabaseAuthenticationEnabled()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String dbSnapshotIdentifier;
        private String dbInstanceIdentifier;
        private Instant snapshotCreateTime;
        private String engine;
        private Integer allocatedStorage;
        private String status;
        private Integer port;
        private String availabilityZone;
        private String vpcId;
        private Instant instanceCreateTime;
        private String masterUsername;
        private String engineVersion;
        private String licenseModel;
        private String snapshotType;
        private Integer iops;
        private String optionGroupName;
        private Integer percentProgress;
        private String sourceRegion;
        private String sourceDBSnapshotIdentifier;
        private String storageType;
        private String tdeCredentialArn;
        private Boolean encrypted;
        private String kmsKeyId;
        private String dbSnapshotArn;
        private String timezone;
        private Boolean iamDatabaseAuthenticationEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(DBSnapshot model) {
            this.dbSnapshotIdentifier(model.dbSnapshotIdentifier);
            this.dbInstanceIdentifier(model.dbInstanceIdentifier);
            this.snapshotCreateTime(model.snapshotCreateTime);
            this.engine(model.engine);
            this.allocatedStorage(model.allocatedStorage);
            this.status(model.status);
            this.port(model.port);
            this.availabilityZone(model.availabilityZone);
            this.vpcId(model.vpcId);
            this.instanceCreateTime(model.instanceCreateTime);
            this.masterUsername(model.masterUsername);
            this.engineVersion(model.engineVersion);
            this.licenseModel(model.licenseModel);
            this.snapshotType(model.snapshotType);
            this.iops(model.iops);
            this.optionGroupName(model.optionGroupName);
            this.percentProgress(model.percentProgress);
            this.sourceRegion(model.sourceRegion);
            this.sourceDBSnapshotIdentifier(model.sourceDBSnapshotIdentifier);
            this.storageType(model.storageType);
            this.tdeCredentialArn(model.tdeCredentialArn);
            this.encrypted(model.encrypted);
            this.kmsKeyId(model.kmsKeyId);
            this.dbSnapshotArn(model.dbSnapshotArn);
            this.timezone(model.timezone);
            this.iamDatabaseAuthenticationEnabled(model.iamDatabaseAuthenticationEnabled);
        }

        public final String getDBSnapshotIdentifier() {
            return this.dbSnapshotIdentifier;
        }

        @Override
        public final Builder dbSnapshotIdentifier(String dbSnapshotIdentifier) {
            this.dbSnapshotIdentifier = dbSnapshotIdentifier;
            return this;
        }

        public final void setDBSnapshotIdentifier(String dbSnapshotIdentifier) {
            this.dbSnapshotIdentifier = dbSnapshotIdentifier;
        }

        public final String getDBInstanceIdentifier() {
            return this.dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final void setDBInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        public final Instant getSnapshotCreateTime() {
            return this.snapshotCreateTime;
        }

        @Override
        public final Builder snapshotCreateTime(Instant snapshotCreateTime) {
            this.snapshotCreateTime = snapshotCreateTime;
            return this;
        }

        public final void setSnapshotCreateTime(Instant snapshotCreateTime) {
            this.snapshotCreateTime = snapshotCreateTime;
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final Integer getAllocatedStorage() {
            return this.allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Instant getInstanceCreateTime() {
            return this.instanceCreateTime;
        }

        @Override
        public final Builder instanceCreateTime(Instant instanceCreateTime) {
            this.instanceCreateTime = instanceCreateTime;
            return this;
        }

        public final void setInstanceCreateTime(Instant instanceCreateTime) {
            this.instanceCreateTime = instanceCreateTime;
        }

        public final String getMasterUsername() {
            return this.masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getLicenseModel() {
            return this.licenseModel;
        }

        @Override
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        public final String getSnapshotType() {
            return this.snapshotType;
        }

        @Override
        public final Builder snapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
            return this;
        }

        public final void setSnapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
        }

        public final Integer getIops() {
            return this.iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        public final String getOptionGroupName() {
            return this.optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        public final Integer getPercentProgress() {
            return this.percentProgress;
        }

        @Override
        public final Builder percentProgress(Integer percentProgress) {
            this.percentProgress = percentProgress;
            return this;
        }

        public final void setPercentProgress(Integer percentProgress) {
            this.percentProgress = percentProgress;
        }

        public final String getSourceRegion() {
            return this.sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        public final String getSourceDBSnapshotIdentifier() {
            return this.sourceDBSnapshotIdentifier;
        }

        @Override
        public final Builder sourceDBSnapshotIdentifier(String sourceDBSnapshotIdentifier) {
            this.sourceDBSnapshotIdentifier = sourceDBSnapshotIdentifier;
            return this;
        }

        public final void setSourceDBSnapshotIdentifier(String sourceDBSnapshotIdentifier) {
            this.sourceDBSnapshotIdentifier = sourceDBSnapshotIdentifier;
        }

        public final String getStorageType() {
            return this.storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        public final String getTdeCredentialArn() {
            return this.tdeCredentialArn;
        }

        @Override
        public final Builder tdeCredentialArn(String tdeCredentialArn) {
            this.tdeCredentialArn = tdeCredentialArn;
            return this;
        }

        public final void setTdeCredentialArn(String tdeCredentialArn) {
            this.tdeCredentialArn = tdeCredentialArn;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getDBSnapshotArn() {
            return this.dbSnapshotArn;
        }

        @Override
        public final Builder dbSnapshotArn(String dbSnapshotArn) {
            this.dbSnapshotArn = dbSnapshotArn;
            return this;
        }

        public final void setDBSnapshotArn(String dbSnapshotArn) {
            this.dbSnapshotArn = dbSnapshotArn;
        }

        public final String getTimezone() {
            return this.timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        public final Boolean getIAMDatabaseAuthenticationEnabled() {
            return this.iamDatabaseAuthenticationEnabled;
        }

        @Override
        public final Builder iamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
            return this;
        }

        public final void setIAMDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
        }

        public DBSnapshot build() {
            return new DBSnapshot(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DBSnapshot> {
        public Builder dbSnapshotIdentifier(String var1);

        public Builder dbInstanceIdentifier(String var1);

        public Builder snapshotCreateTime(Instant var1);

        public Builder engine(String var1);

        public Builder allocatedStorage(Integer var1);

        public Builder status(String var1);

        public Builder port(Integer var1);

        public Builder availabilityZone(String var1);

        public Builder vpcId(String var1);

        public Builder instanceCreateTime(Instant var1);

        public Builder masterUsername(String var1);

        public Builder engineVersion(String var1);

        public Builder licenseModel(String var1);

        public Builder snapshotType(String var1);

        public Builder iops(Integer var1);

        public Builder optionGroupName(String var1);

        public Builder percentProgress(Integer var1);

        public Builder sourceRegion(String var1);

        public Builder sourceDBSnapshotIdentifier(String var1);

        public Builder storageType(String var1);

        public Builder tdeCredentialArn(String var1);

        public Builder encrypted(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder dbSnapshotArn(String var1);

        public Builder timezone(String var1);

        public Builder iamDatabaseAuthenticationEnabled(Boolean var1);
    }
}

