/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Certificate
implements ToCopyableBuilder<Builder, Certificate> {
    private final String certificateIdentifier;
    private final String certificateType;
    private final String thumbprint;
    private final Instant validFrom;
    private final Instant validTill;
    private final String certificateArn;

    private Certificate(BuilderImpl builder) {
        this.certificateIdentifier = builder.certificateIdentifier;
        this.certificateType = builder.certificateType;
        this.thumbprint = builder.thumbprint;
        this.validFrom = builder.validFrom;
        this.validTill = builder.validTill;
        this.certificateArn = builder.certificateArn;
    }

    public String certificateIdentifier() {
        return this.certificateIdentifier;
    }

    public String certificateType() {
        return this.certificateType;
    }

    public String thumbprint() {
        return this.thumbprint;
    }

    public Instant validFrom() {
        return this.validFrom;
    }

    public Instant validTill() {
        return this.validTill;
    }

    public String certificateArn() {
        return this.certificateArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.certificateIdentifier() == null ? 0 : this.certificateIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.certificateType() == null ? 0 : this.certificateType().hashCode());
        hashCode = 31 * hashCode + (this.thumbprint() == null ? 0 : this.thumbprint().hashCode());
        hashCode = 31 * hashCode + (this.validFrom() == null ? 0 : this.validFrom().hashCode());
        hashCode = 31 * hashCode + (this.validTill() == null ? 0 : this.validTill().hashCode());
        hashCode = 31 * hashCode + (this.certificateArn() == null ? 0 : this.certificateArn().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Certificate)) {
            return false;
        }
        Certificate other = (Certificate)obj;
        if (other.certificateIdentifier() == null ^ this.certificateIdentifier() == null) {
            return false;
        }
        if (other.certificateIdentifier() != null && !other.certificateIdentifier().equals(this.certificateIdentifier())) {
            return false;
        }
        if (other.certificateType() == null ^ this.certificateType() == null) {
            return false;
        }
        if (other.certificateType() != null && !other.certificateType().equals(this.certificateType())) {
            return false;
        }
        if (other.thumbprint() == null ^ this.thumbprint() == null) {
            return false;
        }
        if (other.thumbprint() != null && !other.thumbprint().equals(this.thumbprint())) {
            return false;
        }
        if (other.validFrom() == null ^ this.validFrom() == null) {
            return false;
        }
        if (other.validFrom() != null && !other.validFrom().equals(this.validFrom())) {
            return false;
        }
        if (other.validTill() == null ^ this.validTill() == null) {
            return false;
        }
        if (other.validTill() != null && !other.validTill().equals(this.validTill())) {
            return false;
        }
        if (other.certificateArn() == null ^ this.certificateArn() == null) {
            return false;
        }
        return other.certificateArn() == null || other.certificateArn().equals(this.certificateArn());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.certificateIdentifier() != null) {
            sb.append("CertificateIdentifier: ").append(this.certificateIdentifier()).append(",");
        }
        if (this.certificateType() != null) {
            sb.append("CertificateType: ").append(this.certificateType()).append(",");
        }
        if (this.thumbprint() != null) {
            sb.append("Thumbprint: ").append(this.thumbprint()).append(",");
        }
        if (this.validFrom() != null) {
            sb.append("ValidFrom: ").append(this.validFrom()).append(",");
        }
        if (this.validTill() != null) {
            sb.append("ValidTill: ").append(this.validTill()).append(",");
        }
        if (this.certificateArn() != null) {
            sb.append("CertificateArn: ").append(this.certificateArn()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateIdentifier": {
                return Optional.of(clazz.cast(this.certificateIdentifier()));
            }
            case "CertificateType": {
                return Optional.of(clazz.cast(this.certificateType()));
            }
            case "Thumbprint": {
                return Optional.of(clazz.cast(this.thumbprint()));
            }
            case "ValidFrom": {
                return Optional.of(clazz.cast(this.validFrom()));
            }
            case "ValidTill": {
                return Optional.of(clazz.cast(this.validTill()));
            }
            case "CertificateArn": {
                return Optional.of(clazz.cast(this.certificateArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String certificateIdentifier;
        private String certificateType;
        private String thumbprint;
        private Instant validFrom;
        private Instant validTill;
        private String certificateArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Certificate model) {
            this.certificateIdentifier(model.certificateIdentifier);
            this.certificateType(model.certificateType);
            this.thumbprint(model.thumbprint);
            this.validFrom(model.validFrom);
            this.validTill(model.validTill);
            this.certificateArn(model.certificateArn);
        }

        public final String getCertificateIdentifier() {
            return this.certificateIdentifier;
        }

        @Override
        public final Builder certificateIdentifier(String certificateIdentifier) {
            this.certificateIdentifier = certificateIdentifier;
            return this;
        }

        public final void setCertificateIdentifier(String certificateIdentifier) {
            this.certificateIdentifier = certificateIdentifier;
        }

        public final String getCertificateType() {
            return this.certificateType;
        }

        @Override
        public final Builder certificateType(String certificateType) {
            this.certificateType = certificateType;
            return this;
        }

        public final void setCertificateType(String certificateType) {
            this.certificateType = certificateType;
        }

        public final String getThumbprint() {
            return this.thumbprint;
        }

        @Override
        public final Builder thumbprint(String thumbprint) {
            this.thumbprint = thumbprint;
            return this;
        }

        public final void setThumbprint(String thumbprint) {
            this.thumbprint = thumbprint;
        }

        public final Instant getValidFrom() {
            return this.validFrom;
        }

        @Override
        public final Builder validFrom(Instant validFrom) {
            this.validFrom = validFrom;
            return this;
        }

        public final void setValidFrom(Instant validFrom) {
            this.validFrom = validFrom;
        }

        public final Instant getValidTill() {
            return this.validTill;
        }

        @Override
        public final Builder validTill(Instant validTill) {
            this.validTill = validTill;
            return this;
        }

        public final void setValidTill(Instant validTill) {
            this.validTill = validTill;
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public Certificate build() {
            return new Certificate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Certificate> {
        public Builder certificateIdentifier(String var1);

        public Builder certificateType(String var1);

        public Builder thumbprint(String var1);

        public Builder validFrom(Instant var1);

        public Builder validTill(Instant var1);

        public Builder certificateArn(String var1);
    }
}

