/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.rds.model.Filter;
import software.amazon.awssdk.services.rds.model.FilterListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDBClusterSnapshotsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeDBClusterSnapshotsRequest> {
    private final String dbClusterIdentifier;
    private final String dbClusterSnapshotIdentifier;
    private final String snapshotType;
    private final List<Filter> filters;
    private final Integer maxRecords;
    private final String marker;
    private final Boolean includeShared;
    private final Boolean includePublic;

    private DescribeDBClusterSnapshotsRequest(BuilderImpl builder) {
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.dbClusterSnapshotIdentifier = builder.dbClusterSnapshotIdentifier;
        this.snapshotType = builder.snapshotType;
        this.filters = builder.filters;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
        this.includeShared = builder.includeShared;
        this.includePublic = builder.includePublic;
    }

    public String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public String dbClusterSnapshotIdentifier() {
        return this.dbClusterSnapshotIdentifier;
    }

    public String snapshotType() {
        return this.snapshotType;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public String marker() {
        return this.marker;
    }

    public Boolean includeShared() {
        return this.includeShared;
    }

    public Boolean includePublic() {
        return this.includePublic;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dbClusterIdentifier() == null ? 0 : this.dbClusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.dbClusterSnapshotIdentifier() == null ? 0 : this.dbClusterSnapshotIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.snapshotType() == null ? 0 : this.snapshotType().hashCode());
        hashCode = 31 * hashCode + (this.filters() == null ? 0 : this.filters().hashCode());
        hashCode = 31 * hashCode + (this.maxRecords() == null ? 0 : this.maxRecords().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.includeShared() == null ? 0 : this.includeShared().hashCode());
        hashCode = 31 * hashCode + (this.includePublic() == null ? 0 : this.includePublic().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDBClusterSnapshotsRequest)) {
            return false;
        }
        DescribeDBClusterSnapshotsRequest other = (DescribeDBClusterSnapshotsRequest)((Object)obj);
        if (other.dbClusterIdentifier() == null ^ this.dbClusterIdentifier() == null) {
            return false;
        }
        if (other.dbClusterIdentifier() != null && !other.dbClusterIdentifier().equals(this.dbClusterIdentifier())) {
            return false;
        }
        if (other.dbClusterSnapshotIdentifier() == null ^ this.dbClusterSnapshotIdentifier() == null) {
            return false;
        }
        if (other.dbClusterSnapshotIdentifier() != null && !other.dbClusterSnapshotIdentifier().equals(this.dbClusterSnapshotIdentifier())) {
            return false;
        }
        if (other.snapshotType() == null ^ this.snapshotType() == null) {
            return false;
        }
        if (other.snapshotType() != null && !other.snapshotType().equals(this.snapshotType())) {
            return false;
        }
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.maxRecords() == null ^ this.maxRecords() == null) {
            return false;
        }
        if (other.maxRecords() != null && !other.maxRecords().equals(this.maxRecords())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.includeShared() == null ^ this.includeShared() == null) {
            return false;
        }
        if (other.includeShared() != null && !other.includeShared().equals(this.includeShared())) {
            return false;
        }
        if (other.includePublic() == null ^ this.includePublic() == null) {
            return false;
        }
        return other.includePublic() == null || other.includePublic().equals(this.includePublic());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dbClusterIdentifier() != null) {
            sb.append("DBClusterIdentifier: ").append(this.dbClusterIdentifier()).append(",");
        }
        if (this.dbClusterSnapshotIdentifier() != null) {
            sb.append("DBClusterSnapshotIdentifier: ").append(this.dbClusterSnapshotIdentifier()).append(",");
        }
        if (this.snapshotType() != null) {
            sb.append("SnapshotType: ").append(this.snapshotType()).append(",");
        }
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.maxRecords() != null) {
            sb.append("MaxRecords: ").append(this.maxRecords()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.includeShared() != null) {
            sb.append("IncludeShared: ").append(this.includeShared()).append(",");
        }
        if (this.includePublic() != null) {
            sb.append("IncludePublic: ").append(this.includePublic()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String dbClusterIdentifier;
        private String dbClusterSnapshotIdentifier;
        private String snapshotType;
        private List<Filter> filters;
        private Integer maxRecords;
        private String marker;
        private Boolean includeShared;
        private Boolean includePublic;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDBClusterSnapshotsRequest model) {
            this.setDBClusterIdentifier(model.dbClusterIdentifier);
            this.setDBClusterSnapshotIdentifier(model.dbClusterSnapshotIdentifier);
            this.setSnapshotType(model.snapshotType);
            this.setFilters(model.filters);
            this.setMaxRecords(model.maxRecords);
            this.setMarker(model.marker);
            this.setIncludeShared(model.includeShared);
            this.setIncludePublic(model.includePublic);
        }

        public final String getDBClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final void setDBClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        public final String getDBClusterSnapshotIdentifier() {
            return this.dbClusterSnapshotIdentifier;
        }

        @Override
        public final Builder dbClusterSnapshotIdentifier(String dbClusterSnapshotIdentifier) {
            this.dbClusterSnapshotIdentifier = dbClusterSnapshotIdentifier;
            return this;
        }

        public final void setDBClusterSnapshotIdentifier(String dbClusterSnapshotIdentifier) {
            this.dbClusterSnapshotIdentifier = dbClusterSnapshotIdentifier;
        }

        public final String getSnapshotType() {
            return this.snapshotType;
        }

        @Override
        public final Builder snapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
            return this;
        }

        public final void setSnapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
        }

        public final Collection<Filter> getFilters() {
            return this.filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Boolean getIncludeShared() {
            return this.includeShared;
        }

        @Override
        public final Builder includeShared(Boolean includeShared) {
            this.includeShared = includeShared;
            return this;
        }

        public final void setIncludeShared(Boolean includeShared) {
            this.includeShared = includeShared;
        }

        public final Boolean getIncludePublic() {
            return this.includePublic;
        }

        @Override
        public final Builder includePublic(Boolean includePublic) {
            this.includePublic = includePublic;
            return this;
        }

        public final void setIncludePublic(Boolean includePublic) {
            this.includePublic = includePublic;
        }

        public DescribeDBClusterSnapshotsRequest build() {
            return new DescribeDBClusterSnapshotsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeDBClusterSnapshotsRequest> {
        public Builder dbClusterIdentifier(String var1);

        public Builder dbClusterSnapshotIdentifier(String var1);

        public Builder snapshotType(String var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder maxRecords(Integer var1);

        public Builder marker(String var1);

        public Builder includeShared(Boolean var1);

        public Builder includePublic(Boolean var1);
    }
}

