/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.rds.model.EC2SecurityGroup;
import software.amazon.awssdk.services.rds.model.EC2SecurityGroupListCopier;
import software.amazon.awssdk.services.rds.model.IPRange;
import software.amazon.awssdk.services.rds.model.IPRangeListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DBSecurityGroup
implements ToCopyableBuilder<Builder, DBSecurityGroup> {
    private final String ownerId;
    private final String dbSecurityGroupName;
    private final String dbSecurityGroupDescription;
    private final String vpcId;
    private final List<EC2SecurityGroup> ec2SecurityGroups;
    private final List<IPRange> ipRanges;
    private final String dbSecurityGroupArn;

    private DBSecurityGroup(BuilderImpl builder) {
        this.ownerId = builder.ownerId;
        this.dbSecurityGroupName = builder.dbSecurityGroupName;
        this.dbSecurityGroupDescription = builder.dbSecurityGroupDescription;
        this.vpcId = builder.vpcId;
        this.ec2SecurityGroups = builder.ec2SecurityGroups;
        this.ipRanges = builder.ipRanges;
        this.dbSecurityGroupArn = builder.dbSecurityGroupArn;
    }

    public String ownerId() {
        return this.ownerId;
    }

    public String dbSecurityGroupName() {
        return this.dbSecurityGroupName;
    }

    public String dbSecurityGroupDescription() {
        return this.dbSecurityGroupDescription;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public List<EC2SecurityGroup> ec2SecurityGroups() {
        return this.ec2SecurityGroups;
    }

    public List<IPRange> ipRanges() {
        return this.ipRanges;
    }

    public String dbSecurityGroupArn() {
        return this.dbSecurityGroupArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.ownerId() == null ? 0 : this.ownerId().hashCode());
        hashCode = 31 * hashCode + (this.dbSecurityGroupName() == null ? 0 : this.dbSecurityGroupName().hashCode());
        hashCode = 31 * hashCode + (this.dbSecurityGroupDescription() == null ? 0 : this.dbSecurityGroupDescription().hashCode());
        hashCode = 31 * hashCode + (this.vpcId() == null ? 0 : this.vpcId().hashCode());
        hashCode = 31 * hashCode + (this.ec2SecurityGroups() == null ? 0 : this.ec2SecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.ipRanges() == null ? 0 : this.ipRanges().hashCode());
        hashCode = 31 * hashCode + (this.dbSecurityGroupArn() == null ? 0 : this.dbSecurityGroupArn().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBSecurityGroup)) {
            return false;
        }
        DBSecurityGroup other = (DBSecurityGroup)obj;
        if (other.ownerId() == null ^ this.ownerId() == null) {
            return false;
        }
        if (other.ownerId() != null && !other.ownerId().equals(this.ownerId())) {
            return false;
        }
        if (other.dbSecurityGroupName() == null ^ this.dbSecurityGroupName() == null) {
            return false;
        }
        if (other.dbSecurityGroupName() != null && !other.dbSecurityGroupName().equals(this.dbSecurityGroupName())) {
            return false;
        }
        if (other.dbSecurityGroupDescription() == null ^ this.dbSecurityGroupDescription() == null) {
            return false;
        }
        if (other.dbSecurityGroupDescription() != null && !other.dbSecurityGroupDescription().equals(this.dbSecurityGroupDescription())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        if (other.vpcId() != null && !other.vpcId().equals(this.vpcId())) {
            return false;
        }
        if (other.ec2SecurityGroups() == null ^ this.ec2SecurityGroups() == null) {
            return false;
        }
        if (other.ec2SecurityGroups() != null && !other.ec2SecurityGroups().equals(this.ec2SecurityGroups())) {
            return false;
        }
        if (other.ipRanges() == null ^ this.ipRanges() == null) {
            return false;
        }
        if (other.ipRanges() != null && !other.ipRanges().equals(this.ipRanges())) {
            return false;
        }
        if (other.dbSecurityGroupArn() == null ^ this.dbSecurityGroupArn() == null) {
            return false;
        }
        return other.dbSecurityGroupArn() == null || other.dbSecurityGroupArn().equals(this.dbSecurityGroupArn());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ownerId() != null) {
            sb.append("OwnerId: ").append(this.ownerId()).append(",");
        }
        if (this.dbSecurityGroupName() != null) {
            sb.append("DBSecurityGroupName: ").append(this.dbSecurityGroupName()).append(",");
        }
        if (this.dbSecurityGroupDescription() != null) {
            sb.append("DBSecurityGroupDescription: ").append(this.dbSecurityGroupDescription()).append(",");
        }
        if (this.vpcId() != null) {
            sb.append("VpcId: ").append(this.vpcId()).append(",");
        }
        if (this.ec2SecurityGroups() != null) {
            sb.append("EC2SecurityGroups: ").append(this.ec2SecurityGroups()).append(",");
        }
        if (this.ipRanges() != null) {
            sb.append("IPRanges: ").append(this.ipRanges()).append(",");
        }
        if (this.dbSecurityGroupArn() != null) {
            sb.append("DBSecurityGroupArn: ").append(this.dbSecurityGroupArn()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String ownerId;
        private String dbSecurityGroupName;
        private String dbSecurityGroupDescription;
        private String vpcId;
        private List<EC2SecurityGroup> ec2SecurityGroups;
        private List<IPRange> ipRanges;
        private String dbSecurityGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DBSecurityGroup model) {
            this.setOwnerId(model.ownerId);
            this.setDBSecurityGroupName(model.dbSecurityGroupName);
            this.setDBSecurityGroupDescription(model.dbSecurityGroupDescription);
            this.setVpcId(model.vpcId);
            this.setEC2SecurityGroups(model.ec2SecurityGroups);
            this.setIPRanges(model.ipRanges);
            this.setDBSecurityGroupArn(model.dbSecurityGroupArn);
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getDBSecurityGroupName() {
            return this.dbSecurityGroupName;
        }

        @Override
        public final Builder dbSecurityGroupName(String dbSecurityGroupName) {
            this.dbSecurityGroupName = dbSecurityGroupName;
            return this;
        }

        public final void setDBSecurityGroupName(String dbSecurityGroupName) {
            this.dbSecurityGroupName = dbSecurityGroupName;
        }

        public final String getDBSecurityGroupDescription() {
            return this.dbSecurityGroupDescription;
        }

        @Override
        public final Builder dbSecurityGroupDescription(String dbSecurityGroupDescription) {
            this.dbSecurityGroupDescription = dbSecurityGroupDescription;
            return this;
        }

        public final void setDBSecurityGroupDescription(String dbSecurityGroupDescription) {
            this.dbSecurityGroupDescription = dbSecurityGroupDescription;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Collection<EC2SecurityGroup> getEC2SecurityGroups() {
            return this.ec2SecurityGroups;
        }

        @Override
        public final Builder ec2SecurityGroups(Collection<EC2SecurityGroup> ec2SecurityGroups) {
            this.ec2SecurityGroups = EC2SecurityGroupListCopier.copy(ec2SecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2SecurityGroups(EC2SecurityGroup ... ec2SecurityGroups) {
            this.ec2SecurityGroups(Arrays.asList(ec2SecurityGroups));
            return this;
        }

        public final void setEC2SecurityGroups(Collection<EC2SecurityGroup> ec2SecurityGroups) {
            this.ec2SecurityGroups = EC2SecurityGroupListCopier.copy(ec2SecurityGroups);
        }

        public final Collection<IPRange> getIPRanges() {
            return this.ipRanges;
        }

        @Override
        public final Builder ipRanges(Collection<IPRange> ipRanges) {
            this.ipRanges = IPRangeListCopier.copy(ipRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipRanges(IPRange ... ipRanges) {
            this.ipRanges(Arrays.asList(ipRanges));
            return this;
        }

        public final void setIPRanges(Collection<IPRange> ipRanges) {
            this.ipRanges = IPRangeListCopier.copy(ipRanges);
        }

        public final String getDBSecurityGroupArn() {
            return this.dbSecurityGroupArn;
        }

        @Override
        public final Builder dbSecurityGroupArn(String dbSecurityGroupArn) {
            this.dbSecurityGroupArn = dbSecurityGroupArn;
            return this;
        }

        public final void setDBSecurityGroupArn(String dbSecurityGroupArn) {
            this.dbSecurityGroupArn = dbSecurityGroupArn;
        }

        public DBSecurityGroup build() {
            return new DBSecurityGroup(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DBSecurityGroup> {
        public Builder ownerId(String var1);

        public Builder dbSecurityGroupName(String var1);

        public Builder dbSecurityGroupDescription(String var1);

        public Builder vpcId(String var1);

        public Builder ec2SecurityGroups(Collection<EC2SecurityGroup> var1);

        public Builder ec2SecurityGroups(EC2SecurityGroup ... var1);

        public Builder ipRanges(Collection<IPRange> var1);

        public Builder ipRanges(IPRange ... var1);

        public Builder dbSecurityGroupArn(String var1);
    }
}

