/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.rds.model.ModifyDBSnapshotAttributeRequest;
import software.amazon.awssdk.util.StringUtils;

public class ModifyDBSnapshotAttributeRequestMarshaller
implements Marshaller<Request<ModifyDBSnapshotAttributeRequest>, ModifyDBSnapshotAttributeRequest> {
    public Request<ModifyDBSnapshotAttributeRequest> marshall(ModifyDBSnapshotAttributeRequest modifyDBSnapshotAttributeRequest) {
        List<String> valuesToRemoveList;
        List<String> valuesToAddList;
        if (modifyDBSnapshotAttributeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyDBSnapshotAttributeRequest, "RDSClient");
        request.addParameter("Action", "ModifyDBSnapshotAttribute");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyDBSnapshotAttributeRequest.dbSnapshotIdentifier() != null) {
            request.addParameter("DBSnapshotIdentifier", StringUtils.fromString((String)modifyDBSnapshotAttributeRequest.dbSnapshotIdentifier()));
        }
        if (modifyDBSnapshotAttributeRequest.attributeName() != null) {
            request.addParameter("AttributeName", StringUtils.fromString((String)modifyDBSnapshotAttributeRequest.attributeName()));
        }
        if ((valuesToAddList = modifyDBSnapshotAttributeRequest.valuesToAdd()) != null) {
            if (!valuesToAddList.isEmpty()) {
                int valuesToAddListIndex = 1;
                for (String valuesToAddListValue : valuesToAddList) {
                    if (valuesToAddListValue != null) {
                        request.addParameter("ValuesToAdd.AttributeValue." + valuesToAddListIndex, StringUtils.fromString((String)valuesToAddListValue));
                    }
                    ++valuesToAddListIndex;
                }
            } else {
                request.addParameter("ValuesToAdd", "");
            }
        }
        if ((valuesToRemoveList = modifyDBSnapshotAttributeRequest.valuesToRemove()) != null) {
            if (!valuesToRemoveList.isEmpty()) {
                int valuesToRemoveListIndex = 1;
                for (String valuesToRemoveListValue : valuesToRemoveList) {
                    if (valuesToRemoveListValue != null) {
                        request.addParameter("ValuesToRemove.AttributeValue." + valuesToRemoveListIndex, StringUtils.fromString((String)valuesToRemoveListValue));
                    }
                    ++valuesToRemoveListIndex;
                }
            } else {
                request.addParameter("ValuesToRemove", "");
            }
        }
        return request;
    }
}

