/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rds.model.EC2SecurityGroup;

public class EC2SecurityGroupUnmarshaller
implements Unmarshaller<EC2SecurityGroup, StaxUnmarshallerContext> {
    private static final EC2SecurityGroupUnmarshaller INSTANCE = new EC2SecurityGroupUnmarshaller();

    public EC2SecurityGroup unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        EC2SecurityGroup.Builder ec2SecurityGroup = EC2SecurityGroup.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Status", targetDepth)) {
                    ec2SecurityGroup.status(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EC2SecurityGroupName", targetDepth)) {
                    ec2SecurityGroup.ec2SecurityGroupName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EC2SecurityGroupId", targetDepth)) {
                    ec2SecurityGroup.ec2SecurityGroupId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("EC2SecurityGroupOwnerId", targetDepth)) continue;
                ec2SecurityGroup.ec2SecurityGroupOwnerId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (EC2SecurityGroup)ec2SecurityGroup.build();
    }

    public static EC2SecurityGroupUnmarshaller getInstance() {
        return INSTANCE;
    }
}

