/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.rds.model.Parameter;
import software.amazon.awssdk.services.rds.model.ParametersListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ResetDBClusterParameterGroupRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ResetDBClusterParameterGroupRequest> {
    private final String dbClusterParameterGroupName;
    private final Boolean resetAllParameters;
    private final List<Parameter> parameters;

    private ResetDBClusterParameterGroupRequest(BuilderImpl builder) {
        this.dbClusterParameterGroupName = builder.dbClusterParameterGroupName;
        this.resetAllParameters = builder.resetAllParameters;
        this.parameters = builder.parameters;
    }

    public String dbClusterParameterGroupName() {
        return this.dbClusterParameterGroupName;
    }

    public Boolean resetAllParameters() {
        return this.resetAllParameters;
    }

    public List<Parameter> parameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dbClusterParameterGroupName() == null ? 0 : this.dbClusterParameterGroupName().hashCode());
        hashCode = 31 * hashCode + (this.resetAllParameters() == null ? 0 : this.resetAllParameters().hashCode());
        hashCode = 31 * hashCode + (this.parameters() == null ? 0 : this.parameters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetDBClusterParameterGroupRequest)) {
            return false;
        }
        ResetDBClusterParameterGroupRequest other = (ResetDBClusterParameterGroupRequest)((Object)obj);
        if (other.dbClusterParameterGroupName() == null ^ this.dbClusterParameterGroupName() == null) {
            return false;
        }
        if (other.dbClusterParameterGroupName() != null && !other.dbClusterParameterGroupName().equals(this.dbClusterParameterGroupName())) {
            return false;
        }
        if (other.resetAllParameters() == null ^ this.resetAllParameters() == null) {
            return false;
        }
        if (other.resetAllParameters() != null && !other.resetAllParameters().equals(this.resetAllParameters())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        return other.parameters() == null || other.parameters().equals(this.parameters());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dbClusterParameterGroupName() != null) {
            sb.append("DBClusterParameterGroupName: ").append(this.dbClusterParameterGroupName()).append(",");
        }
        if (this.resetAllParameters() != null) {
            sb.append("ResetAllParameters: ").append(this.resetAllParameters()).append(",");
        }
        if (this.parameters() != null) {
            sb.append("Parameters: ").append(this.parameters()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String dbClusterParameterGroupName;
        private Boolean resetAllParameters;
        private List<Parameter> parameters;

        private BuilderImpl() {
        }

        private BuilderImpl(ResetDBClusterParameterGroupRequest model) {
            this.setDBClusterParameterGroupName(model.dbClusterParameterGroupName);
            this.setResetAllParameters(model.resetAllParameters);
            this.setParameters(model.parameters);
        }

        public final String getDBClusterParameterGroupName() {
            return this.dbClusterParameterGroupName;
        }

        @Override
        public final Builder dbClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
            return this;
        }

        public final void setDBClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
        }

        public final Boolean getResetAllParameters() {
            return this.resetAllParameters;
        }

        @Override
        public final Builder resetAllParameters(Boolean resetAllParameters) {
            this.resetAllParameters = resetAllParameters;
            return this;
        }

        public final void setResetAllParameters(Boolean resetAllParameters) {
            this.resetAllParameters = resetAllParameters;
        }

        public final Collection<Parameter> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        public final void setParameters(Collection<Parameter> parameters) {
            this.parameters = ParametersListCopier.copy(parameters);
        }

        public ResetDBClusterParameterGroupRequest build() {
            return new ResetDBClusterParameterGroupRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResetDBClusterParameterGroupRequest> {
        public Builder dbClusterParameterGroupName(String var1);

        public Builder resetAllParameters(Boolean var1);

        public Builder parameters(Collection<Parameter> var1);

        public Builder parameters(Parameter ... var1);
    }
}

