/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.rds.model.DBSecurityGroupNameListCopier;
import software.amazon.awssdk.services.rds.model.VpcSecurityGroupIdListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyDBInstanceRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ModifyDBInstanceRequest> {
    private final String dbInstanceIdentifier;
    private final Integer allocatedStorage;
    private final String dbInstanceClass;
    private final String dbSubnetGroupName;
    private final List<String> dbSecurityGroups;
    private final List<String> vpcSecurityGroupIds;
    private final Boolean applyImmediately;
    private final String masterUserPassword;
    private final String dbParameterGroupName;
    private final Integer backupRetentionPeriod;
    private final String preferredBackupWindow;
    private final String preferredMaintenanceWindow;
    private final Boolean multiAZ;
    private final String engineVersion;
    private final Boolean allowMajorVersionUpgrade;
    private final Boolean autoMinorVersionUpgrade;
    private final String licenseModel;
    private final Integer iops;
    private final String optionGroupName;
    private final String newDBInstanceIdentifier;
    private final String storageType;
    private final String tdeCredentialArn;
    private final String tdeCredentialPassword;
    private final String caCertificateIdentifier;
    private final String domain;
    private final Boolean copyTagsToSnapshot;
    private final Integer monitoringInterval;
    private final Integer dbPortNumber;
    private final Boolean publiclyAccessible;
    private final String monitoringRoleArn;
    private final String domainIAMRoleName;
    private final Integer promotionTier;
    private final Boolean enableIAMDatabaseAuthentication;

    private ModifyDBInstanceRequest(BuilderImpl builder) {
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.allocatedStorage = builder.allocatedStorage;
        this.dbInstanceClass = builder.dbInstanceClass;
        this.dbSubnetGroupName = builder.dbSubnetGroupName;
        this.dbSecurityGroups = builder.dbSecurityGroups;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.applyImmediately = builder.applyImmediately;
        this.masterUserPassword = builder.masterUserPassword;
        this.dbParameterGroupName = builder.dbParameterGroupName;
        this.backupRetentionPeriod = builder.backupRetentionPeriod;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.multiAZ = builder.multiAZ;
        this.engineVersion = builder.engineVersion;
        this.allowMajorVersionUpgrade = builder.allowMajorVersionUpgrade;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.licenseModel = builder.licenseModel;
        this.iops = builder.iops;
        this.optionGroupName = builder.optionGroupName;
        this.newDBInstanceIdentifier = builder.newDBInstanceIdentifier;
        this.storageType = builder.storageType;
        this.tdeCredentialArn = builder.tdeCredentialArn;
        this.tdeCredentialPassword = builder.tdeCredentialPassword;
        this.caCertificateIdentifier = builder.caCertificateIdentifier;
        this.domain = builder.domain;
        this.copyTagsToSnapshot = builder.copyTagsToSnapshot;
        this.monitoringInterval = builder.monitoringInterval;
        this.dbPortNumber = builder.dbPortNumber;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.monitoringRoleArn = builder.monitoringRoleArn;
        this.domainIAMRoleName = builder.domainIAMRoleName;
        this.promotionTier = builder.promotionTier;
        this.enableIAMDatabaseAuthentication = builder.enableIAMDatabaseAuthentication;
    }

    public String dbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public Integer allocatedStorage() {
        return this.allocatedStorage;
    }

    public String dbInstanceClass() {
        return this.dbInstanceClass;
    }

    public String dbSubnetGroupName() {
        return this.dbSubnetGroupName;
    }

    public List<String> dbSecurityGroups() {
        return this.dbSecurityGroups;
    }

    public List<String> vpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    public Boolean applyImmediately() {
        return this.applyImmediately;
    }

    public String masterUserPassword() {
        return this.masterUserPassword;
    }

    public String dbParameterGroupName() {
        return this.dbParameterGroupName;
    }

    public Integer backupRetentionPeriod() {
        return this.backupRetentionPeriod;
    }

    public String preferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    public String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public Boolean multiAZ() {
        return this.multiAZ;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public Boolean allowMajorVersionUpgrade() {
        return this.allowMajorVersionUpgrade;
    }

    public Boolean autoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public String licenseModel() {
        return this.licenseModel;
    }

    public Integer iops() {
        return this.iops;
    }

    public String optionGroupName() {
        return this.optionGroupName;
    }

    public String newDBInstanceIdentifier() {
        return this.newDBInstanceIdentifier;
    }

    public String storageType() {
        return this.storageType;
    }

    public String tdeCredentialArn() {
        return this.tdeCredentialArn;
    }

    public String tdeCredentialPassword() {
        return this.tdeCredentialPassword;
    }

    public String caCertificateIdentifier() {
        return this.caCertificateIdentifier;
    }

    public String domain() {
        return this.domain;
    }

    public Boolean copyTagsToSnapshot() {
        return this.copyTagsToSnapshot;
    }

    public Integer monitoringInterval() {
        return this.monitoringInterval;
    }

    public Integer dbPortNumber() {
        return this.dbPortNumber;
    }

    public Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public String monitoringRoleArn() {
        return this.monitoringRoleArn;
    }

    public String domainIAMRoleName() {
        return this.domainIAMRoleName;
    }

    public Integer promotionTier() {
        return this.promotionTier;
    }

    public Boolean enableIAMDatabaseAuthentication() {
        return this.enableIAMDatabaseAuthentication;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dbInstanceIdentifier() == null ? 0 : this.dbInstanceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.allocatedStorage() == null ? 0 : this.allocatedStorage().hashCode());
        hashCode = 31 * hashCode + (this.dbInstanceClass() == null ? 0 : this.dbInstanceClass().hashCode());
        hashCode = 31 * hashCode + (this.dbSubnetGroupName() == null ? 0 : this.dbSubnetGroupName().hashCode());
        hashCode = 31 * hashCode + (this.dbSecurityGroups() == null ? 0 : this.dbSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.vpcSecurityGroupIds() == null ? 0 : this.vpcSecurityGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.applyImmediately() == null ? 0 : this.applyImmediately().hashCode());
        hashCode = 31 * hashCode + (this.masterUserPassword() == null ? 0 : this.masterUserPassword().hashCode());
        hashCode = 31 * hashCode + (this.dbParameterGroupName() == null ? 0 : this.dbParameterGroupName().hashCode());
        hashCode = 31 * hashCode + (this.backupRetentionPeriod() == null ? 0 : this.backupRetentionPeriod().hashCode());
        hashCode = 31 * hashCode + (this.preferredBackupWindow() == null ? 0 : this.preferredBackupWindow().hashCode());
        hashCode = 31 * hashCode + (this.preferredMaintenanceWindow() == null ? 0 : this.preferredMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.multiAZ() == null ? 0 : this.multiAZ().hashCode());
        hashCode = 31 * hashCode + (this.engineVersion() == null ? 0 : this.engineVersion().hashCode());
        hashCode = 31 * hashCode + (this.allowMajorVersionUpgrade() == null ? 0 : this.allowMajorVersionUpgrade().hashCode());
        hashCode = 31 * hashCode + (this.autoMinorVersionUpgrade() == null ? 0 : this.autoMinorVersionUpgrade().hashCode());
        hashCode = 31 * hashCode + (this.licenseModel() == null ? 0 : this.licenseModel().hashCode());
        hashCode = 31 * hashCode + (this.iops() == null ? 0 : this.iops().hashCode());
        hashCode = 31 * hashCode + (this.optionGroupName() == null ? 0 : this.optionGroupName().hashCode());
        hashCode = 31 * hashCode + (this.newDBInstanceIdentifier() == null ? 0 : this.newDBInstanceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.storageType() == null ? 0 : this.storageType().hashCode());
        hashCode = 31 * hashCode + (this.tdeCredentialArn() == null ? 0 : this.tdeCredentialArn().hashCode());
        hashCode = 31 * hashCode + (this.tdeCredentialPassword() == null ? 0 : this.tdeCredentialPassword().hashCode());
        hashCode = 31 * hashCode + (this.caCertificateIdentifier() == null ? 0 : this.caCertificateIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.domain() == null ? 0 : this.domain().hashCode());
        hashCode = 31 * hashCode + (this.copyTagsToSnapshot() == null ? 0 : this.copyTagsToSnapshot().hashCode());
        hashCode = 31 * hashCode + (this.monitoringInterval() == null ? 0 : this.monitoringInterval().hashCode());
        hashCode = 31 * hashCode + (this.dbPortNumber() == null ? 0 : this.dbPortNumber().hashCode());
        hashCode = 31 * hashCode + (this.publiclyAccessible() == null ? 0 : this.publiclyAccessible().hashCode());
        hashCode = 31 * hashCode + (this.monitoringRoleArn() == null ? 0 : this.monitoringRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.domainIAMRoleName() == null ? 0 : this.domainIAMRoleName().hashCode());
        hashCode = 31 * hashCode + (this.promotionTier() == null ? 0 : this.promotionTier().hashCode());
        hashCode = 31 * hashCode + (this.enableIAMDatabaseAuthentication() == null ? 0 : this.enableIAMDatabaseAuthentication().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDBInstanceRequest)) {
            return false;
        }
        ModifyDBInstanceRequest other = (ModifyDBInstanceRequest)((Object)obj);
        if (other.dbInstanceIdentifier() == null ^ this.dbInstanceIdentifier() == null) {
            return false;
        }
        if (other.dbInstanceIdentifier() != null && !other.dbInstanceIdentifier().equals(this.dbInstanceIdentifier())) {
            return false;
        }
        if (other.allocatedStorage() == null ^ this.allocatedStorage() == null) {
            return false;
        }
        if (other.allocatedStorage() != null && !other.allocatedStorage().equals(this.allocatedStorage())) {
            return false;
        }
        if (other.dbInstanceClass() == null ^ this.dbInstanceClass() == null) {
            return false;
        }
        if (other.dbInstanceClass() != null && !other.dbInstanceClass().equals(this.dbInstanceClass())) {
            return false;
        }
        if (other.dbSubnetGroupName() == null ^ this.dbSubnetGroupName() == null) {
            return false;
        }
        if (other.dbSubnetGroupName() != null && !other.dbSubnetGroupName().equals(this.dbSubnetGroupName())) {
            return false;
        }
        if (other.dbSecurityGroups() == null ^ this.dbSecurityGroups() == null) {
            return false;
        }
        if (other.dbSecurityGroups() != null && !other.dbSecurityGroups().equals(this.dbSecurityGroups())) {
            return false;
        }
        if (other.vpcSecurityGroupIds() == null ^ this.vpcSecurityGroupIds() == null) {
            return false;
        }
        if (other.vpcSecurityGroupIds() != null && !other.vpcSecurityGroupIds().equals(this.vpcSecurityGroupIds())) {
            return false;
        }
        if (other.applyImmediately() == null ^ this.applyImmediately() == null) {
            return false;
        }
        if (other.applyImmediately() != null && !other.applyImmediately().equals(this.applyImmediately())) {
            return false;
        }
        if (other.masterUserPassword() == null ^ this.masterUserPassword() == null) {
            return false;
        }
        if (other.masterUserPassword() != null && !other.masterUserPassword().equals(this.masterUserPassword())) {
            return false;
        }
        if (other.dbParameterGroupName() == null ^ this.dbParameterGroupName() == null) {
            return false;
        }
        if (other.dbParameterGroupName() != null && !other.dbParameterGroupName().equals(this.dbParameterGroupName())) {
            return false;
        }
        if (other.backupRetentionPeriod() == null ^ this.backupRetentionPeriod() == null) {
            return false;
        }
        if (other.backupRetentionPeriod() != null && !other.backupRetentionPeriod().equals(this.backupRetentionPeriod())) {
            return false;
        }
        if (other.preferredBackupWindow() == null ^ this.preferredBackupWindow() == null) {
            return false;
        }
        if (other.preferredBackupWindow() != null && !other.preferredBackupWindow().equals(this.preferredBackupWindow())) {
            return false;
        }
        if (other.preferredMaintenanceWindow() == null ^ this.preferredMaintenanceWindow() == null) {
            return false;
        }
        if (other.preferredMaintenanceWindow() != null && !other.preferredMaintenanceWindow().equals(this.preferredMaintenanceWindow())) {
            return false;
        }
        if (other.multiAZ() == null ^ this.multiAZ() == null) {
            return false;
        }
        if (other.multiAZ() != null && !other.multiAZ().equals(this.multiAZ())) {
            return false;
        }
        if (other.engineVersion() == null ^ this.engineVersion() == null) {
            return false;
        }
        if (other.engineVersion() != null && !other.engineVersion().equals(this.engineVersion())) {
            return false;
        }
        if (other.allowMajorVersionUpgrade() == null ^ this.allowMajorVersionUpgrade() == null) {
            return false;
        }
        if (other.allowMajorVersionUpgrade() != null && !other.allowMajorVersionUpgrade().equals(this.allowMajorVersionUpgrade())) {
            return false;
        }
        if (other.autoMinorVersionUpgrade() == null ^ this.autoMinorVersionUpgrade() == null) {
            return false;
        }
        if (other.autoMinorVersionUpgrade() != null && !other.autoMinorVersionUpgrade().equals(this.autoMinorVersionUpgrade())) {
            return false;
        }
        if (other.licenseModel() == null ^ this.licenseModel() == null) {
            return false;
        }
        if (other.licenseModel() != null && !other.licenseModel().equals(this.licenseModel())) {
            return false;
        }
        if (other.iops() == null ^ this.iops() == null) {
            return false;
        }
        if (other.iops() != null && !other.iops().equals(this.iops())) {
            return false;
        }
        if (other.optionGroupName() == null ^ this.optionGroupName() == null) {
            return false;
        }
        if (other.optionGroupName() != null && !other.optionGroupName().equals(this.optionGroupName())) {
            return false;
        }
        if (other.newDBInstanceIdentifier() == null ^ this.newDBInstanceIdentifier() == null) {
            return false;
        }
        if (other.newDBInstanceIdentifier() != null && !other.newDBInstanceIdentifier().equals(this.newDBInstanceIdentifier())) {
            return false;
        }
        if (other.storageType() == null ^ this.storageType() == null) {
            return false;
        }
        if (other.storageType() != null && !other.storageType().equals(this.storageType())) {
            return false;
        }
        if (other.tdeCredentialArn() == null ^ this.tdeCredentialArn() == null) {
            return false;
        }
        if (other.tdeCredentialArn() != null && !other.tdeCredentialArn().equals(this.tdeCredentialArn())) {
            return false;
        }
        if (other.tdeCredentialPassword() == null ^ this.tdeCredentialPassword() == null) {
            return false;
        }
        if (other.tdeCredentialPassword() != null && !other.tdeCredentialPassword().equals(this.tdeCredentialPassword())) {
            return false;
        }
        if (other.caCertificateIdentifier() == null ^ this.caCertificateIdentifier() == null) {
            return false;
        }
        if (other.caCertificateIdentifier() != null && !other.caCertificateIdentifier().equals(this.caCertificateIdentifier())) {
            return false;
        }
        if (other.domain() == null ^ this.domain() == null) {
            return false;
        }
        if (other.domain() != null && !other.domain().equals(this.domain())) {
            return false;
        }
        if (other.copyTagsToSnapshot() == null ^ this.copyTagsToSnapshot() == null) {
            return false;
        }
        if (other.copyTagsToSnapshot() != null && !other.copyTagsToSnapshot().equals(this.copyTagsToSnapshot())) {
            return false;
        }
        if (other.monitoringInterval() == null ^ this.monitoringInterval() == null) {
            return false;
        }
        if (other.monitoringInterval() != null && !other.monitoringInterval().equals(this.monitoringInterval())) {
            return false;
        }
        if (other.dbPortNumber() == null ^ this.dbPortNumber() == null) {
            return false;
        }
        if (other.dbPortNumber() != null && !other.dbPortNumber().equals(this.dbPortNumber())) {
            return false;
        }
        if (other.publiclyAccessible() == null ^ this.publiclyAccessible() == null) {
            return false;
        }
        if (other.publiclyAccessible() != null && !other.publiclyAccessible().equals(this.publiclyAccessible())) {
            return false;
        }
        if (other.monitoringRoleArn() == null ^ this.monitoringRoleArn() == null) {
            return false;
        }
        if (other.monitoringRoleArn() != null && !other.monitoringRoleArn().equals(this.monitoringRoleArn())) {
            return false;
        }
        if (other.domainIAMRoleName() == null ^ this.domainIAMRoleName() == null) {
            return false;
        }
        if (other.domainIAMRoleName() != null && !other.domainIAMRoleName().equals(this.domainIAMRoleName())) {
            return false;
        }
        if (other.promotionTier() == null ^ this.promotionTier() == null) {
            return false;
        }
        if (other.promotionTier() != null && !other.promotionTier().equals(this.promotionTier())) {
            return false;
        }
        if (other.enableIAMDatabaseAuthentication() == null ^ this.enableIAMDatabaseAuthentication() == null) {
            return false;
        }
        return other.enableIAMDatabaseAuthentication() == null || other.enableIAMDatabaseAuthentication().equals(this.enableIAMDatabaseAuthentication());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dbInstanceIdentifier() != null) {
            sb.append("DBInstanceIdentifier: ").append(this.dbInstanceIdentifier()).append(",");
        }
        if (this.allocatedStorage() != null) {
            sb.append("AllocatedStorage: ").append(this.allocatedStorage()).append(",");
        }
        if (this.dbInstanceClass() != null) {
            sb.append("DBInstanceClass: ").append(this.dbInstanceClass()).append(",");
        }
        if (this.dbSubnetGroupName() != null) {
            sb.append("DBSubnetGroupName: ").append(this.dbSubnetGroupName()).append(",");
        }
        if (this.dbSecurityGroups() != null) {
            sb.append("DBSecurityGroups: ").append(this.dbSecurityGroups()).append(",");
        }
        if (this.vpcSecurityGroupIds() != null) {
            sb.append("VpcSecurityGroupIds: ").append(this.vpcSecurityGroupIds()).append(",");
        }
        if (this.applyImmediately() != null) {
            sb.append("ApplyImmediately: ").append(this.applyImmediately()).append(",");
        }
        if (this.masterUserPassword() != null) {
            sb.append("MasterUserPassword: ").append(this.masterUserPassword()).append(",");
        }
        if (this.dbParameterGroupName() != null) {
            sb.append("DBParameterGroupName: ").append(this.dbParameterGroupName()).append(",");
        }
        if (this.backupRetentionPeriod() != null) {
            sb.append("BackupRetentionPeriod: ").append(this.backupRetentionPeriod()).append(",");
        }
        if (this.preferredBackupWindow() != null) {
            sb.append("PreferredBackupWindow: ").append(this.preferredBackupWindow()).append(",");
        }
        if (this.preferredMaintenanceWindow() != null) {
            sb.append("PreferredMaintenanceWindow: ").append(this.preferredMaintenanceWindow()).append(",");
        }
        if (this.multiAZ() != null) {
            sb.append("MultiAZ: ").append(this.multiAZ()).append(",");
        }
        if (this.engineVersion() != null) {
            sb.append("EngineVersion: ").append(this.engineVersion()).append(",");
        }
        if (this.allowMajorVersionUpgrade() != null) {
            sb.append("AllowMajorVersionUpgrade: ").append(this.allowMajorVersionUpgrade()).append(",");
        }
        if (this.autoMinorVersionUpgrade() != null) {
            sb.append("AutoMinorVersionUpgrade: ").append(this.autoMinorVersionUpgrade()).append(",");
        }
        if (this.licenseModel() != null) {
            sb.append("LicenseModel: ").append(this.licenseModel()).append(",");
        }
        if (this.iops() != null) {
            sb.append("Iops: ").append(this.iops()).append(",");
        }
        if (this.optionGroupName() != null) {
            sb.append("OptionGroupName: ").append(this.optionGroupName()).append(",");
        }
        if (this.newDBInstanceIdentifier() != null) {
            sb.append("NewDBInstanceIdentifier: ").append(this.newDBInstanceIdentifier()).append(",");
        }
        if (this.storageType() != null) {
            sb.append("StorageType: ").append(this.storageType()).append(",");
        }
        if (this.tdeCredentialArn() != null) {
            sb.append("TdeCredentialArn: ").append(this.tdeCredentialArn()).append(",");
        }
        if (this.tdeCredentialPassword() != null) {
            sb.append("TdeCredentialPassword: ").append(this.tdeCredentialPassword()).append(",");
        }
        if (this.caCertificateIdentifier() != null) {
            sb.append("CACertificateIdentifier: ").append(this.caCertificateIdentifier()).append(",");
        }
        if (this.domain() != null) {
            sb.append("Domain: ").append(this.domain()).append(",");
        }
        if (this.copyTagsToSnapshot() != null) {
            sb.append("CopyTagsToSnapshot: ").append(this.copyTagsToSnapshot()).append(",");
        }
        if (this.monitoringInterval() != null) {
            sb.append("MonitoringInterval: ").append(this.monitoringInterval()).append(",");
        }
        if (this.dbPortNumber() != null) {
            sb.append("DBPortNumber: ").append(this.dbPortNumber()).append(",");
        }
        if (this.publiclyAccessible() != null) {
            sb.append("PubliclyAccessible: ").append(this.publiclyAccessible()).append(",");
        }
        if (this.monitoringRoleArn() != null) {
            sb.append("MonitoringRoleArn: ").append(this.monitoringRoleArn()).append(",");
        }
        if (this.domainIAMRoleName() != null) {
            sb.append("DomainIAMRoleName: ").append(this.domainIAMRoleName()).append(",");
        }
        if (this.promotionTier() != null) {
            sb.append("PromotionTier: ").append(this.promotionTier()).append(",");
        }
        if (this.enableIAMDatabaseAuthentication() != null) {
            sb.append("EnableIAMDatabaseAuthentication: ").append(this.enableIAMDatabaseAuthentication()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String dbInstanceIdentifier;
        private Integer allocatedStorage;
        private String dbInstanceClass;
        private String dbSubnetGroupName;
        private List<String> dbSecurityGroups;
        private List<String> vpcSecurityGroupIds;
        private Boolean applyImmediately;
        private String masterUserPassword;
        private String dbParameterGroupName;
        private Integer backupRetentionPeriod;
        private String preferredBackupWindow;
        private String preferredMaintenanceWindow;
        private Boolean multiAZ;
        private String engineVersion;
        private Boolean allowMajorVersionUpgrade;
        private Boolean autoMinorVersionUpgrade;
        private String licenseModel;
        private Integer iops;
        private String optionGroupName;
        private String newDBInstanceIdentifier;
        private String storageType;
        private String tdeCredentialArn;
        private String tdeCredentialPassword;
        private String caCertificateIdentifier;
        private String domain;
        private Boolean copyTagsToSnapshot;
        private Integer monitoringInterval;
        private Integer dbPortNumber;
        private Boolean publiclyAccessible;
        private String monitoringRoleArn;
        private String domainIAMRoleName;
        private Integer promotionTier;
        private Boolean enableIAMDatabaseAuthentication;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDBInstanceRequest model) {
            this.setDBInstanceIdentifier(model.dbInstanceIdentifier);
            this.setAllocatedStorage(model.allocatedStorage);
            this.setDBInstanceClass(model.dbInstanceClass);
            this.setDBSubnetGroupName(model.dbSubnetGroupName);
            this.setDBSecurityGroups(model.dbSecurityGroups);
            this.setVpcSecurityGroupIds(model.vpcSecurityGroupIds);
            this.setApplyImmediately(model.applyImmediately);
            this.setMasterUserPassword(model.masterUserPassword);
            this.setDBParameterGroupName(model.dbParameterGroupName);
            this.setBackupRetentionPeriod(model.backupRetentionPeriod);
            this.setPreferredBackupWindow(model.preferredBackupWindow);
            this.setPreferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.setMultiAZ(model.multiAZ);
            this.setEngineVersion(model.engineVersion);
            this.setAllowMajorVersionUpgrade(model.allowMajorVersionUpgrade);
            this.setAutoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            this.setLicenseModel(model.licenseModel);
            this.setIops(model.iops);
            this.setOptionGroupName(model.optionGroupName);
            this.setNewDBInstanceIdentifier(model.newDBInstanceIdentifier);
            this.setStorageType(model.storageType);
            this.setTdeCredentialArn(model.tdeCredentialArn);
            this.setTdeCredentialPassword(model.tdeCredentialPassword);
            this.setCACertificateIdentifier(model.caCertificateIdentifier);
            this.setDomain(model.domain);
            this.setCopyTagsToSnapshot(model.copyTagsToSnapshot);
            this.setMonitoringInterval(model.monitoringInterval);
            this.setDBPortNumber(model.dbPortNumber);
            this.setPubliclyAccessible(model.publiclyAccessible);
            this.setMonitoringRoleArn(model.monitoringRoleArn);
            this.setDomainIAMRoleName(model.domainIAMRoleName);
            this.setPromotionTier(model.promotionTier);
            this.setEnableIAMDatabaseAuthentication(model.enableIAMDatabaseAuthentication);
        }

        public final String getDBInstanceIdentifier() {
            return this.dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final void setDBInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        public final Integer getAllocatedStorage() {
            return this.allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        public final String getDBInstanceClass() {
            return this.dbInstanceClass;
        }

        @Override
        public final Builder dbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        public final void setDBInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
        }

        public final String getDBSubnetGroupName() {
            return this.dbSubnetGroupName;
        }

        @Override
        public final Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        public final void setDBSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
        }

        public final Collection<String> getDBSecurityGroups() {
            return this.dbSecurityGroups;
        }

        @Override
        public final Builder dbSecurityGroups(Collection<String> dbSecurityGroups) {
            this.dbSecurityGroups = DBSecurityGroupNameListCopier.copy(dbSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSecurityGroups(String ... dbSecurityGroups) {
            this.dbSecurityGroups(Arrays.asList(dbSecurityGroups));
            return this;
        }

        public final void setDBSecurityGroups(Collection<String> dbSecurityGroups) {
            this.dbSecurityGroups = DBSecurityGroupNameListCopier.copy(dbSecurityGroups);
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            return this.vpcSecurityGroupIds;
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        public final Boolean getApplyImmediately() {
            return this.applyImmediately;
        }

        @Override
        public final Builder applyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
            return this;
        }

        public final void setApplyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
        }

        public final String getMasterUserPassword() {
            return this.masterUserPassword;
        }

        @Override
        public final Builder masterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        public final void setMasterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
        }

        public final String getDBParameterGroupName() {
            return this.dbParameterGroupName;
        }

        @Override
        public final Builder dbParameterGroupName(String dbParameterGroupName) {
            this.dbParameterGroupName = dbParameterGroupName;
            return this;
        }

        public final void setDBParameterGroupName(String dbParameterGroupName) {
            this.dbParameterGroupName = dbParameterGroupName;
        }

        public final Integer getBackupRetentionPeriod() {
            return this.backupRetentionPeriod;
        }

        @Override
        public final Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        public final void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
        }

        public final String getPreferredBackupWindow() {
            return this.preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final Boolean getMultiAZ() {
            return this.multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final Boolean getAllowMajorVersionUpgrade() {
            return this.allowMajorVersionUpgrade;
        }

        @Override
        public final Builder allowMajorVersionUpgrade(Boolean allowMajorVersionUpgrade) {
            this.allowMajorVersionUpgrade = allowMajorVersionUpgrade;
            return this;
        }

        public final void setAllowMajorVersionUpgrade(Boolean allowMajorVersionUpgrade) {
            this.allowMajorVersionUpgrade = allowMajorVersionUpgrade;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        public final String getLicenseModel() {
            return this.licenseModel;
        }

        @Override
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        public final Integer getIops() {
            return this.iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        public final String getOptionGroupName() {
            return this.optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        public final String getNewDBInstanceIdentifier() {
            return this.newDBInstanceIdentifier;
        }

        @Override
        public final Builder newDBInstanceIdentifier(String newDBInstanceIdentifier) {
            this.newDBInstanceIdentifier = newDBInstanceIdentifier;
            return this;
        }

        public final void setNewDBInstanceIdentifier(String newDBInstanceIdentifier) {
            this.newDBInstanceIdentifier = newDBInstanceIdentifier;
        }

        public final String getStorageType() {
            return this.storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        public final String getTdeCredentialArn() {
            return this.tdeCredentialArn;
        }

        @Override
        public final Builder tdeCredentialArn(String tdeCredentialArn) {
            this.tdeCredentialArn = tdeCredentialArn;
            return this;
        }

        public final void setTdeCredentialArn(String tdeCredentialArn) {
            this.tdeCredentialArn = tdeCredentialArn;
        }

        public final String getTdeCredentialPassword() {
            return this.tdeCredentialPassword;
        }

        @Override
        public final Builder tdeCredentialPassword(String tdeCredentialPassword) {
            this.tdeCredentialPassword = tdeCredentialPassword;
            return this;
        }

        public final void setTdeCredentialPassword(String tdeCredentialPassword) {
            this.tdeCredentialPassword = tdeCredentialPassword;
        }

        public final String getCACertificateIdentifier() {
            return this.caCertificateIdentifier;
        }

        @Override
        public final Builder caCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
            return this;
        }

        public final void setCACertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
        }

        public final String getDomain() {
            return this.domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final Boolean getCopyTagsToSnapshot() {
            return this.copyTagsToSnapshot;
        }

        @Override
        public final Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        public final void setCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
        }

        public final Integer getMonitoringInterval() {
            return this.monitoringInterval;
        }

        @Override
        public final Builder monitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
            return this;
        }

        public final void setMonitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
        }

        public final Integer getDBPortNumber() {
            return this.dbPortNumber;
        }

        @Override
        public final Builder dbPortNumber(Integer dbPortNumber) {
            this.dbPortNumber = dbPortNumber;
            return this;
        }

        public final void setDBPortNumber(Integer dbPortNumber) {
            this.dbPortNumber = dbPortNumber;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        public final String getMonitoringRoleArn() {
            return this.monitoringRoleArn;
        }

        @Override
        public final Builder monitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
            return this;
        }

        public final void setMonitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
        }

        public final String getDomainIAMRoleName() {
            return this.domainIAMRoleName;
        }

        @Override
        public final Builder domainIAMRoleName(String domainIAMRoleName) {
            this.domainIAMRoleName = domainIAMRoleName;
            return this;
        }

        public final void setDomainIAMRoleName(String domainIAMRoleName) {
            this.domainIAMRoleName = domainIAMRoleName;
        }

        public final Integer getPromotionTier() {
            return this.promotionTier;
        }

        @Override
        public final Builder promotionTier(Integer promotionTier) {
            this.promotionTier = promotionTier;
            return this;
        }

        public final void setPromotionTier(Integer promotionTier) {
            this.promotionTier = promotionTier;
        }

        public final Boolean getEnableIAMDatabaseAuthentication() {
            return this.enableIAMDatabaseAuthentication;
        }

        @Override
        public final Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
            return this;
        }

        public final void setEnableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
        }

        public ModifyDBInstanceRequest build() {
            return new ModifyDBInstanceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ModifyDBInstanceRequest> {
        public Builder dbInstanceIdentifier(String var1);

        public Builder allocatedStorage(Integer var1);

        public Builder dbInstanceClass(String var1);

        public Builder dbSubnetGroupName(String var1);

        public Builder dbSecurityGroups(Collection<String> var1);

        public Builder dbSecurityGroups(String ... var1);

        public Builder vpcSecurityGroupIds(Collection<String> var1);

        public Builder vpcSecurityGroupIds(String ... var1);

        public Builder applyImmediately(Boolean var1);

        public Builder masterUserPassword(String var1);

        public Builder dbParameterGroupName(String var1);

        public Builder backupRetentionPeriod(Integer var1);

        public Builder preferredBackupWindow(String var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder multiAZ(Boolean var1);

        public Builder engineVersion(String var1);

        public Builder allowMajorVersionUpgrade(Boolean var1);

        public Builder autoMinorVersionUpgrade(Boolean var1);

        public Builder licenseModel(String var1);

        public Builder iops(Integer var1);

        public Builder optionGroupName(String var1);

        public Builder newDBInstanceIdentifier(String var1);

        public Builder storageType(String var1);

        public Builder tdeCredentialArn(String var1);

        public Builder tdeCredentialPassword(String var1);

        public Builder caCertificateIdentifier(String var1);

        public Builder domain(String var1);

        public Builder copyTagsToSnapshot(Boolean var1);

        public Builder monitoringInterval(Integer var1);

        public Builder dbPortNumber(Integer var1);

        public Builder publiclyAccessible(Boolean var1);

        public Builder monitoringRoleArn(String var1);

        public Builder domainIAMRoleName(String var1);

        public Builder promotionTier(Integer var1);

        public Builder enableIAMDatabaseAuthentication(Boolean var1);
    }
}

