/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.rds.model.DBEngineVersion;
import software.amazon.awssdk.services.rds.model.DBEngineVersionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDBEngineVersionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeDBEngineVersionsResponse> {
    private final String marker;
    private final List<DBEngineVersion> dbEngineVersions;

    private DescribeDBEngineVersionsResponse(BuilderImpl builder) {
        this.marker = builder.marker;
        this.dbEngineVersions = builder.dbEngineVersions;
    }

    public String marker() {
        return this.marker;
    }

    public List<DBEngineVersion> dbEngineVersions() {
        return this.dbEngineVersions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.dbEngineVersions() == null ? 0 : this.dbEngineVersions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDBEngineVersionsResponse)) {
            return false;
        }
        DescribeDBEngineVersionsResponse other = (DescribeDBEngineVersionsResponse)((Object)obj);
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.dbEngineVersions() == null ^ this.dbEngineVersions() == null) {
            return false;
        }
        return other.dbEngineVersions() == null || other.dbEngineVersions().equals(this.dbEngineVersions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.dbEngineVersions() != null) {
            sb.append("DBEngineVersions: ").append(this.dbEngineVersions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String marker;
        private List<DBEngineVersion> dbEngineVersions;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDBEngineVersionsResponse model) {
            this.setMarker(model.marker);
            this.setDBEngineVersions(model.dbEngineVersions);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<DBEngineVersion> getDBEngineVersions() {
            return this.dbEngineVersions;
        }

        @Override
        public final Builder dbEngineVersions(Collection<DBEngineVersion> dbEngineVersions) {
            this.dbEngineVersions = DBEngineVersionListCopier.copy(dbEngineVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbEngineVersions(DBEngineVersion ... dbEngineVersions) {
            this.dbEngineVersions(Arrays.asList(dbEngineVersions));
            return this;
        }

        public final void setDBEngineVersions(Collection<DBEngineVersion> dbEngineVersions) {
            this.dbEngineVersions = DBEngineVersionListCopier.copy(dbEngineVersions);
        }

        public DescribeDBEngineVersionsResponse build() {
            return new DescribeDBEngineVersionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeDBEngineVersionsResponse> {
        public Builder marker(String var1);

        public Builder dbEngineVersions(Collection<DBEngineVersion> var1);

        public Builder dbEngineVersions(DBEngineVersion ... var1);
    }
}

