/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.rds.model.DBCluster;
import software.amazon.awssdk.services.rds.model.DBClusterListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDBClustersResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeDBClustersResponse> {
    private final String marker;
    private final List<DBCluster> dbClusters;

    private DescribeDBClustersResponse(BuilderImpl builder) {
        this.marker = builder.marker;
        this.dbClusters = builder.dbClusters;
    }

    public String marker() {
        return this.marker;
    }

    public List<DBCluster> dbClusters() {
        return this.dbClusters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.dbClusters() == null ? 0 : this.dbClusters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDBClustersResponse)) {
            return false;
        }
        DescribeDBClustersResponse other = (DescribeDBClustersResponse)((Object)obj);
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.dbClusters() == null ^ this.dbClusters() == null) {
            return false;
        }
        return other.dbClusters() == null || other.dbClusters().equals(this.dbClusters());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.dbClusters() != null) {
            sb.append("DBClusters: ").append(this.dbClusters()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String marker;
        private List<DBCluster> dbClusters;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDBClustersResponse model) {
            this.setMarker(model.marker);
            this.setDBClusters(model.dbClusters);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<DBCluster> getDBClusters() {
            return this.dbClusters;
        }

        @Override
        public final Builder dbClusters(Collection<DBCluster> dbClusters) {
            this.dbClusters = DBClusterListCopier.copy(dbClusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusters(DBCluster ... dbClusters) {
            this.dbClusters(Arrays.asList(dbClusters));
            return this;
        }

        public final void setDBClusters(Collection<DBCluster> dbClusters) {
            this.dbClusters = DBClusterListCopier.copy(dbClusters);
        }

        public DescribeDBClustersResponse build() {
            return new DescribeDBClustersResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeDBClustersResponse> {
        public Builder marker(String var1);

        public Builder dbClusters(Collection<DBCluster> var1);

        public Builder dbClusters(DBCluster ... var1);
    }
}

