/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.rds.model.AvailabilityZone;
import software.amazon.awssdk.services.rds.model.AvailabilityZoneListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class OrderableDBInstanceOption
implements ToCopyableBuilder<Builder, OrderableDBInstanceOption> {
    private final String engine;
    private final String engineVersion;
    private final String dbInstanceClass;
    private final String licenseModel;
    private final List<AvailabilityZone> availabilityZones;
    private final Boolean multiAZCapable;
    private final Boolean readReplicaCapable;
    private final Boolean vpc;
    private final Boolean supportsStorageEncryption;
    private final String storageType;
    private final Boolean supportsIops;
    private final Boolean supportsEnhancedMonitoring;
    private final Boolean supportsIAMDatabaseAuthentication;

    private OrderableDBInstanceOption(BuilderImpl builder) {
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.dbInstanceClass = builder.dbInstanceClass;
        this.licenseModel = builder.licenseModel;
        this.availabilityZones = builder.availabilityZones;
        this.multiAZCapable = builder.multiAZCapable;
        this.readReplicaCapable = builder.readReplicaCapable;
        this.vpc = builder.vpc;
        this.supportsStorageEncryption = builder.supportsStorageEncryption;
        this.storageType = builder.storageType;
        this.supportsIops = builder.supportsIops;
        this.supportsEnhancedMonitoring = builder.supportsEnhancedMonitoring;
        this.supportsIAMDatabaseAuthentication = builder.supportsIAMDatabaseAuthentication;
    }

    public String engine() {
        return this.engine;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public String dbInstanceClass() {
        return this.dbInstanceClass;
    }

    public String licenseModel() {
        return this.licenseModel;
    }

    public List<AvailabilityZone> availabilityZones() {
        return this.availabilityZones;
    }

    public Boolean multiAZCapable() {
        return this.multiAZCapable;
    }

    public Boolean readReplicaCapable() {
        return this.readReplicaCapable;
    }

    public Boolean vpc() {
        return this.vpc;
    }

    public Boolean supportsStorageEncryption() {
        return this.supportsStorageEncryption;
    }

    public String storageType() {
        return this.storageType;
    }

    public Boolean supportsIops() {
        return this.supportsIops;
    }

    public Boolean supportsEnhancedMonitoring() {
        return this.supportsEnhancedMonitoring;
    }

    public Boolean supportsIAMDatabaseAuthentication() {
        return this.supportsIAMDatabaseAuthentication;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.engine() == null ? 0 : this.engine().hashCode());
        hashCode = 31 * hashCode + (this.engineVersion() == null ? 0 : this.engineVersion().hashCode());
        hashCode = 31 * hashCode + (this.dbInstanceClass() == null ? 0 : this.dbInstanceClass().hashCode());
        hashCode = 31 * hashCode + (this.licenseModel() == null ? 0 : this.licenseModel().hashCode());
        hashCode = 31 * hashCode + (this.availabilityZones() == null ? 0 : this.availabilityZones().hashCode());
        hashCode = 31 * hashCode + (this.multiAZCapable() == null ? 0 : this.multiAZCapable().hashCode());
        hashCode = 31 * hashCode + (this.readReplicaCapable() == null ? 0 : this.readReplicaCapable().hashCode());
        hashCode = 31 * hashCode + (this.vpc() == null ? 0 : this.vpc().hashCode());
        hashCode = 31 * hashCode + (this.supportsStorageEncryption() == null ? 0 : this.supportsStorageEncryption().hashCode());
        hashCode = 31 * hashCode + (this.storageType() == null ? 0 : this.storageType().hashCode());
        hashCode = 31 * hashCode + (this.supportsIops() == null ? 0 : this.supportsIops().hashCode());
        hashCode = 31 * hashCode + (this.supportsEnhancedMonitoring() == null ? 0 : this.supportsEnhancedMonitoring().hashCode());
        hashCode = 31 * hashCode + (this.supportsIAMDatabaseAuthentication() == null ? 0 : this.supportsIAMDatabaseAuthentication().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrderableDBInstanceOption)) {
            return false;
        }
        OrderableDBInstanceOption other = (OrderableDBInstanceOption)obj;
        if (other.engine() == null ^ this.engine() == null) {
            return false;
        }
        if (other.engine() != null && !other.engine().equals(this.engine())) {
            return false;
        }
        if (other.engineVersion() == null ^ this.engineVersion() == null) {
            return false;
        }
        if (other.engineVersion() != null && !other.engineVersion().equals(this.engineVersion())) {
            return false;
        }
        if (other.dbInstanceClass() == null ^ this.dbInstanceClass() == null) {
            return false;
        }
        if (other.dbInstanceClass() != null && !other.dbInstanceClass().equals(this.dbInstanceClass())) {
            return false;
        }
        if (other.licenseModel() == null ^ this.licenseModel() == null) {
            return false;
        }
        if (other.licenseModel() != null && !other.licenseModel().equals(this.licenseModel())) {
            return false;
        }
        if (other.availabilityZones() == null ^ this.availabilityZones() == null) {
            return false;
        }
        if (other.availabilityZones() != null && !other.availabilityZones().equals(this.availabilityZones())) {
            return false;
        }
        if (other.multiAZCapable() == null ^ this.multiAZCapable() == null) {
            return false;
        }
        if (other.multiAZCapable() != null && !other.multiAZCapable().equals(this.multiAZCapable())) {
            return false;
        }
        if (other.readReplicaCapable() == null ^ this.readReplicaCapable() == null) {
            return false;
        }
        if (other.readReplicaCapable() != null && !other.readReplicaCapable().equals(this.readReplicaCapable())) {
            return false;
        }
        if (other.vpc() == null ^ this.vpc() == null) {
            return false;
        }
        if (other.vpc() != null && !other.vpc().equals(this.vpc())) {
            return false;
        }
        if (other.supportsStorageEncryption() == null ^ this.supportsStorageEncryption() == null) {
            return false;
        }
        if (other.supportsStorageEncryption() != null && !other.supportsStorageEncryption().equals(this.supportsStorageEncryption())) {
            return false;
        }
        if (other.storageType() == null ^ this.storageType() == null) {
            return false;
        }
        if (other.storageType() != null && !other.storageType().equals(this.storageType())) {
            return false;
        }
        if (other.supportsIops() == null ^ this.supportsIops() == null) {
            return false;
        }
        if (other.supportsIops() != null && !other.supportsIops().equals(this.supportsIops())) {
            return false;
        }
        if (other.supportsEnhancedMonitoring() == null ^ this.supportsEnhancedMonitoring() == null) {
            return false;
        }
        if (other.supportsEnhancedMonitoring() != null && !other.supportsEnhancedMonitoring().equals(this.supportsEnhancedMonitoring())) {
            return false;
        }
        if (other.supportsIAMDatabaseAuthentication() == null ^ this.supportsIAMDatabaseAuthentication() == null) {
            return false;
        }
        return other.supportsIAMDatabaseAuthentication() == null || other.supportsIAMDatabaseAuthentication().equals(this.supportsIAMDatabaseAuthentication());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.engine() != null) {
            sb.append("Engine: ").append(this.engine()).append(",");
        }
        if (this.engineVersion() != null) {
            sb.append("EngineVersion: ").append(this.engineVersion()).append(",");
        }
        if (this.dbInstanceClass() != null) {
            sb.append("DBInstanceClass: ").append(this.dbInstanceClass()).append(",");
        }
        if (this.licenseModel() != null) {
            sb.append("LicenseModel: ").append(this.licenseModel()).append(",");
        }
        if (this.availabilityZones() != null) {
            sb.append("AvailabilityZones: ").append(this.availabilityZones()).append(",");
        }
        if (this.multiAZCapable() != null) {
            sb.append("MultiAZCapable: ").append(this.multiAZCapable()).append(",");
        }
        if (this.readReplicaCapable() != null) {
            sb.append("ReadReplicaCapable: ").append(this.readReplicaCapable()).append(",");
        }
        if (this.vpc() != null) {
            sb.append("Vpc: ").append(this.vpc()).append(",");
        }
        if (this.supportsStorageEncryption() != null) {
            sb.append("SupportsStorageEncryption: ").append(this.supportsStorageEncryption()).append(",");
        }
        if (this.storageType() != null) {
            sb.append("StorageType: ").append(this.storageType()).append(",");
        }
        if (this.supportsIops() != null) {
            sb.append("SupportsIops: ").append(this.supportsIops()).append(",");
        }
        if (this.supportsEnhancedMonitoring() != null) {
            sb.append("SupportsEnhancedMonitoring: ").append(this.supportsEnhancedMonitoring()).append(",");
        }
        if (this.supportsIAMDatabaseAuthentication() != null) {
            sb.append("SupportsIAMDatabaseAuthentication: ").append(this.supportsIAMDatabaseAuthentication()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String engine;
        private String engineVersion;
        private String dbInstanceClass;
        private String licenseModel;
        private List<AvailabilityZone> availabilityZones;
        private Boolean multiAZCapable;
        private Boolean readReplicaCapable;
        private Boolean vpc;
        private Boolean supportsStorageEncryption;
        private String storageType;
        private Boolean supportsIops;
        private Boolean supportsEnhancedMonitoring;
        private Boolean supportsIAMDatabaseAuthentication;

        private BuilderImpl() {
        }

        private BuilderImpl(OrderableDBInstanceOption model) {
            this.setEngine(model.engine);
            this.setEngineVersion(model.engineVersion);
            this.setDBInstanceClass(model.dbInstanceClass);
            this.setLicenseModel(model.licenseModel);
            this.setAvailabilityZones(model.availabilityZones);
            this.setMultiAZCapable(model.multiAZCapable);
            this.setReadReplicaCapable(model.readReplicaCapable);
            this.setVpc(model.vpc);
            this.setSupportsStorageEncryption(model.supportsStorageEncryption);
            this.setStorageType(model.storageType);
            this.setSupportsIops(model.supportsIops);
            this.setSupportsEnhancedMonitoring(model.supportsEnhancedMonitoring);
            this.setSupportsIAMDatabaseAuthentication(model.supportsIAMDatabaseAuthentication);
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getDBInstanceClass() {
            return this.dbInstanceClass;
        }

        @Override
        public final Builder dbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        public final void setDBInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
        }

        public final String getLicenseModel() {
            return this.licenseModel;
        }

        @Override
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        public final Collection<AvailabilityZone> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<AvailabilityZone> availabilityZones) {
            this.availabilityZones = AvailabilityZoneListCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(AvailabilityZone ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<AvailabilityZone> availabilityZones) {
            this.availabilityZones = AvailabilityZoneListCopier.copy(availabilityZones);
        }

        @SafeVarargs
        public final void setAvailabilityZones(AvailabilityZone ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
        }

        public final Boolean getMultiAZCapable() {
            return this.multiAZCapable;
        }

        @Override
        public final Builder multiAZCapable(Boolean multiAZCapable) {
            this.multiAZCapable = multiAZCapable;
            return this;
        }

        public final void setMultiAZCapable(Boolean multiAZCapable) {
            this.multiAZCapable = multiAZCapable;
        }

        public final Boolean getReadReplicaCapable() {
            return this.readReplicaCapable;
        }

        @Override
        public final Builder readReplicaCapable(Boolean readReplicaCapable) {
            this.readReplicaCapable = readReplicaCapable;
            return this;
        }

        public final void setReadReplicaCapable(Boolean readReplicaCapable) {
            this.readReplicaCapable = readReplicaCapable;
        }

        public final Boolean getVpc() {
            return this.vpc;
        }

        @Override
        public final Builder vpc(Boolean vpc) {
            this.vpc = vpc;
            return this;
        }

        public final void setVpc(Boolean vpc) {
            this.vpc = vpc;
        }

        public final Boolean getSupportsStorageEncryption() {
            return this.supportsStorageEncryption;
        }

        @Override
        public final Builder supportsStorageEncryption(Boolean supportsStorageEncryption) {
            this.supportsStorageEncryption = supportsStorageEncryption;
            return this;
        }

        public final void setSupportsStorageEncryption(Boolean supportsStorageEncryption) {
            this.supportsStorageEncryption = supportsStorageEncryption;
        }

        public final String getStorageType() {
            return this.storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        public final Boolean getSupportsIops() {
            return this.supportsIops;
        }

        @Override
        public final Builder supportsIops(Boolean supportsIops) {
            this.supportsIops = supportsIops;
            return this;
        }

        public final void setSupportsIops(Boolean supportsIops) {
            this.supportsIops = supportsIops;
        }

        public final Boolean getSupportsEnhancedMonitoring() {
            return this.supportsEnhancedMonitoring;
        }

        @Override
        public final Builder supportsEnhancedMonitoring(Boolean supportsEnhancedMonitoring) {
            this.supportsEnhancedMonitoring = supportsEnhancedMonitoring;
            return this;
        }

        public final void setSupportsEnhancedMonitoring(Boolean supportsEnhancedMonitoring) {
            this.supportsEnhancedMonitoring = supportsEnhancedMonitoring;
        }

        public final Boolean getSupportsIAMDatabaseAuthentication() {
            return this.supportsIAMDatabaseAuthentication;
        }

        @Override
        public final Builder supportsIAMDatabaseAuthentication(Boolean supportsIAMDatabaseAuthentication) {
            this.supportsIAMDatabaseAuthentication = supportsIAMDatabaseAuthentication;
            return this;
        }

        public final void setSupportsIAMDatabaseAuthentication(Boolean supportsIAMDatabaseAuthentication) {
            this.supportsIAMDatabaseAuthentication = supportsIAMDatabaseAuthentication;
        }

        public OrderableDBInstanceOption build() {
            return new OrderableDBInstanceOption(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, OrderableDBInstanceOption> {
        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder dbInstanceClass(String var1);

        public Builder licenseModel(String var1);

        public Builder availabilityZones(Collection<AvailabilityZone> var1);

        public Builder availabilityZones(AvailabilityZone ... var1);

        public Builder multiAZCapable(Boolean var1);

        public Builder readReplicaCapable(Boolean var1);

        public Builder vpc(Boolean var1);

        public Builder supportsStorageEncryption(Boolean var1);

        public Builder storageType(String var1);

        public Builder supportsIops(Boolean var1);

        public Builder supportsEnhancedMonitoring(Boolean var1);

        public Builder supportsIAMDatabaseAuthentication(Boolean var1);
    }
}

