/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.rds.model.OptionGroup;
import software.amazon.awssdk.services.rds.model.OptionGroupsListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeOptionGroupsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeOptionGroupsResponse> {
    private final List<OptionGroup> optionGroupsList;
    private final String marker;

    private DescribeOptionGroupsResponse(BuilderImpl builder) {
        this.optionGroupsList = builder.optionGroupsList;
        this.marker = builder.marker;
    }

    public List<OptionGroup> optionGroupsList() {
        return this.optionGroupsList;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.optionGroupsList() == null ? 0 : this.optionGroupsList().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOptionGroupsResponse)) {
            return false;
        }
        DescribeOptionGroupsResponse other = (DescribeOptionGroupsResponse)((Object)obj);
        if (other.optionGroupsList() == null ^ this.optionGroupsList() == null) {
            return false;
        }
        if (other.optionGroupsList() != null && !other.optionGroupsList().equals(this.optionGroupsList())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.optionGroupsList() != null) {
            sb.append("OptionGroupsList: ").append(this.optionGroupsList()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<OptionGroup> optionGroupsList;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOptionGroupsResponse model) {
            this.setOptionGroupsList(model.optionGroupsList);
            this.setMarker(model.marker);
        }

        public final Collection<OptionGroup> getOptionGroupsList() {
            return this.optionGroupsList;
        }

        @Override
        public final Builder optionGroupsList(Collection<OptionGroup> optionGroupsList) {
            this.optionGroupsList = OptionGroupsListCopier.copy(optionGroupsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionGroupsList(OptionGroup ... optionGroupsList) {
            this.optionGroupsList(Arrays.asList(optionGroupsList));
            return this;
        }

        public final void setOptionGroupsList(Collection<OptionGroup> optionGroupsList) {
            this.optionGroupsList = OptionGroupsListCopier.copy(optionGroupsList);
        }

        @SafeVarargs
        public final void setOptionGroupsList(OptionGroup ... optionGroupsList) {
            this.optionGroupsList(Arrays.asList(optionGroupsList));
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public DescribeOptionGroupsResponse build() {
            return new DescribeOptionGroupsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeOptionGroupsResponse> {
        public Builder optionGroupsList(Collection<OptionGroup> var1);

        public Builder optionGroupsList(OptionGroup ... var1);

        public Builder marker(String var1);
    }
}

