/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.rds.model.DBParameterGroup;
import software.amazon.awssdk.services.rds.model.DBParameterGroupListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDBParameterGroupsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeDBParameterGroupsResponse> {
    private final String marker;
    private final List<DBParameterGroup> dbParameterGroups;

    private DescribeDBParameterGroupsResponse(BuilderImpl builder) {
        this.marker = builder.marker;
        this.dbParameterGroups = builder.dbParameterGroups;
    }

    public String marker() {
        return this.marker;
    }

    public List<DBParameterGroup> dbParameterGroups() {
        return this.dbParameterGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.dbParameterGroups() == null ? 0 : this.dbParameterGroups().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDBParameterGroupsResponse)) {
            return false;
        }
        DescribeDBParameterGroupsResponse other = (DescribeDBParameterGroupsResponse)((Object)obj);
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.dbParameterGroups() == null ^ this.dbParameterGroups() == null) {
            return false;
        }
        return other.dbParameterGroups() == null || other.dbParameterGroups().equals(this.dbParameterGroups());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.dbParameterGroups() != null) {
            sb.append("DBParameterGroups: ").append(this.dbParameterGroups()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String marker;
        private List<DBParameterGroup> dbParameterGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDBParameterGroupsResponse model) {
            this.setMarker(model.marker);
            this.setDBParameterGroups(model.dbParameterGroups);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<DBParameterGroup> getDBParameterGroups() {
            return this.dbParameterGroups;
        }

        @Override
        public final Builder dbParameterGroups(Collection<DBParameterGroup> dbParameterGroups) {
            this.dbParameterGroups = DBParameterGroupListCopier.copy(dbParameterGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbParameterGroups(DBParameterGroup ... dbParameterGroups) {
            this.dbParameterGroups(Arrays.asList(dbParameterGroups));
            return this;
        }

        public final void setDBParameterGroups(Collection<DBParameterGroup> dbParameterGroups) {
            this.dbParameterGroups = DBParameterGroupListCopier.copy(dbParameterGroups);
        }

        @SafeVarargs
        public final void setDBParameterGroups(DBParameterGroup ... dbParameterGroups) {
            this.dbParameterGroups(Arrays.asList(dbParameterGroups));
        }

        public DescribeDBParameterGroupsResponse build() {
            return new DescribeDBParameterGroupsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeDBParameterGroupsResponse> {
        public Builder marker(String var1);

        public Builder dbParameterGroups(Collection<DBParameterGroup> var1);

        public Builder dbParameterGroups(DBParameterGroup ... var1);
    }
}

